/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.contexts;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.elaboration.expressions.EAmbiguous;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EPlaceholder;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintSolver;
import org.simantics.scl.compiler.internal.elaboration.constraints.ExpressionAugmentation;
import org.simantics.scl.compiler.internal.elaboration.constraints.ReducedConstraints;
import org.simantics.scl.compiler.internal.elaboration.subsumption.SubSolver;
import org.simantics.scl.compiler.internal.elaboration.subsumption.Subsumption;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TypingContext {
    private CompilationContext compilationContext;
    private ArrayList<Subsumption> effectSubsumptions = new ArrayList();
    private ArrayList<Subsumption> subsumptions = new ArrayList();
    private ArrayList<Type> potentialSingletonEffects = new ArrayList();
    private ArrayList<Type> effectUpperBounds = new ArrayList();
    private ArrayList<EVariable> constraintDemand = new ArrayList();
    private ArrayList<Variable[]> constraintFrames = new ArrayList();
    private boolean isInPattern;
    public THashSet<SCLValue> recursiveValues;
    public ArrayList<EPlaceholder> recursiveReferences;
    public ArrayList<EAmbiguous> overloadedExpressions = new ArrayList();
    Environment environment;

    public TypingContext(CompilationContext compilationContext) {
        this.compilationContext = compilationContext;
        this.environment = compilationContext.environment;
    }

    public void subsumeEffect(long loc, Type a, Type b) {
        if ((a = Types.canonical(a)) == Types.NO_EFFECTS) {
            return;
        }
        if (a == (b = Types.canonical(b))) {
            return;
        }
        if (b == Types.NO_EFFECTS) {
            try {
                Types.unify(a, (Type)Types.NO_EFFECTS);
            }
            catch (UnificationException unificationException) {
                this.compilationContext.errorLog.log(loc, "No side-effects allowed here.");
                return;
            }
        }
        this.effectSubsumptions.add(new Subsumption(loc, a, b));
    }

    public void subsume(long loc, Type a, Type b) throws UnificationException {
        if ((a = Types.canonical(a)) == (b = Types.canonical(b))) {
            return;
        }
        if (a instanceof TMetaVar) {
            TMetaVar aVar = (TMetaVar)a;
            if (b instanceof TMetaVar) {
                this.subsumptions.add(new Subsumption(loc, a, b));
            } else {
                if (b.contains(aVar)) {
                    throw new UnificationException(a, b);
                }
                aVar.setRef(this.createSubtypeTemplate(loc, b));
            }
            return;
        }
        if (b instanceof TMetaVar) {
            TMetaVar bVar = (TMetaVar)b;
            if (a.contains(bVar)) {
                throw new UnificationException(a, b);
            }
            bVar.setRef(this.createSupertypeTemplate(loc, a));
            return;
        }
        if (a instanceof TFun) {
            if (!(b instanceof TFun)) {
                throw new UnificationException(a, b);
            }
            TFun aFun = (TFun)a;
            TFun bFun = (TFun)b;
            this.subsume(loc, bFun.domain, aFun.domain);
            this.subsumeEffect(loc, aFun.effect, bFun.effect);
            this.subsume(loc, aFun.range, bFun.range);
        } else if (a instanceof TApply) {
            Types.unify(a, b);
        } else if (a instanceof TPred) {
            Types.unify(a, b);
        } else {
            throw new UnificationException(a, b);
        }
    }

    private Type createSubtypeTemplate(long loc, Type type) {
        if ((type = Types.canonical(type)) instanceof TCon) {
            return type;
        }
        if (type instanceof TApply) {
            return type;
        }
        if (type instanceof TPred) {
            return type;
        }
        if (type instanceof TFun) {
            Type effect;
            TFun fun = (TFun)type;
            Type funEffect = Types.canonical(fun.effect);
            if (funEffect == Types.NO_EFFECTS) {
                effect = Types.NO_EFFECTS;
            } else {
                effect = Types.metaVar(Kinds.EFFECT);
                this.effectSubsumptions.add(new Subsumption(loc, effect, funEffect));
            }
            return Types.functionE(this.createSupertypeTemplate(loc, fun.domain), effect, this.createSubtypeTemplate(loc, fun.range));
        }
        if (type instanceof TMetaVar) {
            TMetaVar var = (TMetaVar)type;
            TMetaVar newVar = Types.metaVar(var.getKind());
            this.subsumptions.add(new Subsumption(loc, newVar, var));
            return newVar;
        }
        if (type instanceof TVar) {
            return type;
        }
        if (type instanceof TUnion) {
            TUnion union = (TUnion)type;
            if (union.isMinimal()) {
                return type;
            }
            TMetaVar newVar = Types.metaVar(Kinds.EFFECT);
            this.subsumptions.add(new Subsumption(loc, newVar, type));
            return newVar;
        }
        if (type instanceof TForAll) {
            TForAll forAll = (TForAll)type;
            Type t = this.createSubtypeTemplate(loc, forAll.type);
            if (t == forAll.type) {
                return type;
            }
            return Types.forAll(forAll.var, t);
        }
        throw new InternalCompilerError("Unsupported type " + type + ".");
    }

    private Type createSupertypeTemplate(long loc, Type type) {
        if ((type = Types.canonical(type)) instanceof TCon) {
            return type;
        }
        if (type instanceof TApply) {
            return type;
        }
        if (type instanceof TPred) {
            return type;
        }
        if (type instanceof TFun) {
            TFun fun = (TFun)type;
            TMetaVar effect = Types.metaVar(Kinds.EFFECT);
            this.effectSubsumptions.add(new Subsumption(loc, fun.effect, effect));
            return Types.functionE(this.createSubtypeTemplate(loc, fun.domain), (Type)effect, this.createSupertypeTemplate(loc, fun.range));
        }
        if (type instanceof TMetaVar) {
            TMetaVar var = (TMetaVar)type;
            TMetaVar newVar = Types.metaVar(var.getKind());
            this.subsumptions.add(new Subsumption(loc, var, newVar));
            return newVar;
        }
        if (type instanceof TVar) {
            return type;
        }
        if (type instanceof TUnion) {
            TMetaVar newVar = Types.metaVar(Kinds.EFFECT);
            this.subsumptions.add(new Subsumption(loc, type, newVar));
            return newVar;
        }
        if (type instanceof TForAll) {
            TForAll forAll = (TForAll)type;
            Type t = this.createSupertypeTemplate(loc, forAll.type);
            if (t == forAll.type) {
                return type;
            }
            return Types.forAll(forAll.var, t);
        }
        throw new InternalCompilerError("Unsupported type " + type + ".");
    }

    public Expression instantiate(Expression expr) {
        Type type = Types.canonical(expr.getType());
        while (type instanceof TForAll) {
            TForAll forAll = (TForAll)type;
            TVar var = forAll.var;
            TMetaVar mVar = Types.metaVar(var.getKind());
            type = Types.canonical(forAll.type).replace(var, mVar);
            expr = expr.applyType(mVar);
        }
        while (type instanceof TFun) {
            TFun fun = (TFun)type;
            if (fun.domain instanceof TPred) {
                TPred pred = (TPred)fun.domain;
                type = fun.range;
                long loc = expr.getLocation();
                EVariable var = new EVariable(loc, null);
                var.setType(pred);
                expr = new EApply(loc, expr, var);
                this.addConstraintDemand(var);
                continue;
            }
            if (fun.domain != Types.PUNIT) break;
            type = fun.range;
            long loc = expr.getLocation();
            this.declareEffect(expr.location, fun.effect);
            expr = new EApply(loc, fun.effect, expr, new ELiteral(loc, NoRepConstant.PUNIT));
        }
        expr.setType(type);
        return expr;
    }

    public Expression subsume(Expression expr, Type b) {
        b = Types.canonical(b);
        expr = this.instantiate(expr);
        try {
            this.subsume(expr.getLocation(), expr.getType(), b);
        }
        catch (UnificationException unificationException) {
            this.typeError(expr.getLocation(), b, expr.getType());
        }
        return expr;
    }

    private boolean expandSubsumptions() {
        boolean nontrivialSubs = true;
        int iterationCount = 0;
        while (!this.subsumptions.isEmpty() && nontrivialSubs) {
            ArrayList<Subsumption> oldSubsumptions = this.subsumptions;
            this.subsumptions = new ArrayList();
            nontrivialSubs = false;
            for (Subsumption sub : oldSubsumptions) {
                Type a = sub.a = Types.canonical(sub.a);
                sub.b = Types.canonical(sub.b);
                Type b = sub.b;
                if (b instanceof TMetaVar && a instanceof TMetaVar) {
                    this.subsumptions.add(sub);
                    continue;
                }
                try {
                    this.subsume(sub.loc, a, b);
                }
                catch (UnificationException unificationException) {
                    this.compilationContext.errorLog.log(sub.loc, "Type " + a + " is not a subtype of " + b + ".");
                }
                nontrivialSubs = true;
            }
            if (++iterationCount != 5) continue;
            THashMap metaVarMap = new THashMap();
            ArrayList<Subsumption> subCopies = new ArrayList<Subsumption>(this.subsumptions.size());
            for (Subsumption sub : this.subsumptions) {
                if (this.isEffect(sub.a)) continue;
                subCopies.add(new Subsumption(sub.loc, sub.a.copySkeleton((THashMap<TMetaVar, TMetaVar>)metaVarMap), sub.b.copySkeleton((THashMap<TMetaVar, TMetaVar>)metaVarMap)));
            }
            for (Subsumption sub : subCopies) {
                try {
                    Types.unify(sub.a, sub.b);
                }
                catch (UnificationException unificationException) {
                    this.compilationContext.errorLog.log(sub.loc, "Unification of types failed.");
                    return false;
                }
            }
        }
        for (Subsumption sub : this.subsumptions) {
            try {
                Types.unify(sub.a, sub.b);
            }
            catch (UnificationException unificationException) {
                throw new InternalCompilerError();
            }
        }
        this.subsumptions.clear();
        return true;
    }

    private boolean isEffect(Type type) {
        if (type instanceof TMetaVar) {
            return ((TMetaVar)type).getKind() == Kinds.EFFECT;
        }
        if (type instanceof TCon) {
            return this.environment.getTypeDescriptor((TCon)type).getKind() == Kinds.EFFECT;
        }
        if (type instanceof TVar) {
            return ((TVar)type).getKind() == Kinds.EFFECT;
        }
        return type instanceof TUnion;
    }

    public void solveSubsumptions(long globalLoc) {
        if (this.expandSubsumptions()) {
            new SubSolver(this.compilationContext.errorLog, this.effectSubsumptions, this.potentialSingletonEffects, globalLoc).solve();
        }
    }

    public void declareEffect(long loc, Type effect) {
        this.subsumeEffect(loc, effect, this.effectUpperBounds.get(this.effectUpperBounds.size() - 1));
    }

    public void pushEffectUpperBound(long loc, Type effect) {
        this.effectUpperBounds.add(effect);
        this.potentialSingletonEffects.add(effect);
    }

    public Type popEffectUpperBound() {
        return this.effectUpperBounds.remove(this.effectUpperBounds.size() - 1);
    }

    public ErrorLog getErrorLog() {
        return this.compilationContext.errorLog;
    }

    public boolean isInPattern() {
        return this.isInPattern;
    }

    public void setInPattern(boolean isInPattern) {
        this.isInPattern = isInPattern;
    }

    public void pushConstraintFrame(Variable[] array) {
        this.constraintFrames.add(array);
    }

    public void popConstraintFrame() {
        this.constraintFrames.remove(this.constraintFrames.size() - 1);
    }

    public void addConstraintDemand(EVariable var) {
        int i = this.constraintFrames.size() - 1;
        while (i >= 0) {
            Variable[] variableArray = this.constraintFrames.get(i);
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable con = variableArray[n2];
                if (Types.equals(var.getType(), con.getType())) {
                    var.setVariable(con);
                    return;
                }
                ++n2;
            }
            --i;
        }
        this.constraintDemand.add(var);
    }

    public Expression addConstraint(TPred pred) {
        EVariable evidence = new EVariable(null);
        evidence.setType(pred);
        this.addConstraintDemand(evidence);
        return evidence;
    }

    public Expression[] addConstraints(TPred[] preds) {
        if (preds.length == 0) {
            return Expression.EMPTY_ARRAY;
        }
        Expression[] evidences = new Expression[preds.length];
        int i = 0;
        while (i < preds.length) {
            evidences[i] = this.addConstraint(preds[i]);
            ++i;
        }
        return evidences;
    }

    public ArrayList<EVariable> getConstraintDemand() {
        return this.constraintDemand;
    }

    public void resetConstraintDemand() {
        this.constraintDemand = new ArrayList();
    }

    public void typeError(long loc, Type requiredType, Type givenType) {
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        this.compilationContext.errorLog.log(loc, "Expected <" + requiredType.toString(tuc) + "> got <" + givenType.toString(tuc) + ">.");
    }

    public Expression solveConstraints(Environment environment, Expression expression) {
        ArrayList<EVariable> constraintDemand = this.getConstraintDemand();
        if (!constraintDemand.isEmpty()) {
            ConstraintEnvironment ce = new ConstraintEnvironment(environment);
            ReducedConstraints red = ConstraintSolver.solve(ce, new ArrayList<TPred>(0), constraintDemand, true);
            expression = ExpressionAugmentation.augmentSolved(red.solvedConstraints, expression);
            for (Constraint c : red.unsolvedConstraints) {
                this.compilationContext.errorLog.log(c.getDemandLocation(), "There is no instance for <" + c.constraint + ">.");
            }
        } else {
            expression = expression.decomposeMatching();
        }
        return expression;
    }

    public Environment getEnvironment() {
        return this.compilationContext.environment;
    }

    public CompilationContext getCompilationContext() {
        return this.compilationContext;
    }
}

