/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.contexts;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.common.precedence.Associativity;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EAmbiguous;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.accessor.IdAccessor;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.query.pre.PreQuery;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.environment.LocalEnvironment;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.types.Type;

public class TranslationContext
extends TypeTranslationContext
implements EnvironmentalContext {
    THashMap<String, Variable> variables = new THashMap();
    ArrayList<Entry> variableEntries = new ArrayList();
    LocalEnvironment localEnvironment;
    TIntArrayList frames = new TIntArrayList();
    ArrayList<THashSet<String>> frameNameSets = new ArrayList();
    ArrayList<ExistentialFrame> existentialFrames = new ArrayList(2);
    SCLValue bindFunction;
    public PreQuery currentPreQuery;
    THashMap<String, SCLRelation> relations = new THashMap();
    TIntArrayList relationFrames = new TIntArrayList();
    ArrayList<RelationEntry> relationEntries = new ArrayList();
    THashMap<String, CHRConstraint> chrConstraints = new THashMap();
    TIntArrayList chrConstraintFrames = new TIntArrayList();
    ArrayList<CHRConstraintEntry> chrConstraintEntries = new ArrayList();
    public CHRRuleset currentRuleset;

    public TranslationContext(CompilationContext compilationContext, LocalEnvironment localEnvironment) {
        super(compilationContext);
        this.localEnvironment = localEnvironment;
    }

    public static boolean isConstructorName(String name) {
        int p = name.lastIndexOf(46);
        char firstChar = name.charAt(p < 0 ? 0 : p + 1);
        return Character.isUpperCase(firstChar);
    }

    private Expression resolveLocalVariable(long location, String name) {
        Variable variable = (Variable)this.variables.get((Object)name);
        if (variable != null) {
            return new EVariable(location, variable);
        }
        char c = name.charAt(0);
        switch (c) {
            case '?': {
                ExistentialFrame existentialFrame = this.getCurrentExistentialFrame();
                if (existentialFrame == null || existentialFrame.disallowNewExistentials) {
                    this.errorLog.log(location, "New existential variables can be defined only in queries.");
                    return new EError(location);
                }
                variable = new Variable(name);
                this.variables.put((Object)name, (Object)variable);
                existentialFrame.variables.add((Object)name);
                return new EVariable(variable);
            }
            case '_': {
                if (name.length() != 1) break;
                ExistentialFrame existentialFrame = this.getCurrentExistentialFrame();
                if (existentialFrame == null || existentialFrame.disallowNewExistentials) {
                    this.errorLog.log(location, "Blank variables can be used only in queries.");
                    return new EError(location);
                }
                return existentialFrame.createBlank(location);
            }
        }
        return null;
    }

    public ExistentialFrame getCurrentExistentialFrame() {
        int size = this.existentialFrames.size();
        if (size == 0) {
            return null;
        }
        return this.existentialFrames.get(size - 1);
    }

    private Expression resolveFieldAccess(long location, Expression base, int pos, String name) {
        while (pos != -1) {
            int p = TranslationContext.findSeparator(name, pos + 1);
            int endPos = p == -1 ? name.length() : p;
            IdAccessor accessor = new IdAccessor(name.charAt(pos), name.substring(pos + 1, endPos));
            accessor.location = Locations.sublocation(location, pos + 1, endPos);
            base = new EFieldAccess(base, accessor);
            base.location = Locations.sublocation(location, 0, endPos);
            pos = p;
        }
        return base;
    }

    private static int findSeparator(String name, int fromIndex) {
        ++fromIndex;
        while (fromIndex < name.length()) {
            char c = name.charAt(fromIndex);
            if (c == '.' || c == '#') {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public Expression resolveValue(long location, Namespace namespace, String name) {
        SCLValue value;
        block4: {
            try {
                value = namespace.getValue(name);
                if (value != null) break block4;
                return null;
            }
            catch (AmbiguousNameException e) {
                return this.resolveAmbigious(location, e.conflictingModules, name);
            }
        }
        String deprecatedDescription = value.isDeprecated();
        if (deprecatedDescription != null) {
            this.errorLog.logWarning(location, "Deprecated value " + value.getName().name + "." + (deprecatedDescription.isEmpty() ? "" : " " + deprecatedDescription));
        }
        return new EConstant(location, value);
    }

    private Expression resolveAmbigious(final long location, String[] conflictingModules, String name) {
        EAmbiguous.Alternative[] alternatives = new EAmbiguous.Alternative[conflictingModules.length];
        int i = 0;
        while (i < conflictingModules.length) {
            Name altName = Name.create(conflictingModules[i], name);
            final SCLValue altValue = this.environment.getValue(altName);
            alternatives[i] = new EAmbiguous.Alternative(){

                @Override
                public Type getType() {
                    return altValue.getType();
                }

                @Override
                public Expression realize() {
                    EConstant expression = new EConstant(altValue);
                    expression.location = location;
                    return expression;
                }

                public String toString() {
                    return altValue.getName().toString().replace('/', '.');
                }
            };
            ++i;
        }
        EAmbiguous expression = new EAmbiguous(alternatives);
        expression.location = location;
        return expression;
    }

    public Expression resolveVariable(long location, Namespace namespace, String name, int begin) {
        Namespace childNamespace;
        Expression result;
        String part;
        int end = TranslationContext.findSeparator(name, begin);
        String string = end == -1 ? (begin == 0 ? name : name.substring(begin)) : (part = name.substring(begin, end));
        if (begin == 0) {
            result = this.resolveLocalVariable(location, part);
            if (result != null) {
                return end == -1 ? result : this.resolveFieldAccess(location, result, end, name);
            }
            if (this.localEnvironment != null && (result = this.localEnvironment.resolve(this.environment, name)) != null) {
                result.setLocationDeep(location);
                return result;
            }
        }
        if (end != -1 && name.charAt(end) == '.' && (childNamespace = namespace.getNamespace(part)) != null) {
            return this.resolveVariable(location, childNamespace, name, end + 1);
        }
        result = null;
        if (end != -1) {
            int end2 = name.length();
            while (end2 > end) {
                part = name.substring(begin, end2);
                result = this.resolveValue(location, namespace, part);
                if (result != null) {
                    end = end2 == name.length() ? -1 : end2;
                    break;
                }
                end2 = name.lastIndexOf(46, end2 - 1);
            }
        }
        if (result == null) {
            result = this.resolveValue(location, namespace, part);
        }
        if (result != null) {
            return end == -1 ? result : this.resolveFieldAccess(location, result, end, name);
        }
        this.reportResolveFailure(location, namespace, part);
        return new EError(location);
    }

    private void reportResolveFailure(long location, Namespace namespace, final String name) {
        StringBuilder message = new StringBuilder();
        message.append("Couldn't resolve ").append(name).append(".");
        final THashSet candidateNames = new THashSet(4);
        namespace.findValuesForPrefix("", AcceptAllNamespaceFilter.INSTANCE, new TObjectProcedure<SCLValue>(){

            public boolean execute(SCLValue value) {
                if (value == null) {
                    new Exception().printStackTrace();
                    return true;
                }
                String valueName = value.getName().name;
                if (name.equalsIgnoreCase(valueName)) {
                    candidateNames.add((Object)valueName);
                }
                return true;
            }
        });
        if (this.localEnvironment != null) {
            this.localEnvironment.forNames(new TObjectProcedure<String>(){

                public boolean execute(String valueName) {
                    if (name.equalsIgnoreCase(valueName)) {
                        candidateNames.add((Object)valueName);
                    }
                    return true;
                }
            });
        }
        if (candidateNames.size() > 0) {
            message.append(" Did you mean ");
            Object[] ns = (String[])candidateNames.toArray((Object[])new String[candidateNames.size()]);
            Arrays.sort(ns);
            int i = 0;
            while (i < ns.length) {
                if (i > 0) {
                    message.append(", ");
                    if (i == ns.length - 1) {
                        message.append("or ");
                    }
                }
                message.append((String)ns[i]);
                ++i;
            }
            message.append('?');
        }
        this.errorLog.log(location, message.toString());
    }

    public Expression resolveVariable(long location, String name) {
        return this.resolveVariable(location, this.environment.getLocalNamespace(), name, 0);
    }

    public Expression resolvePattern(EVar name) {
        char firstChar = name.name.charAt(0);
        if (firstChar == '_' && name.name.length() == 1) {
            return new EVariable(new Variable("_"));
        }
        if (!Character.isUpperCase(firstChar)) {
            if (!this.frameNameSets.get(this.frameNameSets.size() - 1).add((Object)name.name)) {
                this.errorLog.log(name.location, "Repeated variable " + name.name + " in pattern.");
            }
            return new EVariable(name.location, this.newVariable(name.name));
        }
        return this.resolveVariable(name.location, name.name);
    }

    public void pushFrame() {
        this.frames.add(this.variableEntries.size());
        this.frameNameSets.add((THashSet<String>)new THashSet());
    }

    public void popFrame() {
        int frame = this.frames.removeAt(this.frames.size() - 1);
        int i = this.variableEntries.size();
        while (i > frame) {
            Entry entry = this.variableEntries.remove(--i);
            if (entry.variable == null) {
                this.variables.remove((Object)entry.name);
                continue;
            }
            this.variables.put((Object)entry.name, (Object)entry.variable);
        }
        this.frameNameSets.remove(this.frameNameSets.size() - 1);
    }

    public void pushRelationFrame() {
        this.relationFrames.add(this.relationEntries.size());
    }

    public void popRelationFrame() {
        int frame = this.relationFrames.removeAt(this.relationFrames.size() - 1);
        int i = this.relationEntries.size();
        while (i > frame) {
            RelationEntry entry = this.relationEntries.remove(--i);
            if (entry.relation == null) {
                this.relations.remove((Object)entry.name);
                continue;
            }
            this.relations.put((Object)entry.name, (Object)entry.relation);
        }
    }

    public void pushCHRConstraintFrame() {
        this.chrConstraintFrames.add(this.chrConstraintEntries.size());
    }

    public void popCHRConstraintFrame(ArrayList<CHRConstraint> constraints) {
        int frame = this.chrConstraintFrames.removeAt(this.chrConstraintFrames.size() - 1);
        int i = this.chrConstraintEntries.size();
        while (i > frame) {
            CHRConstraintEntry entry = this.chrConstraintEntries.remove(--i);
            CHRConstraint newConstraint = entry.constraint == null ? (CHRConstraint)this.chrConstraints.remove((Object)entry.name) : (CHRConstraint)this.chrConstraints.put((Object)entry.name, (Object)entry.constraint);
            if (!newConstraint.implicitlyDeclared) continue;
            constraints.add(newConstraint);
        }
    }

    public void pushExistentialFrame() {
        this.pushFrame();
        this.existentialFrames.add(new ExistentialFrame());
    }

    public Variable[] popExistentialFrame() {
        this.popFrame();
        ExistentialFrame frame = this.existentialFrames.remove(this.existentialFrames.size() - 1);
        Variable[] result = new Variable[frame.variables.size() + frame.blanks.size()];
        int i = 0;
        for (String name : frame.variables) {
            result[i++] = (Variable)this.variables.remove((Object)name);
        }
        for (Variable blank : frame.blanks) {
            result[i++] = blank;
        }
        return result;
    }

    public Variable newVariable(String name) {
        Variable variable = new Variable(name);
        Variable oldVariable = (Variable)this.variables.put((Object)name, (Object)variable);
        this.variableEntries.add(new Entry(name, oldVariable));
        return variable;
    }

    public THashMap<String, Variable> getVariables() {
        return this.variables;
    }

    public void newRelation(String name, SCLRelation relation) {
        SCLRelation oldRelation = (SCLRelation)this.relations.put((Object)name, (Object)relation);
        this.relationEntries.add(new RelationEntry(name, oldRelation));
    }

    public void newCHRConstraint(String name, CHRConstraint constraint) {
        CHRConstraint oldConstraint = (CHRConstraint)this.chrConstraints.put((Object)name, (Object)constraint);
        this.chrConstraintEntries.add(new CHRConstraintEntry(name, oldConstraint));
    }

    public Precedence getPrecedence(Name op) {
        Precedence prec = this.environment.getValue(op).getPrecedence();
        if (prec == null) {
            return new Precedence(1, Associativity.NONASSOC);
        }
        return prec;
    }

    public Case translateCase(Expression lhs, Expression rhs) {
        ArrayList<Expression> parameters = new ArrayList<Expression>(4);
        lhs.getParameters(this, parameters);
        Expression[] patterns = new Expression[parameters.size()];
        this.pushFrame();
        int i = 0;
        while (i < patterns.length) {
            Expression pattern = parameters.get(i);
            patterns[i] = pattern = pattern.resolveAsPattern(this);
            ++i;
        }
        rhs = rhs.resolve(this);
        this.popFrame();
        Case case_ = new Case(patterns, rhs);
        case_.setLhs(lhs.location);
        return case_;
    }

    public Expression translateCases2(ArrayList<DValueAst> definitions) {
        Case[] cases = new Case[definitions.size()];
        int i = 0;
        while (i < cases.length) {
            DValueAst def = definitions.get(i);
            cases[i] = this.translateCase(def.lhs, def.value);
            ++i;
        }
        int arity = cases[0].patterns.length;
        int i2 = 1;
        while (i2 < cases.length) {
            if (cases[i2].patterns.length != arity) {
                this.errorLog.log(definitions.get((int)i2).lhs.location, "Inconsistent arity. This case has arity " + cases[i2].patterns.length + " while previous cases had arity " + arity + ".");
            }
            ++i2;
        }
        if (cases.length == 1 && cases[0].patterns.length == 0) {
            return cases[0].value;
        }
        return new ELambda(Locations.combine(definitions.get((int)0).location, definitions.get((int)(definitions.size() - 1)).location), cases);
    }

    public Expression translateCases(ArrayList<LetStatement> definitions) {
        Case[] cases = new Case[definitions.size()];
        int i = 0;
        while (i < cases.length) {
            LetStatement def = definitions.get(i);
            cases[i] = this.translateCase(def.pattern, def.value);
            ++i;
        }
        int arity = cases[0].patterns.length;
        int i2 = 1;
        while (i2 < cases.length) {
            if (cases[i2].patterns.length != arity) {
                this.errorLog.log(definitions.get((int)i2).pattern.location, "Inconsistent arity. This case has arity " + cases[i2].patterns.length + " while previous cases had arity " + arity + ".");
            }
            ++i2;
        }
        if (arity == 0) {
            if (cases.length > 1) {
                this.errorLog.log(cases[1].value.location, "Cannot give multiple cases for arity 0 function.");
            }
            return cases[0].value;
        }
        return new ELambda(Locations.combine(definitions.get((int)0).location, definitions.get((int)(definitions.size() - 1)).location), cases);
    }

    public SCLValue getBindFunction() {
        if (this.bindFunction == null) {
            this.bindFunction = this.getEnvironment().getValue(Names.Prelude_bind);
        }
        return this.bindFunction;
    }

    public SCLRelation resolveRelation(long location, String name) {
        SCLRelation relation = (SCLRelation)this.relations.get((Object)name);
        if (relation != null) {
            return relation;
        }
        try {
            relation = Environments.getRelation(this.environment, name);
            return relation;
        }
        catch (AmbiguousNameException e) {
            this.errorLog.log(location, e.getMessage());
            return null;
        }
    }

    public CHRConstraint resolveCHRConstraint(String name) {
        return (CHRConstraint)this.chrConstraints.get((Object)name);
    }

    @Override
    public SCLValue getValue(Name name) {
        return this.environment.getValue(name);
    }

    public CHRRuleset resolveRuleset(String name) throws AmbiguousNameException {
        return Environments.getRuleset(this.environment, name);
    }

    public void disallowNewExistentials() {
        this.getCurrentExistentialFrame().disallowNewExistentials = true;
    }

    static class CHRConstraintEntry {
        String name;
        CHRConstraint constraint;

        public CHRConstraintEntry(String name, CHRConstraint constraint) {
            this.name = name;
            this.constraint = constraint;
        }
    }

    static class Entry {
        String name;
        Variable variable;

        public Entry(String name, Variable variable) {
            this.name = name;
            this.variable = variable;
        }
    }

    public static class ExistentialFrame {
        THashSet<String> variables = new THashSet(4);
        ArrayList<Variable> blanks = new ArrayList(2);
        public boolean disallowNewExistentials;

        public EVariable createBlank(long location) {
            Variable variable = new Variable("_");
            this.blanks.add(variable);
            EVariable result = new EVariable(variable);
            result.location = location;
            return result;
        }
    }

    static class RelationEntry {
        String name;
        SCLRelation relation;

        public RelationEntry(String name, SCLRelation relation) {
            this.name = name;
            this.relation = relation;
        }
    }
}

