/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.singletons.NullCheck;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.PartnerFact;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class PostCommitOp
extends PlanOp {
    int priority;

    public PostCommitOp(long location, int priority) {
        super(location);
        this.priority = priority;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("POST_COMMIT " + this.priority);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        if (planContext.currentId != null) {
            w.apply(this.location, CHRRuleset.WRITE_CURRENT_ID, planContext.contextVar, planContext.currentId);
            planContext.currentId = null;
            w.apply(this.location, CHRRuleset.ACTIVATE, planContext.contextVar, new IntegerConstant(this.priority + planContext.ruleset.initialPriorityNumber));
        }
        for (PartnerFact activeFact : planContext.partnerFacts) {
            if (activeFact.killAfterMatch) {
                if (activeFact.nextFact == null) {
                    w.jump(activeFact.finishCont, new IVal[0]);
                    break;
                }
                CodeWriter iterateAlive = w.createBlock(activeFact.constraint.factType);
                w.jump(iterateAlive.getContinuation(), w.apply(this.location, activeFact.nextFact, activeFact.factVar));
                this.iterateUntilLiveFactFound(iterateAlive, activeFact);
                break;
            }
            if (!activeFact.mayBeRemoved) continue;
            if (activeFact.nextFact == null) {
                w.branchAwayUnless(activeFact.isAlive(this.location, w), activeFact.finishCont);
                continue;
            }
            CodeWriter failure = w.createBlock();
            CodeWriter iterateAlive = w.createBlock(activeFact.constraint.factType);
            w.branchAwayUnless(activeFact.isAlive(this.location, w), failure.getContinuation());
            failure.jump(iterateAlive.getContinuation(), failure.apply(this.location, activeFact.nextFact, activeFact.factVar));
            this.iterateUntilLiveFactFound(iterateAlive, activeFact);
        }
    }

    private void iterateUntilLiveFactFound(CodeWriter w, PartnerFact activeFact) {
        ICont initialContinuation = w.getContinuation();
        CHRConstraint constraint = activeFact.constraint;
        IVal fact = w.getParameters()[0];
        CodeWriter dead = w.createBlock();
        w.branchAwayIf(w.apply(this.location, NullCheck.INSTANCE.createSpecialization(constraint.factType), fact), activeFact.finishCont);
        w.branchAwayUnless(activeFact.isAlive(this.location, w, fact), dead.getContinuation());
        w.jump(activeFact.continueCont, fact);
        dead.jump(initialContinuation, dead.apply(this.location, activeFact.nextFact, fact));
    }
}

