/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.LocalBoxedArrayElementConstant;
import org.simantics.scl.compiler.constants.LocalVariableConstant;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.BTypes;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.runtime.MutableClassLoader;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public abstract class FunctionValue
extends Constant {
    TVar[] typeParameters;
    Type returnType;
    protected Type[] parameterTypes;
    Type effect;

    public FunctionValue(TVar[] typeParameters, Type effect, Type returnType, Type ... parameterTypes) {
        super(Types.forAll(typeParameters, Types.functionE(parameterTypes, effect, returnType)));
        this.typeParameters = typeParameters;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.effect = effect;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public TVar[] getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    public void push(MethodBuilder mb) {
        this.apply(mb, Type.EMPTY_ARRAY, new Val[0]);
    }

    @Override
    public Type apply(MethodBuilder mb, Type[] typeParameters, Val ... parameters) {
        int arity = this.getArity();
        if (parameters.length < arity) {
            ModuleBuilder moduleBuilder = mb.getModuleBuilder();
            TypeDesc closureClass = moduleBuilder.getClosure(this, parameters.length);
            CodeBuilderUtils.constructRecord(closureClass, mb, this.parameterTypes, parameters);
            return Types.function(Arrays.copyOfRange(this.parameterTypes, parameters.length, this.parameterTypes.length), this.returnType);
        }
        if (parameters.length > arity) {
            Type returnType = this.applyExact(mb, Arrays.copyOf(parameters, arity));
            mb.pushBoxed(Arrays.copyOfRange(parameters, arity, parameters.length));
            int remainingArity = parameters.length - arity;
            mb.genericApply(remainingArity);
            if (typeParameters.length > 0) {
                returnType = returnType.replace(this.typeParameters, typeParameters);
            }
            try {
                returnType = BTypes.matchFunction(returnType, remainingArity)[remainingArity];
            }
            catch (MatchException matchException) {
                throw new InternalCompilerError("Tried to apply value of type " + returnType + " with " + remainingArity + " parameters.");
            }
            mb.unbox(returnType);
            return returnType;
        }
        return this.applyExact(mb, parameters);
    }

    public abstract Type applyExact(MethodBuilder var1, Val[] var2);

    @Override
    public int getEffectiveArity() {
        return this.parameterTypes.length;
    }

    @Override
    public Object realizeValue(TransientClassBuilder builder) {
        int i;
        Val[] parameters;
        MethodBuilderBase mb;
        ClassBuilder classFile;
        Object cachedResult;
        THashMap<Constant, Object> valueCache = builder.classLoader.getConstantCache();
        if (valueCache != null && (cachedResult = valueCache.get((Object)this)) != null) {
            return cachedResult;
        }
        int arity = this.getEffectiveArity();
        if (arity == 0) {
            return super.realizeValue(builder);
        }
        String packageName = builder.classLoader.getFreshPackageName();
        String moduleName = String.valueOf(packageName) + "/Temp";
        JavaNamingPolicy policy = new JavaNamingPolicy(moduleName);
        ModuleBuilder moduleBuilder = new ModuleBuilder(policy, builder.javaTypeTranslator);
        if (arity <= 8) {
            classFile = new ClassBuilder(moduleBuilder, 1, policy.getModuleClassName(), MethodBuilderBase.getClassName(Constants.FUNCTION_IMPL[arity]), new String[0]);
            classFile.setSourceFile("_SCL_FunctionValue");
            classFile.addDefaultConstructor();
            mb = classFile.addMethod(1, "apply", TypeDesc.OBJECT, Constants.OBJECTS[arity]);
            parameters = new Val[arity];
            i = 0;
            while (i < arity) {
                parameters[i] = new LocalVariableConstant(this.parameterTypes[i], mb.getParameter(i));
                ++i;
            }
            this.prepare((MethodBuilder)mb);
            ((MethodBuilder)mb).box(this.applyExact((MethodBuilder)mb, parameters));
            mb.returnValue(TypeDesc.OBJECT);
            mb.finish();
        } else {
            classFile = new ClassBuilder(moduleBuilder, 1, policy.getModuleClassName(), MethodBuilderBase.getClassName(Constants.FUNCTION_N_IMPL), new String[0]);
            classFile.setSourceFile("_SCL_FunctionValue");
            mb = classFile.addConstructorBase(1, Constants.EMPTY_TYPEDESC_ARRAY);
            mb.loadThis();
            mb.loadConstant(arity);
            mb.invokeConstructor(MethodBuilderBase.getClassName(Constants.FUNCTION_N_IMPL), new TypeDesc[]{TypeDesc.INT});
            mb.returnVoid();
            mb.finish();
            mb = classFile.addMethod(1, "doApply", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.forClass(Object[].class)});
            parameters = new Val[arity];
            i = 0;
            while (i < arity) {
                parameters[i] = new LocalBoxedArrayElementConstant(this.parameterTypes[i], mb.getParameter(0), i);
                ++i;
            }
            this.applyExact((MethodBuilder)mb, parameters);
            ((MethodBuilder)mb).box(this.returnType);
            mb.returnValue(TypeDesc.OBJECT);
            mb.finish();
        }
        MethodBuilder mb2 = classFile.addMethod(1, "toString", TypeDesc.STRING, Constants.OBJECTS[0]);
        mb2.loadConstant(this.toString());
        mb2.returnValue(TypeDesc.STRING);
        mb2.finish();
        moduleBuilder.addClass(classFile);
        MutableClassLoader classLoader = builder.classLoader;
        classLoader.addClasses(moduleBuilder.getClasses());
        try {
            Object result = classLoader.loadClass(policy.getModuleClassName().replace('/', '.')).newInstance();
            if (valueCache != null) {
                valueCache.put((Object)this, result);
                if (TRACE_REALIZATION) {
                    System.out.println("/REALIZED/ " + this + " " + this.getClass().getSimpleName());
                }
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new InternalCompilerError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e);
        }
    }
}

