/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.java.JavaMethodDeclaration;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DClassAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDataAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DEffectAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DFixityAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DImportJavaAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DMappingRelationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRelationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRuleAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRulesetAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DTypeAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDClassAst;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.internal.parsing.translation.RelationRepository;
import org.simantics.scl.compiler.internal.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.module.ImportDeclaration;

public class DeclarationClassification {
    ArrayList<ImportDeclaration> importsAst = new ArrayList();
    ArrayList<DDataAst> dataTypesAst = new ArrayList();
    ArrayList<DTypeAst> typeAliasesAst = new ArrayList();
    ValueRepository valueDefinitionsAst = new ValueRepository();
    RelationRepository relationDefinitionsAst = new RelationRepository();
    ArrayList<DValueTypeAst> typeAnnotationsAst = new ArrayList();
    ArrayList<DFixityAst> fixityAst = new ArrayList();
    ArrayList<ProcessedDClassAst> typeClassesAst = new ArrayList();
    ArrayList<ProcessedDInstanceAst> instancesAst = new ArrayList();
    ArrayList<DDerivingInstanceAst> derivingInstancesAst = new ArrayList();
    ArrayList<DEffectAst> effectsAst = new ArrayList();
    ArrayList<DRuleAst> rulesAst = new ArrayList();
    ArrayList<DMappingRelationAst> mappingRelationsAst = new ArrayList();
    ArrayList<DRulesetAst> rulesetsAst = new ArrayList();
    THashMap<String, DDocumentationAst> valueDocumentation = new THashMap();
    THashMap<String, DDocumentationAst> relationDocumentation = new THashMap();
    THashMap<String, DDocumentationAst> typeDocumentation = new THashMap();
    THashMap<String, DDocumentationAst> classDocumentation = new THashMap();
    ArrayList<JavaMethodDeclaration> javaMethodDeclarations = new ArrayList();
    StringBuilder moduleDocumentation = new StringBuilder();
    ArrayList<DAnnotationAst> currentAnnotations = new ArrayList(2);
    DDocumentationAst documentation;
    String inJavaClass;
    ArrayList<DAnnotationAst> defaultAnnotations = new ArrayList();
    ErrorLog errorLog;

    public DeclarationClassification(CompilationContext compilationContext) {
        this.errorLog = compilationContext.errorLog;
    }

    public void handle(DeclarationAst declaration) {
        if (declaration instanceof DValueAst) {
            this.handle((DValueAst)declaration);
        } else if (declaration instanceof DValueTypeAst) {
            this.handle((DValueTypeAst)declaration);
        } else if (declaration instanceof DDataAst) {
            this.handle((DDataAst)declaration);
        } else if (declaration instanceof DTypeAst) {
            this.handle((DTypeAst)declaration);
        } else if (declaration instanceof DInstanceAst) {
            this.handle((DInstanceAst)declaration);
        } else if (declaration instanceof DDerivingInstanceAst) {
            this.handle((DDerivingInstanceAst)declaration);
        } else if (declaration instanceof ImportDeclaration) {
            this.handle((ImportDeclaration)declaration);
        } else if (declaration instanceof DClassAst) {
            this.handle((DClassAst)declaration);
        } else if (declaration instanceof DFixityAst) {
            this.handle((DFixityAst)declaration);
        } else if (declaration instanceof DDocumentationAst) {
            this.handle((DDocumentationAst)declaration);
        } else if (declaration instanceof DAnnotationAst) {
            this.handle((DAnnotationAst)declaration);
        } else if (declaration instanceof DEffectAst) {
            this.handle((DEffectAst)declaration);
        } else if (declaration instanceof DImportJavaAst) {
            this.handle((DImportJavaAst)declaration);
        } else if (declaration instanceof DRuleAst) {
            this.handle((DRuleAst)declaration);
        } else if (declaration instanceof DMappingRelationAst) {
            this.handle((DMappingRelationAst)declaration);
        } else if (declaration instanceof DRelationAst) {
            this.handle((DRelationAst)declaration);
        } else if (declaration instanceof DRulesetAst) {
            this.handle((DRulesetAst)declaration);
        } else {
            throw new InternalCompilerError("Unknown declaration " + declaration.getClass().getSimpleName());
        }
    }

    public void handle(DFixityAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.fixityAst.add(declaration);
    }

    public void handle(DEffectAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        if (this.documentation != null) {
            this.documentation = null;
        }
        this.effectsAst.add(declaration);
    }

    public void handle(DClassAst declaration) {
        if (this.documentation != null) {
            String name = declaration.name;
            this.addClassDocumentation(name, this.documentation);
            this.documentation = null;
        }
        ArrayList<DValueTypeAst> typeDeclarations = new ArrayList<DValueTypeAst>();
        ValueRepository defaultValues = new ValueRepository();
        DDocumentationAst curDocumentation = null;
        DeclarationAst[] declarationAstArray = declaration.declarations;
        int n = declaration.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationAst decl = declarationAstArray[n2];
            if (decl instanceof DValueTypeAst) {
                DValueTypeAst valueType = (DValueTypeAst)decl;
                EVar[] eVarArray = valueType.names;
                int n3 = valueType.names.length;
                int n4 = 0;
                while (n4 < n3) {
                    EVar name = eVarArray[n4];
                    this.valueDocumentation.put((Object)name.name, (Object)curDocumentation);
                    ++n4;
                }
                curDocumentation = null;
                typeDeclarations.add(valueType);
            } else if (decl instanceof DValueAst) {
                curDocumentation = null;
                try {
                    defaultValues.add((DValueAst)decl);
                }
                catch (NotPatternException e) {
                    this.errorLog.log(e.getExpression().location, "Not a pattern.");
                }
            } else if (decl instanceof DDocumentationAst) {
                DDocumentationAst documentation = (DDocumentationAst)decl;
                if (curDocumentation != null) {
                    this.errorLog.log(documentation.location, "Invalid documentation string. It precedes another documentation string.");
                }
                curDocumentation = documentation;
            } else {
                this.errorLog.log(decl.location, "Invalid declaration under class definition.");
            }
            ++n2;
        }
        if (!this.currentAnnotations.isEmpty()) {
            declaration.setAnnotations(this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
        this.typeClassesAst.add(new ProcessedDClassAst(declaration, typeDeclarations, defaultValues));
    }

    public void handle(ImportDeclaration declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.importsAst.add(declaration);
    }

    public void handle(DImportJavaAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            for (DAnnotationAst annotation : this.currentAnnotations) {
                String name = annotation.id.text;
                if (name.equals("@private")) {
                    this.defaultAnnotations.add(annotation);
                    continue;
                }
                this.errorLog.log(declaration.location, "The importJava declaration does not support annotation " + name + ".");
            }
            this.currentAnnotations = new ArrayList(2);
        }
        try {
            this.inJavaClass = declaration.className;
            for (DeclarationAst innerDeclaration : declaration.declarations) {
                this.handle(innerDeclaration);
            }
        }
        finally {
            this.defaultAnnotations.clear();
            this.inJavaClass = null;
        }
    }

    public void handle(DInstanceAst declaration) {
        ValueRepository valueDefs = new ValueRepository();
        ArrayList<DAnnotationAst> localAnnotations = new ArrayList<DAnnotationAst>(2);
        DeclarationAst[] declarationAstArray = declaration.declarations;
        int n = declaration.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationAst declarationAst = declarationAstArray[n2];
            if (declarationAst instanceof DValueAst) {
                try {
                    String name = valueDefs.add((DValueAst)declarationAst);
                    if (!localAnnotations.isEmpty()) {
                        valueDefs.addAnnotations(name, localAnnotations);
                        localAnnotations = new ArrayList(2);
                    }
                }
                catch (NotPatternException e) {
                    this.errorLog.log(e.getExpression().location, "Not a pattern.");
                }
            } else if (declarationAst instanceof DAnnotationAst) {
                localAnnotations.add((DAnnotationAst)declarationAst);
            } else {
                this.errorLog.log(declarationAst.location, "Invalid declaration under instance definition.");
            }
            ++n2;
        }
        for (DAnnotationAst dAnnotationAst : localAnnotations) {
            this.errorLog.log(dAnnotationAst.location, "Annotation is at invalid location.");
        }
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        if (declaration.name.name.equals("Eq") || declaration.name.name.equals("Hashable")) {
            this.errorLog.logWarning(declaration.location, "Skipped instance definition for " + declaration.name + " for " + declaration.types[0]);
            return;
        }
        this.instancesAst.add(new ProcessedDInstanceAst(declaration, valueDefs));
    }

    public void handle(DDerivingInstanceAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        if (declaration.name.name.equals("Eq") || declaration.name.name.equals("Hashable")) {
            this.errorLog.logWarning(declaration.location, "Skipped instance definition for " + declaration.name + " for " + declaration.types[0]);
            return;
        }
        this.derivingInstancesAst.add(declaration);
    }

    public void handle(DTypeAst declaration) {
        if (!this.currentAnnotations.isEmpty()) {
            this.errorLog.log(declaration.location, "Annotations not supported.");
            this.currentAnnotations = new ArrayList(2);
        }
        this.typeAliasesAst.add(declaration);
    }

    public void handle(DDataAst declaration) {
        if (this.documentation != null) {
            String name = declaration.name;
            this.addTypeDocumentation(name, this.documentation);
            this.documentation = null;
        }
        if (this.inJavaClass != null) {
            this.currentAnnotations.add(new DAnnotationAst(new Token(0, 9223372034707292160L, "@JavaType"), Arrays.asList(new ELiteral(new StringConstant(this.inJavaClass)))));
        }
        if (!this.currentAnnotations.isEmpty()) {
            declaration.setAnnotations(this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
        this.dataTypesAst.add(declaration);
    }

    public void handle(DValueTypeAst declaration) {
        EVar name;
        int n;
        int n2;
        EVar[] eVarArray;
        if (this.documentation != null) {
            eVarArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = eVarArray[n];
                this.addValueDocumentation(name.name, this.documentation);
                ++n;
            }
            this.documentation = null;
        }
        if (this.inJavaClass != null) {
            eVarArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = eVarArray[n];
                this.javaMethodDeclarations.add(new JavaMethodDeclaration(declaration.location, this.inJavaClass, name, declaration.type));
                ++n;
            }
        } else {
            this.typeAnnotationsAst.add(declaration);
        }
        if (!this.currentAnnotations.isEmpty()) {
            eVarArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = eVarArray[n];
                this.valueDefinitionsAst.addAnnotations(name.name, this.currentAnnotations);
                ++n;
            }
            this.currentAnnotations = new ArrayList(2);
        }
        if (!this.defaultAnnotations.isEmpty()) {
            eVarArray = declaration.names;
            n2 = declaration.names.length;
            n = 0;
            while (n < n2) {
                name = eVarArray[n];
                this.valueDefinitionsAst.addAnnotations(name.name, this.defaultAnnotations);
                ++n;
            }
        }
    }

    public void handle(DValueAst declaration) {
        String name;
        try {
            name = this.valueDefinitionsAst.add(declaration);
        }
        catch (NotPatternException e) {
            this.errorLog.log(e.getExpression().location, "Illegal left hand side of the definition.");
            return;
        }
        if (this.documentation != null) {
            this.addValueDocumentation(name, this.documentation);
            this.documentation = null;
        }
        if (!this.currentAnnotations.isEmpty()) {
            this.valueDefinitionsAst.addAnnotations(name, this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
    }

    public void handle(DRelationAst declaration) {
        String name;
        try {
            name = this.relationDefinitionsAst.add(declaration);
        }
        catch (NotPatternException e) {
            this.errorLog.log(e.getExpression().location, "Not a pattern.");
            return;
        }
        if (this.documentation != null) {
            this.addRelationDocumentation(name, this.documentation);
            this.documentation = null;
        }
        if (!this.currentAnnotations.isEmpty()) {
            this.relationDefinitionsAst.addAnnotations(name, this.currentAnnotations);
            this.currentAnnotations = new ArrayList(2);
        }
    }

    public void handle(DRulesetAst declaration) {
        if (this.documentation != null) {
            declaration.documentation = this.documentation;
            this.documentation = null;
        }
        this.rulesetsAst.add(declaration);
    }

    public void handle(DDocumentationAst declaration) {
        if (this.documentation != null) {
            this.errorLog.log(this.documentation.location, "Invalid documentation string. It precedes another documentation string.");
        }
        this.documentation = declaration;
    }

    public void handle(DAnnotationAst declaration) {
        if (declaration.id.text.equals("@documentation")) {
            if (declaration.parameters.length != 1) {
                this.errorLog.log(this.documentation.location, "One parameter, a documentation string, expected after @documentation.");
                return;
            }
            if (!(declaration.parameters[0] instanceof ELiteral)) {
                this.errorLog.log(this.documentation.location, "A documentation string expected after @documentation.");
                return;
            }
            ELiteral lit = (ELiteral)declaration.parameters[0];
            if (!(lit.getValue() instanceof StringConstant)) {
                this.errorLog.log(this.documentation.location, "A documentation string expected after @documentation.");
                return;
            }
            String text = ((StringConstant)lit.getValue()).getValue();
            this.moduleDocumentation.append(text);
            this.moduleDocumentation.append("\n\n");
        } else {
            this.currentAnnotations.add(declaration);
        }
    }

    public void handle(DRuleAst declaration) {
        this.rulesAst.add(declaration);
    }

    public void handle(DMappingRelationAst declaration) {
        this.mappingRelationsAst.add(declaration);
    }

    public void addValueDocumentation(String valueName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.valueDocumentation.put((Object)valueName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to " + valueName + ".");
        }
    }

    public void addRelationDocumentation(String relationName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.relationDocumentation.put((Object)relationName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to " + relationName + ".");
        }
    }

    public void addTypeDocumentation(String valueName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.typeDocumentation.put((Object)valueName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to the same type.");
        }
    }

    public void addClassDocumentation(String valueName, DDocumentationAst documentation) {
        DDocumentationAst oldDoc = (DDocumentationAst)this.classDocumentation.put((Object)valueName, (Object)documentation);
        if (oldDoc != null) {
            this.errorLog.log(oldDoc.location, "Multiple documentation strings given to the same class.");
        }
    }
}

