/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.common.datatypes;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.Typed;

public class Constructor
implements Typed {
    public static final Constructor[] EMPTY_ARRAY = new Constructor[0];
    public final long loc;
    public final TypeConstructor dataType;
    public final Name name;
    public final Type[] parameterTypes;
    public final String javaName;
    public final TVar[] typeVariables;
    public final Type type;
    public String[] fieldNames;
    public String[] recordFieldNames;

    public Constructor(long loc, TypeConstructor dataType, Name name, Type[] parameters, String javaName) {
        ClassBuilder.checkClassName(javaName);
        this.loc = loc;
        this.dataType = dataType;
        this.name = name;
        this.parameterTypes = parameters;
        this.javaName = javaName;
        Type currentType = dataType.type;
        int i = this.parameterTypes.length - 1;
        while (i >= 0) {
            currentType = Types.function(this.parameterTypes[i], currentType);
            --i;
        }
        this.typeVariables = Types.freeVars(currentType).toArray(TVar.EMPTY_ARRAY);
        this.type = Types.closure(currentType, this.typeVariables);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public TVar[] getTypeVariables() {
        return this.typeVariables;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getReturnType() {
        return this.dataType.type;
    }
}

