/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import java.util.Iterator;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.history.util.WeightedMedian;

public class WeightedMedianBinding
extends ArrayBinding {
    public WeightedMedianBinding() {
        super(new ArrayType((Datatype)Bindings.DOUBLE.type()), (Binding)Bindings.DOUBLE);
    }

    public Object create() {
        return new WeightedMedian();
    }

    public Object create(int length, Iterator<Object> it) throws BindingException {
        WeightedMedian result = new WeightedMedian(length);
        int count = length / 2;
        WeightedMedian.Item[] items = new WeightedMedian.Item[count];
        int index = 0;
        double value = 0.0;
        double weight = 0.0;
        while (it.hasNext()) {
            double d = (Double)it.next();
            if (index % 2 == 0) {
                value = d;
            } else {
                WeightedMedian.Item i;
                weight = d;
                items[index / 2] = i = new WeightedMedian.Item(weight, value);
            }
            ++index;
        }
        if (count > 0) {
            items[0].next = items[1];
            items[count - 1].prev = items[count - 2];
        }
        index = 1;
        while (index < count - 1) {
            items[index].next = items[index + 1];
            items[index].prev = items[index - 1];
            ++index;
        }
        result.median = items[count / 2];
        result.itemCount = count;
        return result;
    }

    public Object create(Object[] array) throws BindingException {
        int count = array.length / 2;
        WeightedMedian result = new WeightedMedian();
        WeightedMedian.Item[] items = new WeightedMedian.Item[count];
        double value = 0.0;
        double weight = 0.0;
        int index = 0;
        while (index < array.length) {
            double d = (Double)array[index];
            if (index % 2 == 0) {
                value = d;
            } else {
                WeightedMedian.Item i;
                weight = d;
                items[index / 2] = i = new WeightedMedian.Item(weight, value);
            }
            ++index;
            ++index;
        }
        if (count > 0) {
            items[0].next = items[1];
            items[count - 1].prev = items[count - 2];
        }
        index = 1;
        while (index < count - 1) {
            items[index].next = items[index + 1];
            items[index].prev = items[index - 1];
            ++index;
        }
        result.median = items[count / 2];
        result.itemCount = count;
        return result;
    }

    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new BindingException("not implemented");
    }

    public void remove(Object array, int index, int count) throws BindingException {
        throw new BindingException("not implemented");
    }

    public Object get(Object array, int index) throws BindingException {
        int pos = index / 2;
        WeightedMedian median = (WeightedMedian)array;
        int c = median.itemCount * 2;
        if (index < 0 || index >= c) {
            throw new BindingException("Index " + index + " out of bounds " + c);
        }
        WeightedMedian.Item i = median.head();
        int ix = 1;
        while (ix < pos) {
            i = i.next;
            ++ix;
        }
        return index % 2 == 0 ? i.value : i.weight;
    }

    public void getAll(Object array, Object[] result) throws BindingException {
        int c = this.size(array);
        if (result.length < c) {
            throw new BindingException("Array too small");
        }
        WeightedMedian median = (WeightedMedian)array;
        int ix = 0;
        WeightedMedian.Item i = median.head();
        while (i != null) {
            result[ix] = i.value;
            result[++ix] = i.weight;
            ++ix;
            i = i.next;
        }
    }

    public void set(Object array, int index, Object value) throws BindingException {
        this.remove(array, index);
        this.add(array, value);
    }

    public void setSize(Object array, int newSize) throws BindingException {
        int size = this.size(array);
        if (size < newSize) {
            newSize = size;
        }
        this.remove(array, size - newSize, newSize);
    }

    public int size(Object array) throws BindingException {
        WeightedMedian median = (WeightedMedian)array;
        return median.itemCount * 2;
    }

    public boolean isInstance(Object obj) {
        return obj instanceof WeightedMedian;
    }

    public boolean isResizable() {
        return true;
    }
}

