/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class NodeCache<Node, Value> {
    private long defaultExpirationTimeInNs;
    private TreeMap<Long, Node> expirationTimes = new TreeMap();
    private TObjectLongHashMap<Node> exp = new TObjectLongHashMap(10, 0.5f, -1L);
    private Map<Node, Value> map = new HashMap<Node, Value>();
    private boolean disposed;

    public NodeCache() {
        this(1000000000L);
    }

    public NodeCache(long defaultExpirationTimeInNs) {
        this.defaultExpirationTimeInNs = defaultExpirationTimeInNs;
    }

    public synchronized Value get(Node node) {
        return this.map.get(node);
    }

    public synchronized void clearExpired() {
        long now = System.nanoTime();
        while (!this.expirationTimes.isEmpty()) {
            Long first = this.expirationTimes.firstKey();
            if (first < now) {
                Node node = this.expirationTimes.remove(first);
                this.exp.remove(node);
                this.map.remove(node);
                continue;
            }
            return;
        }
    }

    private long scheduleExpiration(Node node, long expiration) {
        while (this.expirationTimes.containsKey(expiration)) {
            ++expiration;
        }
        this.expirationTimes.put(expiration, node);
        this.exp.put(node, expiration);
        return expiration;
    }

    private void refreshExpiration(Node node, long newExpiration, boolean existing) {
        long current = this.exp.get(node);
        if (current == -1L) {
            if (!existing && newExpiration != 0L) {
                this.scheduleExpiration(node, newExpiration);
            }
            return;
        }
        if (newExpiration == 0L) {
            this.expirationTimes.remove(current);
            this.exp.remove(node);
        } else if (newExpiration > current) {
            this.expirationTimes.remove(current);
            this.scheduleExpiration(node, newExpiration);
        }
    }

    public synchronized void put(Node node, Value value) {
        if (this.disposed) {
            return;
        }
        Value existing = this.map.put(node, value);
        this.refreshExpiration(node, 0L, existing != null);
    }

    public synchronized void put(Node node, Value value, long expiration) {
        if (this.disposed) {
            return;
        }
        Value existing = this.map.put(node, value);
        this.refreshExpiration(node, System.nanoTime() + expiration, existing != null);
    }

    public synchronized void removeListening(Node node) {
        if (this.disposed) {
            return;
        }
        this.scheduleExpiration(node, System.nanoTime() + this.defaultExpirationTimeInNs);
    }

    public synchronized void dispose() {
        this.disposed = true;
        this.expirationTimes.clear();
        this.exp.clear();
        this.map.clear();
    }
}

