/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiFunction;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.ImportAdvisor;
import org.simantics.graph.db.ImportResult;
import org.simantics.graph.db.StreamingTransferableGraphImportProcess;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TGToGraphMap;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphImportProcess;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.WrapperAdvisor;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.representation.Extensions;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferableGraphs {
    static final Logger LOGGER = LoggerFactory.getLogger(TransferableGraphs.class);
    private static final int LITERAL_VALUE_IO_BUFFER_SIZE = 131072;

    public static long[] importGraph(Session session, Object tg, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(session, (TransferableGraph1)tg, advisor);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static long[] importGraph(WriteGraph g, Object tg, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(g, (TransferableGraph1)tg, advisor);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static long[] importGraph(Session session, Object tg) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(session, (TransferableGraph1)tg);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static long[] importGraph(WriteGraph g, Object tg) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(g, (TransferableGraph1)tg);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static Collection<Resource> collectExternals(RequestProcessor processor, TransferableGraph1 tg) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, new ImportAdvisor());
        processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        HashSet<Resource> result = new HashSet<Resource>();
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof External) {
                result.add(process.resources[id.resource]);
            }
            ++n2;
        }
        return result;
    }

    public static long[] importGraph1(Session session, TransferableGraph1 tg, IImportAdvisor advisor_) throws DatabaseException, TransferableGraphException {
        final IImportAdvisor2 advisor = advisor_ instanceof IImportAdvisor2 ? (IImportAdvisor2)advisor_ : new WrapperAdvisor(advisor_);
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                advisor.beforeWrite(graph, process);
                process.write(graph);
                advisor.afterWrite(graph, process);
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }

    public static void importGraph1(Session session, TransferableGraph1 tg, IImportAdvisor advisor, final BiFunction<WriteOnlyGraph, TransferableGraphImportProcess, Boolean> callback) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                process.write(graph);
                if (callback != null) {
                    callback.apply(graph, process);
                }
            }
        });
    }

    public static ImportResult importGraph1(Session session, TransferableGraphSource tg, IImportAdvisor advisor) throws Exception {
        return TransferableGraphs.importGraph1(session, tg, advisor, null);
    }

    public static ImportResult importGraph1(Session session, TransferableGraphSource tg, IImportAdvisor advisor, TGStatusMonitor monitor) throws DatabaseException {
        return TransferableGraphs.importGraph1(session, null, tg, advisor, monitor);
    }

    public static ImportResult importGraph1(Session session, VirtualGraph vg, TransferableGraphSource tg, IImportAdvisor advisor_, TGStatusMonitor monitor) throws DatabaseException {
        final IImportAdvisor2 advisor = advisor_ instanceof IImportAdvisor2 ? (IImportAdvisor2)advisor_ : new WrapperAdvisor(advisor_);
        final StreamingTransferableGraphImportProcess process = new StreamingTransferableGraphImportProcess(session, vg, tg, advisor, monitor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    process.prepare(graph);
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(vg){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                try {
                    advisor.beforeWrite(graph, process);
                    process.write(graph);
                    advisor.afterWrite(graph, process);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
        return new ImportResult(process.missingExternals);
    }

    public static void importGraph1WithMonitor(Session session, final TransferableGraph1 tg, IImportAdvisor advisor_, TGStatusMonitor monitor) throws DatabaseException {
        final IImportAdvisor2 advisor = advisor_ instanceof IImportAdvisor2 ? (IImportAdvisor2)advisor_ : new WrapperAdvisor(advisor_);
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor, monitor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                advisor.beforeWrite(graph, process);
                process.write2(graph);
                advisor.afterWrite(graph, process);
                CommentMetadata comments = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                comments.add("Imported transferable graph with " + tg.resourceCount + " resources");
                graph.addMetadata((Metadata)comments);
            }
        });
    }

    public static void importGraph1WithChanges(Session session, final TransferableGraph1 tg, IImportAdvisor advisor, final BiFunction<WriteGraph, TransferableGraphImportProcess, Boolean> callback) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                process.write2((WriteOnlyGraph)graph);
                CommentMetadata comments = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                comments.add("Imported transferable graph with " + tg.resourceCount + " resources");
                graph.addMetadata((Metadata)comments);
                if (callback != null) {
                    callback.apply(graph, process);
                }
            }
        });
    }

    public static long[] importGraph1(Session session, TransferableGraph1 tg) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, null);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                process.write(graph);
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }

    public static long[] importGraph1(WriteGraph graph, TransferableGraph1 tg) throws DatabaseException, TransferableGraphException {
        TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, null);
        process.prepare((ReadGraph)graph);
        process.write2((WriteOnlyGraph)graph);
        return process.getResourceIds((SerialisationSupport)graph.getSession().getService(SerialisationSupport.class));
    }

    public static long[] importGraph1(WriteGraph graph, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException {
        return TransferableGraphs.importGraph1(graph, tg, advisor, null);
    }

    public static long[] importGraph1(WriteGraph graph, TransferableGraph1 tg, IImportAdvisor advisor, TGStatusMonitor monitor) throws DatabaseException {
        TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor, monitor);
        process.prepare((ReadGraph)graph);
        if (advisor instanceof IImportAdvisor2) {
            ((IImportAdvisor2)advisor).beforeWrite((WriteOnlyGraph)graph, process);
        }
        process.write2((WriteOnlyGraph)graph);
        if (advisor instanceof IImportAdvisor2) {
            ((IImportAdvisor2)advisor).afterWrite((WriteOnlyGraph)graph, process);
        }
        return process.getResourceIds((SerialisationSupport)graph.getSession().getService(SerialisationSupport.class));
    }

    public static long[] applyDelta(WriteGraph graph, long[] oldResources, TransferableGraphDelta1 delta) throws DatabaseException {
        SerialisationSupport serializer = (SerialisationSupport)graph.getSession().getService(SerialisationSupport.class);
        TGToGraphMap aMap = new TGToGraphMap(delta.a);
        aMap.addOldResources(serializer, oldResources);
        aMap.deny(graph);
        TGToGraphMap bMap = new TGToGraphMap(delta.b);
        bMap.addMappedOldResources(serializer, delta.aToB, aMap.getResources());
        bMap.prepare((ReadGraph)graph);
        bMap.claim((WriteOnlyGraph)graph);
        return bMap.getResources(serializer);
    }

    public static boolean hasChanges(ReadGraph graph, long[] oldResources, TransferableGraphDelta1 delta) throws DatabaseException {
        SerialisationSupport serializer = (SerialisationSupport)graph.getSession().getService(SerialisationSupport.class);
        TGToGraphMap aMap = new TGToGraphMap(delta.a);
        aMap.addOldResources(serializer, oldResources);
        if (aMap.checkDeny(graph)) {
            return true;
        }
        TGToGraphMap bMap = new TGToGraphMap(delta.b);
        bMap.addMappedOldResources(serializer, delta.aToB, aMap.getResources());
        bMap.prepare(graph);
        return bMap.checkClaim(graph);
    }

    public static void uninstallGraph(WriteGraph writeGraph, TransferableGraph1 graph, ImportAdvisor advisor) throws TransferableGraphException {
        throw new UnsupportedOperationException();
    }

    public static long[] importVirtualGraph(Session session, final VirtualGraph vg, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(vg){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                if (vg != null) {
                    process.write2(graph);
                } else {
                    process.write(graph);
                }
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }

    public static long[] importVirtualGraph(WriteGraph graph, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException {
        TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        process.prepare((ReadGraph)graph);
        process.write2((WriteOnlyGraph)graph);
        return process.getResourceIds((SerialisationSupport)graph.getService(SerialisationSupport.class));
    }

    public static TransferableGraph1 readGraph(File file) throws TransferableGraphException {
        FileVariantAccessor va;
        block14: {
            TransferableGraph1 transferableGraph1;
            block15: {
                va = null;
                va = Accessors.openAccessor((File)file);
                Datatype type = va.getContentType();
                if (!type.equals((Object)Datatypes.getDatatype(TransferableGraph1.class))) break block14;
                transferableGraph1 = (TransferableGraph1)va.getContentValue(Bindings.getBinding(TransferableGraph1.class));
                if (va == null) break block15;
                try {
                    va.close();
                }
                catch (AccessorException accessorException) {}
            }
            return transferableGraph1;
        }
        try {
            try {
                throw new SerializationException("Unknown transferable graph data type.");
            }
            catch (AccessorException e) {
                throw new TransferableGraphException(e);
            }
            catch (BindingConstructionException e) {
                throw new TransferableGraphException(e);
            }
            catch (SerializationException e) {
                throw new TransferableGraphException(e);
            }
            catch (AccessorConstructionException e) {
                throw new TransferableGraphException(e);
            }
            catch (DatatypeConstructionException e) {
                throw new TransferableGraphException(e);
            }
        }
        catch (Throwable throwable) {
            if (va != null) {
                try {
                    va.close();
                }
                catch (AccessorException accessorException) {}
            }
            throw throwable;
        }
    }

    public static void importVirtualGraph(Session session, VirtualGraph vg, File file) throws TransferableGraphException {
        try {
            TransferableGraphs.importVirtualGraph(session, vg, TransferableGraphs.readGraph(file), new ImportAdvisor());
        }
        catch (DatabaseException e) {
            throw new TransferableGraphException(e);
        }
    }

    public static VirtualGraph importVirtualGraph(Session session, File file) throws TransferableGraphException {
        VirtualGraphSupport support = (VirtualGraphSupport)session.getService(VirtualGraphSupport.class);
        VirtualGraph vg = support.getMemoryPersistent(UUID.randomUUID().toString());
        TransferableGraphs.importVirtualGraph(session, vg, file);
        return vg;
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, TransferableGraphSource source, File target) throws Exception {
        TransferableGraphs.writeTransferableGraph(processor, format, 1, source, target);
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, int version, TransferableGraphSource source, File target) throws Exception {
        TransferableGraphs.writeTransferableGraph(processor, format, version, new TreeMap<String, Variant>(), source, target);
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, int version, TreeMap<String, Variant> metadata, TransferableGraphSource source, File target) throws Exception {
        TransferableGraphs.writeTransferableGraph(processor, format, version, metadata, source, target, TGStatusMonitor.NULL_MONITOR);
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, int version, TreeMap<String, Variant> metadata, TransferableGraphSource source, File target, TGStatusMonitor monitor) throws Exception {
        Serializer datatypeSerializer = Bindings.getSerializerUnchecked(Datatype.class);
        Throwable throwable = null;
        Object var9_10 = null;
        try (BinaryFile out = new BinaryFile(target, 131072);){
            DataContainer container = new DataContainer(format, version, metadata, null);
            DataContainers.writeHeader((DataOutput)out, (DataContainer)container);
            datatypeSerializer.serialize((DataOutput)out, (Object)Datatypes.getDatatypeUnchecked(TransferableGraph1.class));
            TransferableGraphs.writeTransferableGraph(processor, source, (RandomAccessBinary)out, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static TGStatusMonitor safeMonitor(TGStatusMonitor mon) {
        return mon == null ? TGStatusMonitor.NULL_MONITOR : mon;
    }

    private static long copy(byte[] buffer, DataInput in, DataOutput out, long bytesToCopy) throws IOException {
        int read = 0;
        long bufferLength = buffer.length;
        while ((long)read < bytesToCopy) {
            int l = (int)Math.min(bufferLength, bytesToCopy - (long)read);
            in.readFully(buffer, 0, l);
            out.write(buffer, 0, l);
            read += l;
        }
        return read;
    }

    private static void writeTransferableGraph(RequestProcessor processor, final TransferableGraphSource source, final RandomAccessBinary out, final TGStatusMonitor monitor) throws Exception {
        long start = System.nanoTime();
        final Serializer datatypeSerializer = Bindings.getSerializerUnchecked(Datatype.class);
        final Serializer identitySerializer = Bindings.getSerializerUnchecked(Identity.class);
        Serializer extensionSerializer = Bindings.getSerializerUnchecked(Extensions.class);
        int resourceCount = source.getResourceCount();
        out.writeInt(resourceCount);
        extensionSerializer.serialize((DataOutput)out, (Object)new Extensions(source.getExtensions()));
        final byte[] buffer = new byte[131072];
        processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    if (monitor.isCanceled()) {
                        throw new CancelTransactionException();
                    }
                    int identityCount = source.getIdentityCount();
                    TGStatusMonitor.Updater identityProgress = new TGStatusMonitor.Updater(TransferableGraphs.safeMonitor(monitor), 0, 33, identityCount);
                    out.writeInt(identityCount);
                    source.forIdentities(graph, value -> {
                        identitySerializer.serialize((DataOutput)out, value);
                        identityProgress.worked(1);
                    });
                    if (monitor.isCanceled()) {
                        throw new CancelTransactionException();
                    }
                    long statementCountPos = out.position();
                    int originalStatementCount = source.getStatementCount();
                    TGStatusMonitor.Updater statementProgress = new TGStatusMonitor.Updater(TransferableGraphs.safeMonitor(monitor), 34, 66, originalStatementCount);
                    out.writeInt(originalStatementCount);
                    int[] statementCounter = new int[1];
                    source.forStatements(graph, r -> {
                        int i = 0;
                        while (i < 4) {
                            out.writeInt(r[i]);
                            ++i;
                        }
                        nArray[0] = statementCounter[0] + 1;
                        statementProgress.worked(1);
                    });
                    long afterStatementsPos = out.position();
                    out.position(statementCountPos);
                    out.writeInt(statementCounter[0] * 4);
                    out.position(afterStatementsPos);
                    if (monitor.isCanceled()) {
                        throw new CancelTransactionException();
                    }
                    int valueCount = source.getValueCount();
                    final TGStatusMonitor.Updater valueProgress = new TGStatusMonitor.Updater(TransferableGraphs.safeMonitor(monitor), 67, 100, valueCount);
                    out.writeInt(valueCount);
                    final CopyingInputStream cis = new CopyingInputStream();
                    cis.out = out;
                    source.forValues2(graph, new TransferableGraphSource.TransferableGraphSourceValueProcedure(){
                        TObjectIntHashMap<Object> identities = new TObjectIntHashMap();

                        @Override
                        public void rawCopy(int resource, int length, DataInput input) throws Exception {
                            out.writeInt(resource);
                            long copied = TransferableGraphs.copy(buffer, input, (DataOutput)out, length);
                            if (!$assertionsDisabled && copied != (long)length) {
                                throw new AssertionError();
                            }
                            valueProgress.worked(1);
                        }

                        @Override
                        public void execute(int resource, Datatype type, DataInput input) throws Exception {
                            out.writeInt(resource);
                            this.identities.clear();
                            datatypeSerializer.serialize((DataOutput)out, this.identities, (Object)type);
                            Binding binding = Bindings.getBinding((Datatype)type);
                            Serializer serializer = Bindings.getSerializer((Binding)binding);
                            cis.in = input;
                            serializer.skip((InputStream)cis);
                            cis.in = null;
                            valueProgress.worked(1);
                        }
                    });
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
        long end = System.nanoTime();
        LOGGER.info("Wrote transferable graph in {} seconds.", (Object)(1.0E-9 * (double)(end - start)));
    }

    public static TransferableGraph1 create(ReadGraph graph, TransferableGraphSource source) throws DatabaseException {
        TIntArrayList statements = new TIntArrayList();
        ArrayList values = new ArrayList();
        ArrayList identities = new ArrayList();
        try {
            source.forStatements(graph, r -> {
                boolean bl = statements.addAll(r);
            });
            source.forValues(graph, v -> {
                boolean bl = values.add(v);
            });
            source.forIdentities(graph, i -> {
                boolean bl = identities.add(i);
            });
            return new TransferableGraph1(source.getResourceCount(), identities.toArray(new Identity[identities.size()]), statements.toArray(), values.toArray(new Value[values.size()]), source.getExtensions());
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private static class CopyingInputStream
    extends InputStream {
        public DataInput in;
        public DataOutput out;

        private CopyingInputStream() {
        }

        @Override
        public int read() throws IOException {
            int value = this.in.readUnsignedByte();
            this.out.write(value);
            return value;
        }
    }
}

