/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.graph.impl.contribution.ContributionStub;
import org.simantics.browsing.ui.graph.impl.contribution.GraphContribution;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalViewpointContributionImpl
extends ContributionStub
implements GraphContribution {
    private final ResourceQuery<Collection<NodeContext>> childQuery;
    private final Procedure<Collection<NodeContext>> childProcedure;
    protected final PrimitiveQueryUpdater updater;
    private final NodeContext context;
    private final BuiltinKeys.ViewpointContributionKey key;

    public Object getIdentity() {
        return this.key;
    }

    public FinalViewpointContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointContributionKey key) {
        assert (updater != null);
        assert (context != null);
        assert (key != null);
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.childQuery = new ResourceQuery<Collection<NodeContext>>(this.getIdentity(), context){

            public Collection<NodeContext> perform(ReadGraph graph) throws DatabaseException {
                try {
                    Collection result = FinalViewpointContributionImpl.this.children(graph, this.context);
                    if (result == null) {
                        throw new NullPointerException("LazyContributionImpl.children is not allowed to return null, but " + FinalViewpointContributionImpl.this.getClass() + " just did it");
                    }
                    return result;
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"LazyContributionImpl.childQuery produced unexpected exception.", (Throwable)t);
                    return ViewpointContribution.NO_CONTRIBUTION;
                }
            }

            public String toString() {
                return "LazyContributionImpl[" + System.identityHashCode(FinalViewpointContributionImpl.this) + "].childQuery";
            }
        };
        this.childProcedure = this.createProcedure();
    }

    protected Procedure<Collection<NodeContext>> createProcedure() {
        return new Procedure<Collection<NodeContext>>(){

            public void execute(Collection<NodeContext> result) {
                FinalViewpointContributionImpl.this.replaceChildrenResult(result);
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((String)"LazyContributionImpl.childQuery failed, see exception for details.", (Throwable)t);
            }

            public String toString() {
                return "LazyContributionImpl[" + System.identityHashCode(FinalViewpointContributionImpl.this) + "].childProcedure";
            }
        };
    }

    public NodeContext getContext() {
        return this.context;
    }

    public Collection<NodeContext> getContribution() {
        DataSource source;
        if (this.children == ViewpointContribution.PENDING_CONTRIBUTION && (source = this.updater.getDataSource(ReadGraph.class)) != null) {
            source.schedule(graph -> {
                if (this.childProcedure instanceof Listener) {
                    graph.asyncRequest(this.childQuery, (Listener)this.childProcedure);
                } else {
                    graph.asyncRequest(this.childQuery, this.childProcedure);
                }
            });
        }
        return this.children;
    }

    protected void replaceChildrenResult(Collection<NodeContext> result) {
        this.setChildren(this.updater, result);
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    protected <T> T getInput(Class<T> clazz) throws ClassCastException {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return (T)o;
    }

    protected <T> T tryGetInput(Class<T> clazz) {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    @Override
    public Tester getNodeContextTester() {
        return null;
    }
}

