/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.FileDocumentUtil;
import org.simantics.graphfile.util.GraphFileUtil;

public class ExportDocumentFolder
implements ActionFactory {
    Resource relation;
    boolean useResourceNames;

    public ExportDocumentFolder(ReadGraph graph, String relationUri) throws DatabaseException {
        this.relation = graph.getResource(relationUri);
        this.useResourceNames = true;
    }

    public ExportDocumentFolder(ReadGraph graph, String relationUri, String useResourceNames) throws DatabaseException {
        this.relation = graph.getResource(relationUri);
        this.useResourceNames = useResourceNames.equals("true");
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                MessageDialog messageDialog;
                Shell shell = Display.getCurrent().getActiveShell();
                DirectoryDialog dialog = new DirectoryDialog(shell, 8192);
                String folderName = dialog.open();
                if (folderName == null) {
                    return;
                }
                File folder = new File(folderName);
                int choice = -1;
                if (folder.list().length > 0 && (choice = (messageDialog = new MessageDialog(shell, "Folder export", null, "Selected folder \"" + folderName + "\" is not empty.", 3, new String[]{"Delete and export", "Overwrite", "Cancel"}, 2)).open()) == 2) {
                    return;
                }
                ExportJob job = new ExportJob(resource, folder, choice == 0);
                job.setUser(true);
                job.schedule();
            }
        };
    }

    private class ExportJob
    extends DatabaseJob {
        Resource resource;
        File folder;
        boolean clear;

        public ExportJob(Resource resource, File folder, boolean clear) {
            super("Export folder");
            this.clear = false;
            this.resource = resource;
            this.folder = folder;
            this.clear = clear;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Export folder", -1);
                if (this.clear) {
                    GraphFileUtil.clearDirectoryStructure((File)this.folder);
                    monitor.worked(1);
                }
                FileDocumentUtil.exportDocumentFolder((Resource)this.resource, (File)this.folder, (Resource)ExportDocumentFolder.this.relation, (boolean)ExportDocumentFolder.this.useResourceNames, (IProgressMonitor)monitor);
                monitor.done();
                return new Status(0, "org.simantics.document.ui", "Folder exported.");
            }
            catch (Exception e) {
                monitor.done();
                return new Status(4, "org.simantics.document.ui", "Cannot export document folder.", (Throwable)e);
            }
        }
    }
}

