/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event;

import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.writer.EventSourceResolver;
import org.simantics.event.writer.EventWriteTask;
import org.simantics.event.writer.EventWriterJob;
import org.simantics.layer0.Layer0;

public class EventSupport {
    private Resource model;
    private Resource run;
    private EventSourceResolver.Filter filter;
    private Resource eventLog;
    private EventWriterJob writer;
    private EventSourceResolver resolver;

    public EventSupport(Resource model, Resource run, EventSourceResolver.Filter filter) {
        this.model = model;
        this.run = run;
        this.filter = filter;
    }

    public Resource initialize(WriteGraph graph) throws DatabaseException {
        Resource log;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        this.eventLog = log = graph.newResource();
        graph.claim(log, L0.InstanceOf, null, EVENT.EventLog);
        graph.claimLiteral(log, L0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claim(this.model, EVENT.HasEventLog, log);
        graph.claim(this.model, L0.ConsistsOf, log);
        final Resource _log = log;
        VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        graph.syncRequest((Write)new WriteRequest(support.getGraph((ReadGraph)graph, this.run)){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.claim(_log, EVENT.HasEventProducer, EventSupport.this.run);
            }
        });
        this.resolver = new EventSourceResolver(graph.getProvider(), log, this.filter);
        this.writer = new EventWriterJob(graph.getProvider(), log, this.resolver);
        this.resolver.schedule();
        return log;
    }

    public void queue(EventWriteTask task) {
        EventWriterJob w = this.writer;
        if (w != null) {
            w.queue(task);
        }
    }

    public void dispose() {
        if (this.writer != null) {
            this.writer.dispose();
            this.writer = null;
        }
        if (this.resolver != null) {
            this.resolver.dispose();
            this.resolver = null;
        }
    }
}

