/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.io.Serializable;
import org.simantics.scenegraph.utils.GridUtils;

public final class GridSpacing
implements Serializable {
    private static final long serialVersionUID = 8445639004963828463L;
    public static final double GRID_MIN_USER_SIZE = 1.0E-6;
    public static final GridSpacing SOME_SPACING = GridSpacing.makeGridSpacing(100.0, 100.0, 40.0);
    public double minPixels;
    public double segment;
    public double segmentExp;
    public double pixelsPerUnit;
    public double unitsPerPixel;
    public double pixelsPerSegment;

    public GridSpacing(double spacing, double spacingExp, double unitsPerPixel, double minPixels) {
        this.unitsPerPixel = unitsPerPixel;
        this.pixelsPerUnit = 1.0 / unitsPerPixel;
        this.segment = spacing;
        this.segmentExp = spacingExp;
        this.pixelsPerSegment = spacing * this.pixelsPerUnit;
        this.minPixels = minPixels;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridSpacing)) {
            return false;
        }
        GridSpacing g2 = (GridSpacing)obj;
        if (this.pixelsPerUnit != g2.pixelsPerUnit) {
            return false;
        }
        if (this.pixelsPerSegment != g2.pixelsPerSegment) {
            return false;
        }
        if (this.unitsPerPixel != g2.unitsPerPixel) {
            return false;
        }
        if (this.segment != g2.segment) {
            return false;
        }
        return this.segmentExp == g2.segmentExp;
    }

    public static GridSpacing makeGridSpacing(double viewboxSize, double controlWidth, double minPixels) {
        if (controlWidth == 0.0) {
            controlWidth = 1.0;
        }
        if (Math.abs(viewboxSize) < 1.0E-6) {
            viewboxSize = 1.0E-6 * Math.signum(viewboxSize);
        }
        double unitsPerPixel = viewboxSize / Math.max(controlWidth, minPixels);
        double[] gridSpacing = GridSpacing.getGridSpacing(unitsPerPixel, minPixels);
        return new GridSpacing(gridSpacing[0], gridSpacing[1], unitsPerPixel, minPixels);
    }

    public static GridSpacing makeGridSpacingForTime(double viewboxSize, double controlWidth, double minPixels) {
        if (controlWidth == 0.0) {
            controlWidth = 1.0;
        }
        if (viewboxSize < 1.0E-6) {
            viewboxSize = 1.0;
        }
        double unitsPerPixel = viewboxSize / Math.max(controlWidth, minPixels);
        double[] gridSpacing = GridSpacing.getGridSpacing(unitsPerPixel, minPixels);
        return new GridSpacing(gridSpacing[0], gridSpacing[1], unitsPerPixel, minPixels);
    }

    private static double[] getGridSpacing(double unitsPerPixel, double minPixels) {
        double minGridSize = minPixels * unitsPerPixel;
        double[] gridSpacing = GridUtils.getEvenGridSpacingWithExp((double)minGridSize, (double[])new double[2]);
        return gridSpacing;
    }

    public double snapToGrid(double pos) {
        return GridUtils.snapToGrid((double)pos, (double)this.segment);
    }
}

