/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram;

import gnu.trove.map.hash.THashMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.EndKeyOf;
import org.simantics.g2d.connection.TerminalKeyOf;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.Children;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.routing.ConnectionDirectionUtil;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.g2d.routing.TrivialRouter2;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DiagramUtils {
    private static final ThreadLocal<List<IElement>> elements = new ThreadLocal<List<IElement>>(){

        @Override
        protected List<IElement> initialValue() {
            return new ArrayList<IElement>();
        }
    };

    public static Rectangle2D getContentRect(IDiagram d) {
        return DiagramUtils.getContentRect(d.getElements());
    }

    public static Rectangle2D getContentRect(Collection<IElement> elements) {
        Rectangle2D diagramRect = null;
        Rectangle2D.Double elementRect = new Rectangle2D.Double();
        for (IElement el : elements) {
            if (ElementUtils.isHidden(el)) continue;
            InternalSize size = el.getElementClass().getSingleItem(InternalSize.class);
            ((Rectangle2D)elementRect).setRect(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            size.getBounds(el, elementRect);
            if (!Double.isFinite(((RectangularShape)elementRect).getWidth()) || !Double.isFinite(((RectangularShape)elementRect).getHeight()) || !Double.isFinite(((RectangularShape)elementRect).getX()) || !Double.isFinite(((RectangularShape)elementRect).getY())) continue;
            Transform t = el.getElementClass().getSingleItem(Transform.class);
            AffineTransform at = t.getTransform(el);
            Rectangle2D transformedRect = GeometryUtils.transformRectangle((AffineTransform)at, (Rectangle2D)elementRect);
            if (diagramRect == null) {
                diagramRect = new Rectangle2D.Double(transformedRect.getX(), transformedRect.getY(), transformedRect.getWidth(), transformedRect.getHeight());
                continue;
            }
            diagramRect.add(transformedRect);
        }
        return diagramRect;
    }

    public static void pick(IDiagram d, PickRequest request, Collection<IElement> result) {
        PickContext pc = d.getDiagramClass().getSingleItem(PickContext.class);
        pc.pick(d, request, result);
    }

    public static void invalidate(IDiagram d) {
        d.setHint(Hints.KEY_DIRTY, Hints.VALUE_SG_DIRTY);
    }

    public static void validateAndFix(IDiagram d, ICanvasContext context) {
        DiagramUtils.validateAndFix(d, d.getElements());
    }

    public static void validateAndFix(IDiagram d, Collection<IElement> elementsToFix) {
        IRouter2 defaultRouter = ElementUtils.getHintOrDefault(d, DiagramHints.ROUTE_ALGORITHM, TrivialRouter2.INSTANCE);
        final Topology topology = d.getDiagramClass().getSingleItem(Topology.class);
        List<IElement> segments = elements.get();
        final List<IElement> unmodifiableSegments = Collections.unmodifiableList(segments);
        for (IElement element : elementsToFix) {
            if (!d.containsElement(element)) {
                System.err.println("Fixing element not contained by diagram " + d + ": " + element);
                continue;
            }
            ConnectionHandler ch = element.getElementClass().getAtMostOneItemOfClass(ConnectionHandler.class);
            if (ch == null) continue;
            segments.clear();
            ch.getSegments(element, segments);
            if (segments.isEmpty()) continue;
            IRouter2 router = ElementUtils.getHintOrDefault(element, DiagramHints.ROUTE_ALGORITHM, defaultRouter);
            for (IElement e : unmodifiableSegments) {
                if (!e.getElementClass().containsClass(BendsHandler.class)) continue;
                router.route(new IConnection(){
                    THashMap<IElement, IConnection.Connector> branchPoints = new THashMap();

                    @Override
                    public IConnection.Connector getBegin(Object seg) {
                        IConnection.Connector connector;
                        IElement e = (IElement)seg;
                        Topology.Connection begin = topology.getConnection(e, EdgeVisuals.EdgeEnd.Begin);
                        IConnection.Connector connector2 = connector = begin == null ? null : (IConnection.Connector)this.branchPoints.get((Object)begin.node);
                        if (connector != null) {
                            return connector;
                        }
                        connector = new IConnection.Connector();
                        if (begin == null) {
                            BendsHandler bends = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
                            ArrayList<BendsHandler.Bend> bs = new ArrayList<BendsHandler.Bend>();
                            bends.getBends(e, bs);
                            Point2D.Double p = new Point2D.Double();
                            if (bs.size() > 0) {
                                bends.getBendPosition(e, (BendsHandler.Bend)bs.get(0), p);
                            } else {
                                ((Point2D)p).setLocation(0.0, 0.0);
                            }
                            AffineTransform elementTransform = ElementUtils.getTransform(e);
                            elementTransform.transform(p, p);
                            connector.x = ((Point2D)p).getX();
                            connector.y = ((Point2D)p).getY();
                            connector.allowedDirections = 15;
                        } else {
                            AffineTransform at = TerminalUtil.getTerminalPosOnDiagram(begin.node, begin.terminal);
                            connector.x = at.getTranslateX();
                            connector.y = at.getTranslateY();
                            connector.parentObstacle = DiagramUtils.getObstacleShape(begin.node);
                            BranchPoint bph = begin.node.getElementClass().getAtMostOneItemOfClass(BranchPoint.class);
                            if (bph != null) {
                                this.branchPoints.put((Object)begin.node, (Object)connector);
                                connector.allowedDirections = this.toAllowedDirections(bph.getDirectionPreference(begin.node, BranchPoint.Direction.Any));
                            } else {
                                ConnectionDirectionUtil.determineAllowedDirections(connector);
                            }
                        }
                        return connector;
                    }

                    private int toAllowedDirections(BranchPoint.Direction direction) {
                        switch (direction) {
                            case Any: {
                                return 15;
                            }
                            case Horizontal: {
                                return 5;
                            }
                            case Vertical: {
                                return 10;
                            }
                        }
                        throw new IllegalArgumentException("unrecognized direction: " + (Object)((Object)direction));
                    }

                    @Override
                    public IConnection.Connector getEnd(Object seg) {
                        IConnection.Connector connector;
                        IElement e = (IElement)seg;
                        Topology.Connection end = topology.getConnection(e, EdgeVisuals.EdgeEnd.End);
                        IConnection.Connector connector2 = connector = end == null ? null : (IConnection.Connector)this.branchPoints.get((Object)end.node);
                        if (connector != null) {
                            return connector;
                        }
                        connector = new IConnection.Connector();
                        if (end == null) {
                            BendsHandler bends = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
                            ArrayList<BendsHandler.Bend> bs = new ArrayList<BendsHandler.Bend>();
                            bends.getBends(e, bs);
                            Point2D.Double p = new Point2D.Double();
                            if (bs.size() > 0) {
                                bends.getBendPosition(e, (BendsHandler.Bend)bs.get(bs.size() - 1), p);
                            } else {
                                ((Point2D)p).setLocation(0.0, 0.0);
                            }
                            AffineTransform elementTransform = ElementUtils.getTransform(e);
                            elementTransform.transform(p, p);
                            connector.x = ((Point2D)p).getX();
                            connector.y = ((Point2D)p).getY();
                            connector.allowedDirections = 15;
                        } else {
                            AffineTransform at = TerminalUtil.getTerminalPosOnDiagram(end.node, end.terminal);
                            connector.x = at.getTranslateX();
                            connector.y = at.getTranslateY();
                            connector.parentObstacle = DiagramUtils.getObstacleShape(end.node);
                            BranchPoint bph = end.node.getElementClass().getAtMostOneItemOfClass(BranchPoint.class);
                            if (bph != null) {
                                this.branchPoints.put((Object)end.node, (Object)connector);
                                connector.allowedDirections = this.toAllowedDirections(bph.getDirectionPreference(end.node, BranchPoint.Direction.Any));
                            } else {
                                ConnectionDirectionUtil.determineAllowedDirections(connector);
                            }
                        }
                        return connector;
                    }

                    @Override
                    public Collection<? extends Object> getSegments() {
                        return unmodifiableSegments;
                    }

                    @Override
                    public void setPath(Object seg, Path2D path) {
                        IElement e = (IElement)seg;
                        BendsHandler bends = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
                        AffineTransform elementTransform = ElementUtils.getInvTransform(e);
                        path = (Path2D)path.clone();
                        path.transform(elementTransform);
                        bends.setPath(e, path);
                    }
                });
            }
        }
        segments.clear();
    }

    public static void inDiagramTransaction(IDiagram diagram, TransactionContext.TransactionType type, Runnable r) {
        TransactionContext ctx = diagram.getDiagramClass().getAtMostOneItemOfClass(TransactionContext.class);
        if (ctx == null) {
            throw new IllegalArgumentException("Diagram does not have a TransactionContext handler: " + diagram + ". Cannot execute runnable " + r);
        }
        TransactionContext.Transaction txn = ctx.startTransaction(diagram, type);
        try {
            r.run();
        }
        finally {
            ctx.finishTransaction(diagram, txn);
        }
    }

    public static void mutateDiagram(IDiagram diagram, Consumer<DiagramMutator> callback) {
        DiagramMutator mutator = (DiagramMutator)diagram.getHint(DiagramHints.KEY_MUTATOR);
        if (mutator == null) {
            throw new IllegalArgumentException("Diagram does not have an associated DiagramMutator (see DiagramHints.KEY_MUTATOR).");
        }
        TransactionContext ctx = diagram.getDiagramClass().getAtMostOneItemOfClass(TransactionContext.class);
        if (ctx == null) {
            throw new IllegalArgumentException("Diagram does not have a TransactionContext handler: " + diagram + ". Cannot execute callback " + callback);
        }
        TransactionContext.Transaction txn = ctx.startTransaction(diagram, TransactionContext.TransactionType.WRITE);
        boolean committed = false;
        try {
            mutator.clear();
            callback.accept(mutator);
            mutator.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                mutator.clear();
            }
            ctx.finishTransaction(diagram, txn);
        }
    }

    public static void synchronizeHintsToBackend(IDiagram diagram, IElement ... elements) {
        DiagramUtils.synchronizeHintsToBackend(diagram, Arrays.asList(elements));
    }

    public static void synchronizeHintsToBackend(IDiagram diagram, Collection<IElement> elements) {
        DiagramUtils.mutateDiagram(diagram, m -> {
            for (IElement e : elements) {
                m.synchronizeHintsToBackend(e);
            }
        });
    }

    public static Collection<IElement> withChildren(Collection<IElement> elements) {
        ArrayList<IElement> result = new ArrayList<IElement>(elements.size() * 2);
        result.addAll(elements);
        int pos = 0;
        while (pos < result.size()) {
            IElement element = result.get(pos);
            Children children = element.getElementClass().getAtMostOneItemOfClass(Children.class);
            if (children != null) {
                children.getChildren(element, result);
            }
            ++pos;
        }
        return result;
    }

    public static Collection<IElement> withDirectChildren(Collection<IElement> elements) {
        ArrayList<IElement> result = new ArrayList<IElement>(elements);
        return DiagramUtils.getDirectChildren(elements, result);
    }

    public static Collection<IElement> getDirectChildren(Collection<IElement> elements, Collection<IElement> result) {
        for (IElement element : elements) {
            Children children = element.getElementClass().getAtMostOneItemOfClass(Children.class);
            if (children == null) continue;
            children.getChildren(element, result);
        }
        return result;
    }

    public static void testInclusion(IDiagram diagram, IElement e) {
        BendsHandler bh = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
        BranchPoint bp = e.getElementClass().getAtMostOneItemOfClass(BranchPoint.class);
        DiagramUtils.assertAndPrint(e, e instanceof Element);
        if (bh == null && bp == null) {
            DiagramUtils.assertAndPrint(e, diagram == e.peekDiagram());
        } else {
            DiagramUtils.assertAndPrint(e, e.peekDiagram() == null);
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            DiagramUtils.assertAndPrint(e, ce != null);
            DiagramUtils.assertAndPrint(e, diagram == ce.getConnection().getDiagram());
        }
    }

    public static void testDiagram(IDiagram diagram) {
        if (!(diagram instanceof Diagram)) {
            return;
        }
        Collection<IElement> es = DiagramUtils.withChildren(diagram.getSnapshot());
        for (IElement e : es) {
            System.out.println("test element " + e + " " + e.getElementClass());
            DiagramUtils.testInclusion(diagram, e);
            Set entrySet = e.getHintsOfClass(TerminalKeyOf.class).entrySet();
            for (Map.Entry entry : entrySet) {
                Topology.Connection c = (Topology.Connection)entry.getValue();
                DiagramUtils.testInclusion(diagram, c.node);
                DiagramUtils.testInclusion(diagram, c.edge);
            }
            BendsHandler bh = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (bh == null) continue;
            Collection values = e.getHintsOfClass(EndKeyOf.class).values();
            DiagramUtils.assertAndPrint(e, values.size() == 2);
            Iterator it = values.iterator();
            Topology.Connection e1 = (Topology.Connection)it.next();
            Topology.Connection e2 = (Topology.Connection)it.next();
            DiagramUtils.testInclusion(diagram, e1.node);
            DiagramUtils.testInclusion(diagram, e1.edge);
            DiagramUtils.testInclusion(diagram, e2.node);
            DiagramUtils.testInclusion(diagram, e2.edge);
            DiagramUtils.assertAndPrint(e, e1.end.equals((Object)e2.end.other()));
        }
    }

    public static void pruneDiagram(IDiagram diagram) {
        if (!(diagram instanceof Diagram)) {
            return;
        }
        Collection<IElement> es = DiagramUtils.withChildren(diagram.getSnapshot());
        for (IElement e : es) {
            Set values;
            BendsHandler bh = e.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (bh == null || (values = e.getHintsOfClass(EndKeyOf.class).entrySet()).size() != 2) continue;
            Iterator it = values.iterator();
            Map.Entry e1 = it.next();
            Map.Entry e2 = it.next();
            if (!(((Topology.Connection)e1.getValue()).node instanceof Element)) {
                e.removeHint((IHintContext.Key)e1.getKey());
                System.out.println("###################### PRUNED: ");
            }
            if (((Topology.Connection)e2.getValue()).node instanceof Element) continue;
            e.removeHint((IHintContext.Key)e2.getKey());
            System.out.println("###################### PRUNED: ");
        }
    }

    private static void assertAndPrint(IElement element, boolean condition) {
        if (!condition) {
            System.out.println("ASSERTION FAILED FOR");
            System.out.println("-" + element);
            System.out.println("-" + element.getElementClass());
            assert (condition);
        }
    }

    public static Rectangle2D getObstacleShape(IElement e) {
        double temp;
        Rectangle2D rect = ElementUtils.getElementBounds(e);
        AffineTransform at = ElementUtils.getTransform(e);
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        ((Point2D)p1).setLocation(rect.getMinX(), rect.getMinY());
        at.transform(p1, p1);
        ((Point2D)p2).setLocation(rect.getMaxX(), rect.getMaxY());
        at.transform(p2, p2);
        double x0 = ((Point2D)p1).getX();
        double y0 = ((Point2D)p1).getY();
        double x1 = ((Point2D)p2).getX();
        double y1 = ((Point2D)p2).getY();
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
        }
        if (y0 > y1) {
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        double OBSTACLE_MARGINAL = 1.0;
        return new Rectangle2D.Double(x0 - OBSTACLE_MARGINAL, y0 - OBSTACLE_MARGINAL, x1 - x0 + OBSTACLE_MARGINAL * 2.0, y1 - y0 + OBSTACLE_MARGINAL * 2.0);
    }
}

