/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.contribution;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.contribution.EventLabelRule;
import org.simantics.event.view.preference.EventPrefs;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

public enum ProjectEventsRule implements ChildRule
{
    INSTANCE;


    public static ProjectEventsRule get() {
        return INSTANCE;
    }

    public Collection<?> getChildrenImpl(ReadGraph graph, Resource project, Prefs prefs, List<Resource> eventLogs) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        boolean hideInfoEvents = prefs.hideInfoEvents;
        boolean hideWarningEvents = prefs.hideWarningEvents;
        boolean hideReturnEvents = prefs.hideReturnEvents;
        boolean showHiddenEvents = prefs.showHiddenEvents;
        boolean showOnlyMilestones = prefs.showOnlyMilestones;
        boolean showOnlyActiveEvents = prefs.showOnlyActiveEvents;
        ArrayList allEvents = new ArrayList();
        for (Resource log : eventLogs) {
            for (Resource slice : graph.getObjects(log, L0.ConsistsOf)) {
                Collection events = graph.getObjects(slice, L0.ConsistsOf);
                allEvents.addAll(events);
            }
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        final TObjectDoubleHashMap times = new TObjectDoubleHashMap();
        Double defaultTime = 0.0;
        for (Resource event : allEvents) {
            Integer severity;
            Resource eventType;
            boolean isReturnEvent;
            boolean isMilestone;
            if (showOnlyMilestones && !(isMilestone = graph.hasStatement(event, EVENT.Milestone)) || !showHiddenEvents && graph.hasStatement(event, EVENT.Hidden)) continue;
            boolean bl = isReturnEvent = hideReturnEvents || showOnlyActiveEvents ? graph.hasStatement(event, EVENT.ReturnEvent) : false;
            if (hideReturnEvents && isReturnEvent || showOnlyActiveEvents && (isReturnEvent || graph.hasStatement(event, EVENT.Returns) || graph.hasStatement(event, EVENT.ReturnedBy) || graph.hasStatement(event, EVENT.NoReturn)) || (eventType = graph.getPossibleObject(event, EVENT.Event_type)) != null && (severity = (Integer)graph.getPossibleRelatedValue(eventType, EVENT.EventType_severity)) != null && (hideInfoEvents && severity >= 600 && severity < 700 || hideWarningEvents && severity >= 700 && severity < 800)) continue;
            double timeNumeric = EventLabelRule.getTimestamp(graph, event, defaultTime);
            times.put((Object)event, timeNumeric);
            result.add(event);
        }
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                double t1 = times.get(o1);
                double t2 = times.get(o2);
                return Double.compare(t1, t2);
            }
        });
        return result;
    }

    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        Resource project = (Resource)parent;
        ArrayList<Resource> eventLogs = new ArrayList<Resource>();
        for (Resource activeModel : (Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0X.Activates, SIMU.Model))) {
            for (Resource eventLog : (Collection)graph.syncRequest((Read)new ObjectsWithType(activeModel, EVENT.HasEventLog, EVENT.EventLog))) {
                if (graph.hasStatement(eventLog, EVENT.Hidden)) continue;
                eventLogs.add(eventLog);
                graph.getRelatedValue(eventLog, EVENT.HasModificationCounter, (Binding)Bindings.INTEGER);
            }
        }
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        return this.getChildrenImpl(qc.getIndependentGraph(graph), project, Prefs.read(graph, project), eventLogs);
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        if (!(child instanceof Resource)) {
            return Collections.emptyList();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return graph.getObjects((Resource)child, L0.PartOf);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    private static class Prefs {
        public final boolean hideInfoEvents;
        public final boolean hideWarningEvents;
        public final boolean hideReturnEvents;
        public final boolean showHiddenEvents;
        public final boolean showOnlyMilestones;
        public final boolean showOnlyActiveEvents;

        public Prefs(boolean hideInfoEvents, boolean hideWarningEvents, boolean hideReturnEvents, boolean showHiddenEvents, boolean showOnlyMilestones, boolean showOnlyActiveEvents) {
            this.hideInfoEvents = hideInfoEvents;
            this.hideWarningEvents = hideWarningEvents;
            this.hideReturnEvents = hideReturnEvents;
            this.showHiddenEvents = showHiddenEvents;
            this.showOnlyMilestones = showOnlyMilestones;
            this.showOnlyActiveEvents = showOnlyActiveEvents;
        }

        public static Prefs read(ReadGraph graph, Resource project) throws DatabaseException {
            return new Prefs(EventPrefs.hideInfoEvents(graph, project), EventPrefs.hideWarningEvents(graph, project), EventPrefs.hideReturnEvents(graph, project), EventPrefs.showHiddenEvents(graph, project), EventPrefs.showOnlyMilestones(graph, project), EventPrefs.showOnlyActiveEvents(graph, project));
        }
    }
}

