/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.io.File;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.XSupport;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;

public class SessionUtil {
    private String clientId;
    private File workspace;
    private ServerManager serverManager = ServerManagerFactory.getServerManager();
    private ServerEx server;
    private Session session;

    public static String getApplicationClientId() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "noProduct";
        }
        String application = product.getApplication();
        return application != null ? application : UUID.randomUUID().toString();
    }

    public SessionUtil() {
        this(UUID.randomUUID().toString());
    }

    public SessionUtil(String clientId) {
        this.clientId = clientId;
    }

    public void close() throws DatabaseException {
        if (this.session != null) {
            ((LifecycleSupport)this.session.getService(LifecycleSupport.class)).close();
        }
        this.serverManager.close();
    }

    private Session openSession(ServerEx server, File dbDir) throws DatabaseException {
        Properties info = new Properties(ServerManager.DEFAULT);
        this.session = server.createSession(info);
        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, true);
        return this.session;
    }
}

