/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util.subscription;

import java.util.Arrays;
import java.util.Comparator;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class SamplingFormat
extends Bean {
    public static final SamplingFormat[] EMPTY = new SamplingFormat[0];
    public static final Comparator<Bean> INTERVAL_COMPARATOR = new Comparator<Bean>(){

        @Override
        public int compare(Bean o1, Bean o2) {
            double i1 = (Double)o1.getFieldUnchecked("interval");
            double i2 = (Double)o2.getFieldUnchecked("interval");
            boolean nan1 = Double.isNaN(i1);
            boolean nan2 = Double.isNaN(i2);
            if (nan1 && nan2) {
                return 0;
            }
            if (nan1 && !nan2) {
                return -1;
            }
            if (!nan1 && nan2) {
                return 1;
            }
            return i1 == i2 ? 0 : (i1 < i2 ? -1 : 1);
        }
    };
    public static final Comparator<SamplingFormat> DEADBAND_COMPARATOR = new Comparator<SamplingFormat>(){

        @Override
        public int compare(SamplingFormat o1, SamplingFormat o2) {
            boolean nan1 = Double.isNaN(o1.deadband);
            boolean nan2 = Double.isNaN(o2.deadband);
            if (nan1 && nan2) {
                return 0;
            }
            if (nan1 && !nan2) {
                return -1;
            }
            if (!nan1 && nan2) {
                return 1;
            }
            return o1.deadband == o2.deadband ? 0 : (o1.deadband < o2.deadband ? -1 : 1);
        }
    };
    public String formatId;
    public Datatype format;
    public double interval = Double.NaN;
    public double deadband = Double.NaN;
    public static SamplingFormat simple = new SamplingFormat();
    public static SamplingFormat allfields;
    public static SamplingFormat vector;

    static {
        SamplingFormat.simple.formatId = "Simple";
        SamplingFormat.simple.format = new RecordType();
        RecordType format = SamplingFormat.simple.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        SamplingFormat.simple.interval = Double.NaN;
        SamplingFormat.simple.deadband = Double.NaN;
        allfields = new SamplingFormat();
        SamplingFormat.allfields.formatId = "Allfields";
        SamplingFormat.allfields.format = new RecordType();
        SamplingFormat.allfields.format = new RecordType();
        format = SamplingFormat.allfields.format;
        format.addComponent("time", (Datatype)Datatypes.DOUBLE);
        format.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
        format.addComponent("value", (Datatype)Datatypes.DOUBLE);
        format.addComponent("lastValue", (Datatype)Datatypes.DOUBLE);
        format.addComponent("min", (Datatype)Datatypes.DOUBLE);
        format.addComponent("max", (Datatype)Datatypes.DOUBLE);
        format.addComponent("avg", (Datatype)Datatypes.DOUBLE);
        format.addComponent("median", (Datatype)Datatypes.DOUBLE);
        format.addComponent("quality", (Datatype)Datatypes.BYTE);
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        SamplingFormat.allfields.interval = Double.NaN;
        SamplingFormat.allfields.deadband = Double.NaN;
        vector = new SamplingFormat();
        SamplingFormat.vector.formatId = "Vector";
        SamplingFormat.vector.format = new RecordType();
        SamplingFormat.vector.format = new RecordType();
        format = SamplingFormat.vector.format;
        format.addComponent("time", (Datatype)Datatypes.FLOAT);
        format.addComponent("endTime", (Datatype)Datatypes.FLOAT);
        format.addComponent("value", (Datatype)new ArrayType((Datatype)Datatypes.DOUBLE, Range.between((Limit)Limit.inclusive((Integer)3), (Limit)Limit.inclusive((Integer)3))));
        format.addComponent("count", (Datatype)Datatypes.INTEGER);
        SamplingFormat.vector.interval = Double.NaN;
        SamplingFormat.vector.deadband = Double.NaN;
    }

    public SamplingFormat() {
    }

    public SamplingFormat(String id, RecordType sampleType, double interval, double deadband) {
        this.formatId = id;
        this.format = sampleType;
        this.interval = interval;
        this.deadband = deadband;
    }

    public RecordType record() {
        return (RecordType)this.format;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SamplingFormat)) {
            return false;
        }
        SamplingFormat other = (SamplingFormat)((Object)obj);
        return this.formatId.equals(other.formatId);
    }

    public String toString() {
        return "id=" + this.formatId + ", " + this.format + ", interval=" + this.interval + ", deadband=" + this.deadband;
    }

    public SamplingFormat clone() {
        try {
            SamplingFormat result = new SamplingFormat();
            result.formatId = this.formatId;
            result.interval = this.interval;
            result.deadband = this.deadband;
            result.format = (Datatype)Bindings.getBindingUnchecked(Datatype.class).clone((Object)this.format);
            return result;
        }
        catch (AdaptException e) {
            throw new RuntimeException(e);
        }
    }

    public SamplingFormat clone(double interval, double deadband) {
        try {
            SamplingFormat result = new SamplingFormat();
            result.formatId = this.formatId;
            result.interval = interval;
            result.deadband = deadband;
            result.format = (Datatype)Bindings.getBindingUnchecked(Datatype.class).clone((Object)this.format);
            return result;
        }
        catch (AdaptException e) {
            throw new RuntimeException(e);
        }
    }

    public SamplingFormat cloneTo(String id, double interval, double deadband) {
        try {
            SamplingFormat result = new SamplingFormat();
            result.formatId = id;
            result.interval = interval;
            result.deadband = deadband;
            result.format = (Datatype)Bindings.getBindingUnchecked(Datatype.class).clone((Object)this.format);
            return result;
        }
        catch (AdaptException e) {
            throw new RuntimeException(e);
        }
    }

    public SamplingFormat setUnit(String unit) {
        int i = 0;
        while (i < this.format.getComponentCount()) {
            Component c = ((RecordType)this.format).getComponent(i);
            if ((c.name.equals("value") || c.name.equals("min") || c.name.equals("max") || c.name.equals("avg") || c.name.equals("median")) && c.type instanceof NumberType) {
                NumberType nt = (NumberType)c.type;
                nt.setUnit(unit);
            }
            ++i;
        }
        return this;
    }

    public static void sortByInterval(SamplingFormat[] formats) {
        Arrays.sort(formats, INTERVAL_COMPARATOR);
    }

    public static void sortByDeadband(SamplingFormat[] formats) {
        Arrays.sort(formats, DEADBAND_COMPARATOR);
    }
}

