/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.adapter.SubgraphAdvisor;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.Subgraphs;
import org.simantics.db.layer0.util.TransferableGraphConfiguration;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;

public class TransferableGraphRequest
implements Read<TransferableGraph1> {
    public static String LOG_FILE = "transferableGraph.log";
    private static final boolean LOG = false;
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    private TransferableGraphConfiguration configuration;
    static DataOutput log;
    Layer0 l0;
    TIntArrayList inverses = new TIntArrayList();
    int[] statements;
    int statementIndex = 0;
    Map<Resource, Integer> ids;
    Map<Resource, Variant> values;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    int id = 0;
    int internalCount;
    int indent = 0;
    private Serializer variantSerializer;

    private static void log(String line) {
    }

    public TransferableGraphRequest(Collection<Pair<Resource, String>> roots, Resource model) {
        this.configuration = new TransferableGraphConfiguration();
        this.configuration.roots = roots;
        this.configuration.model = model;
    }

    public TransferableGraphRequest(Collection<Pair<Resource, String>> roots) {
        this(roots, null);
    }

    public TransferableGraphRequest(TransferableGraphConfiguration conf) {
        this.configuration = conf;
    }

    private boolean validateExternal(Resource r) {
        if (this.configuration.disallowedExternals != null) {
            System.err.println("validateExternal agains " + this.configuration.disallowedExternals);
            return !this.configuration.disallowedExternals.contains(r);
        }
        return true;
    }

    public int getId(ReadGraph graph, Resource r, Resource predicate) throws DatabaseException {
        if (this.ids.containsKey(r)) {
            int ret = this.ids.get(r);
            if (ret == -1) {
                int i = 0;
                while (i <= this.indent) {
                    System.out.print("  ");
                    ++i;
                }
                System.out.println("Cycle!!!");
            }
            return ret;
        }
        Collection parents = graph.getObjects(r, this.l0.PartOf);
        if (parents.size() != 1) {
            Resource inv;
            if (parents.size() == 0 && (inv = graph.getPossibleObject(r, this.l0.InverseOf)) != null) {
                ++this.indent;
                int invId = this.getId(graph, inv, null);
                this.externalParents.add(invId);
                --this.indent;
                this.externalNames.add("@inverse");
                this.ids.put(r, this.id);
                return this.id++;
            }
            throw new ValidationException("Reference to external resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true) + " without unique uri (" + parents.size() + " parents).");
        }
        for (Resource p : parents) {
            ++this.indent;
            if (!this.validateExternal(p)) {
                throw new ValidationException("References to '" + graph.getURI(p) + "' are not allowed.");
            }
            this.externalParents.add(this.getId(graph, p, null));
            --this.indent;
        }
        this.externalNames.add((String)graph.getRelatedValue(r, this.l0.HasName));
        this.ids.put(r, this.id);
        return this.id++;
    }

    public void addId(ReadGraph graph, Resource r, Resource predicate) throws DatabaseException {
        this.statements[this.statementIndex++] = this.getId(graph, r, predicate);
    }

    private void searchStatementPart(ReadGraph graph, final ConcurrentSkipListSet<Statement> statementSet, final ArrayList<Pair<Resource, Triple[]>> part, final Set<SubgraphExtent> extents) throws DatabaseException {
        final SubgraphExtent.Callback callback = new SubgraphExtent.Callback(){

            @Override
            public void statement(Statement statement, boolean accept) {
                if (accept) {
                    statementSet.add(statement);
                }
            }
        };
        graph.syncRequest((AsyncRead)new AsyncRead<Boolean>(){

            public int threadHash() {
                return this.hashCode();
            }

            public void perform(AsyncReadGraph graph, AsyncProcedure<Boolean> procedure) {
                QueryControl control = (QueryControl)graph.getService(QueryControl.class);
                int slice = part.size() / control.getAmountOfQueryThreads() + 1;
                final Pair[] rootArray = part.toArray(new Pair[part.size()]);
                int i = 0;
                while (i < control.getAmountOfQueryThreads()) {
                    final int start = i * slice;
                    final int end = Math.min(start + slice, rootArray.length);
                    control.schedule(graph, i, new QueryControl.ControlProcedure(){

                        public void execute(AsyncReadGraph graph) {
                            int index = start;
                            while (index < end) {
                                final Pair r = rootArray[index];
                                final AtomicInteger position = new AtomicInteger(0);
                                final SubgraphExtent.Classifier[] classifiers = new SubgraphExtent.Classifier[extents.size()];
                                for (SubgraphExtent extent : extents) {
                                    extent.accept(graph, (Resource)r.first, new AsyncProcedure<SubgraphExtent.Classifier>(){

                                        public void execute(AsyncReadGraph graph, SubgraphExtent.Classifier c) {
                                            int current = position.incrementAndGet();
                                            classifiers[current - 1] = c;
                                            if (current == extents.size()) {
                                                Triple[] tripleArray = (Triple[])r.second;
                                                int n = tripleArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    Triple statement = tripleArray[n2];
                                                    if (((Resource)r.first).isPersistent()) {
                                                        SubgraphExtent.Classifier[] classifierArray = classifiers;
                                                        int n3 = classifiers.length;
                                                        int n4 = 0;
                                                        while (n4 < n3) {
                                                            SubgraphExtent.Classifier classifier = classifierArray[n4];
                                                            classifier.classify(graph, (Statement)new StandardStatement((Resource)r.first, (Resource)statement.first, (Resource)statement.second), (SubgraphExtent.ExtentStatus)((Object)statement.third), callback);
                                                            ++n4;
                                                        }
                                                    }
                                                    ++n2;
                                                }
                                            }
                                        }

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            throwable.printStackTrace();
                                        }
                                    }, callback);
                                }
                                ++index;
                            }
                        }
                    });
                    ++i;
                }
                procedure.execute(graph, (Object)false);
            }

            public int getFlags() {
                return 0;
            }
        });
    }

    private void searchStatements(ReadGraph graph, ObjectInputStream composedInput, ObjectInputStream statementInput, ObjectInputStream valueInput, Set<SubgraphExtent> extents) throws DatabaseException, IOException {
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        ConcurrentSkipListSet<Statement> statementSet = new ConcurrentSkipListSet<Statement>();
        StatementSetBuilder builder = new StatementSetBuilder(cs);
        SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        while (composedInput.available() > 0) {
            int s = composedInput.readInt();
            Resource subject = support.getResource(s);
            int size = composedInput.readInt();
            int n = 0;
            while (n < size) {
                int p = composedInput.readInt();
                int o = composedInput.readInt();
                StandardStatement stm = new StandardStatement(subject, support.getResource(p), support.getResource(o));
                builder.add((Statement)stm);
                ++n;
            }
        }
        while (statementInput.available() > 0) {
            ArrayList<Pair<Resource, Triple[]>> stms = new ArrayList<Pair<Resource, Triple[]>>();
            int counter = 0;
            while (statementInput.available() > 0 && counter++ < 1000) {
                int s = statementInput.readInt();
                Resource resource = support.getResource(s);
                int size = statementInput.readInt();
                Triple[] list = new Triple[size];
                stms.add((Pair<Resource, Triple[]>)Pair.make((Object)resource, (Object)list));
                int i = 0;
                while (i < size) {
                    int p = statementInput.readInt();
                    int o = statementInput.readInt();
                    list[i] = new Triple((Object)support.getResource(p), (Object)support.getResource(o), (Object)SubgraphExtent.ExtentStatus.EXTERNAL);
                    ++i;
                }
            }
            this.searchStatementPart(graph, statementSet, stms, extents);
        }
        builder.addAll(statementSet);
        statementSet = null;
        LinkedList<Collection<Statement>> statementSets = builder.get();
        Map inverses = (Map)cs.createMap(Resource.class);
        Set predicateSet = cs.createSet();
        for (Collection collection : statementSets) {
            for (Statement s : collection) {
                Resource predicate = s.getPredicate();
                if (!predicateSet.add(predicate)) continue;
                Resource inverse = graph.getPossibleInverse(predicate);
                inverses.put(predicate, inverse);
            }
        }
        predicateSet = null;
        this.statements = new int[4 * builder.size()];
        while (!statementSets.isEmpty()) {
            Collection<Statement> collection = statementSets.pop();
            for (Statement s : collection) {
                Resource subject = s.getSubject();
                Resource predicate = s.getPredicate();
                Resource object = s.getObject();
                int subjectId = this.ids.get(subject);
                int objectId = this.getId(graph, object, predicate);
                if (objectId != -2) {
                    this.statements[this.statementIndex++] = subjectId;
                    this.addId(graph, predicate, null);
                    Resource inverse = (Resource)inverses.get(predicate);
                    if (inverse != null) {
                        this.addId(graph, inverse, null);
                    } else {
                        this.statements[this.statementIndex++] = -1;
                    }
                    this.statements[this.statementIndex++] = objectId;
                    continue;
                }
                System.out.println("denied");
            }
        }
        inverses = null;
        while (valueInput.available() > 0) {
            int n = valueInput.readInt();
            Resource subject = support.getResource(n);
            int valueSize = valueInput.readInt();
            byte[] value = new byte[valueSize];
            valueInput.readFully(value);
            Variant variant = (Variant)this.variantSerializer.deserialize(value);
            this.values.put(subject, variant);
        }
    }

    public void setExternals(Collection<Resource> rs) {
        this.configuration.externals = rs;
    }

    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
        Set<SubgraphAdvisor> advisors;
        this.variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        long total = System.nanoTime();
        long startupTime = System.nanoTime();
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        this.ids = (Map)cs.createMap(Integer.class);
        this.values = (Map)cs.createMap(byte[].class);
        ArrayList<Resource> rootResources = new ArrayList<Resource>();
        for (Pair<Resource, String> p : this.configuration.roots) {
            rootResources.add((Resource)p.first);
        }
        HashMap<Resource, SubgraphExtent.ExtentStatus> preStatus = new HashMap<Resource, SubgraphExtent.ExtentStatus>();
        for (Resource root : rootResources) {
            Resource name = graph.getPossibleObject(root, this.l0.HasName);
            if (name == null) continue;
            preStatus.put(name, SubgraphExtent.ExtentStatus.EXCLUDED);
        }
        for (Resource r : this.configuration.externals) {
            preStatus.put(r, SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        Set<SubgraphExtent> extents = this.configuration.extents;
        if (extents == null) {
            Instances extentInstances = (Instances)graph.adapt(L0X.SubgraphExtent, Instances.class);
            Collection<Resource> extentResources = extentInstances.find(graph, this.configuration.model);
            extents = new HashSet<SubgraphExtent>();
            for (Resource r : extentResources) {
                extents.add((SubgraphExtent)graph.getPossibleAdapter(r, SubgraphExtent.class));
            }
        }
        if ((advisors = this.configuration.advisors) == null) {
            Instances advisorInstances = (Instances)graph.adapt(L0X.SubgraphAdvisor, Instances.class);
            Collection<Resource> advisorResources = advisorInstances.find(graph, this.configuration.model);
            advisors = new HashSet<SubgraphAdvisor>();
            for (Resource r : advisorResources) {
                advisors.add((SubgraphAdvisor)graph.getPossibleAdapter(r, SubgraphAdvisor.class));
            }
        }
        long startupTimeEnd = System.nanoTime();
        long domainTime = System.nanoTime();
        String composedStatements = "composed" + UUID.randomUUID().toString();
        String otherStatements = "other" + UUID.randomUUID().toString();
        String valueFileName = "value" + UUID.randomUUID().toString();
        File composedStatementsFile = new File(composedStatements);
        File otherStatementsFile = new File(otherStatements);
        File valueFile = new File(valueFileName);
        try {
            DeferredFileOutputStream composedStatementsStream = new DeferredFileOutputStream(0x500000, composedStatementsFile);
            DeferredFileOutputStream otherStatementsStream = new DeferredFileOutputStream(0x100000, otherStatementsFile);
            DeferredFileOutputStream valueStream = new DeferredFileOutputStream(0x100000, valueFile);
            ObjectOutputStream composedStatementsOutput = new ObjectOutputStream((OutputStream)composedStatementsStream);
            ObjectOutputStream otherStatementsOutput = new ObjectOutputStream((OutputStream)otherStatementsStream);
            ObjectOutputStream valueOutput = new ObjectOutputStream((OutputStream)valueStream);
            Subgraphs.getDomain(graph, this.ids, rootResources, preStatus, advisors, composedStatementsOutput, otherStatementsOutput, valueOutput);
            this.id = this.ids.size();
            composedStatementsOutput.flush();
            otherStatementsOutput.flush();
            valueOutput.flush();
            composedStatementsStream.close();
            otherStatementsStream.close();
            valueStream.close();
            long domainTimeEnd = System.nanoTime();
            long fileTime = System.nanoTime();
            this.internalCount = this.id;
            this.ids.put(graph.getRootLibrary(), this.id++);
            this.externalNames.add("http:/");
            this.externalParents.add(-1);
            InputStream composedStatementsInputStream = null;
            InputStream otherStatementsInputStream = null;
            InputStream valueInputStream = null;
            composedStatementsInputStream = composedStatementsStream.isInMemory() ? new ByteArrayInputStream(composedStatementsStream.getData()) : new FileInputStream(composedStatementsFile);
            otherStatementsInputStream = otherStatementsStream.isInMemory() ? new ByteArrayInputStream(otherStatementsStream.getData()) : new FileInputStream(otherStatementsFile);
            valueInputStream = valueStream.isInMemory() ? new ByteArrayInputStream(valueStream.getData()) : new FileInputStream(valueFile);
            composedStatementsStream = null;
            otherStatementsStream = null;
            valueStream = null;
            ObjectInputStream composedStatementsInput = new ObjectInputStream(composedStatementsInputStream);
            ObjectInputStream otherStatementsInput = new ObjectInputStream(otherStatementsInputStream);
            ObjectInputStream valueInput = new ObjectInputStream(valueInputStream);
            long fileTimeEnd = System.nanoTime();
            long statementTime = System.nanoTime();
            this.searchStatements(graph, composedStatementsInput, otherStatementsInput, valueInput, extents);
            long statementTimeEnd = System.nanoTime();
            long buildTime = System.nanoTime();
            int resourceCount = this.ids.size();
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (Pair<Resource, String> r : this.configuration.roots) {
                Resource type = graph.getPossibleType((Resource)r.first, this.l0.Entity);
                if (type == null) {
                    type = this.l0.Entity;
                }
                identities.add(new Identity(this.ids.get(r.first).intValue(), (IdentityDefinition)new Root((String)r.second, graph.getURI(type))));
            }
            int internalsPlusExternals = this.ids.size();
            int i = this.internalCount;
            while (i < internalsPlusExternals) {
                int parent = this.externalParents.get(i - this.internalCount);
                String name = this.externalNames.get(i - this.internalCount);
                identities.add(new Identity(i, (IdentityDefinition)new External(parent, name)));
                ++i;
            }
            Identity[] identityArray = identities.toArray(new Identity[identities.size()]);
            Value[] valueArray = new Value[this.values.size()];
            int index = 0;
            for (Map.Entry<Resource, Variant> entry : this.values.entrySet()) {
                int r = this.getId(graph, entry.getKey(), null);
                valueArray[index++] = new Value(r, entry.getValue());
            }
            this.ids = null;
            this.values = null;
            long buildTimeEnd = System.nanoTime();
            TransferableGraph1 result = new TransferableGraph1(resourceCount, identityArray, this.statements, valueArray);
            long totalEnd = System.nanoTime();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    class StatementSetBuilder {
        private int SLICE = 100000;
        private final CollectionSupport cs;
        private final LinkedList<Collection<Statement>> sets = new LinkedList();
        private Collection<Statement> current;

        StatementSetBuilder(CollectionSupport cs) {
            this.cs = cs;
            this.current = cs.createStatementList();
        }

        LinkedList<Collection<Statement>> get() {
            this.sets.add(this.current);
            return this.sets;
        }

        void add(Statement stm) {
            this.current.add(stm);
            if (this.current.size() == this.SLICE) {
                this.sets.add(this.current);
                this.current = this.cs.createStatementList();
            }
        }

        int size() {
            int result = 0;
            for (Collection collection : this.sets) {
                result += collection.size();
            }
            return result;
        }

        void addAll(Collection<Statement> ss) {
            for (Statement s : ss) {
                this.add(s);
            }
        }
    }
}

