/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class TGConfigurer {
    private final ReadGraph graph;
    final Collection<TransferableGraphConfiguration2.RootSpec> roots = new ArrayList<TransferableGraphConfiguration2.RootSpec>();
    final Map<Resource, SubgraphExtent.ExtentStatus> preStatus = new HashMap<Resource, SubgraphExtent.ExtentStatus>();
    final boolean ignoreVirtualResources;
    final boolean validate;

    public TGConfigurer(ReadGraph graph, boolean ignoreVirtualResources, boolean validate) {
        this.graph = graph;
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.validate = validate;
    }

    public TGConfigurer(ReadGraph graph, boolean ignoreVirtualResources) {
        this(graph, ignoreVirtualResources, true);
    }

    public TGConfigurer exclusions(Collection<Resource> exclusions) {
        for (Resource r : exclusions) {
            this.preStatus.put(r, SubgraphExtent.ExtentStatus.EXCLUDED);
        }
        return this;
    }

    public TGConfigurer roots(Collection<TransferableGraphConfiguration2.RootSpec> rs) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        for (TransferableGraphConfiguration2.RootSpec root : rs) {
            Resource nameResource = this.graph.getPossibleObject(root.resource, L0.HasName);
            if (nameResource != null) {
                this.preStatus.put(nameResource, SubgraphExtent.ExtentStatus.EXCLUDED);
            }
            this.roots.add(new TransferableGraphConfiguration2.RootSpec(root.resource, root.name, root.internal, root.type));
            this.preStatus.put(root.resource, SubgraphExtent.ExtentStatus.INTERNAL);
        }
        return this;
    }

    public TGConfigurer roots2(Collection<Resource> rs) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        for (Resource root : rs) {
            Resource nameResource = this.graph.getPossibleObject(root, L0.HasName);
            String name = "<no name>";
            if (nameResource != null) {
                name = (String)this.graph.getPossibleValue(nameResource, (Binding)Bindings.STRING);
                if (name == null) {
                    name = "<no name>";
                }
                this.preStatus.put(nameResource, SubgraphExtent.ExtentStatus.EXCLUDED);
            }
            this.roots.add(new TransferableGraphConfiguration2.RootSpec(root, name, true));
            this.preStatus.put(root, SubgraphExtent.ExtentStatus.INTERNAL);
        }
        return this;
    }

    public TGConfigurer roots3(Collection<NamedResource> rs) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        for (NamedResource root : rs) {
            Resource nameResource = this.graph.getPossibleObject(root.getResource(), L0.HasName);
            this.roots.add(new TransferableGraphConfiguration2.RootSpec(root.getResource(), root.getName(), true));
            this.preStatus.put(root.getResource(), SubgraphExtent.ExtentStatus.INTERNAL);
            this.preStatus.put(nameResource, SubgraphExtent.ExtentStatus.EXCLUDED);
        }
        return this;
    }

    public TransferableGraphConfiguration2 create() throws DatabaseException {
        if (!this.roots.contains(this.graph.getRootLibrary())) {
            this.preStatus.put(this.graph.getRootLibrary(), SubgraphExtent.ExtentStatus.EXCLUDED);
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
        ArrayList<Resource> rootList = new ArrayList<Resource>();
        for (TransferableGraphConfiguration2.RootSpec root : this.roots) {
            if (root.internal) {
                rootList.add(root.resource);
                for (Resource owner : this.graph.getObjects(root.resource, L0.IsOwnedBy)) {
                    SubgraphExtent.ExtentStatus ownerStatus = this.preStatus.get(owner);
                    if (ownerStatus != null) continue;
                    this.preStatus.put(owner, SubgraphExtent.ExtentStatus.EXCLUDED);
                }
                continue;
            }
            this.preStatus.put(root.resource, SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        Resource owner = CommonDBUtils.getNearestOwner((ReadGraph)this.graph, rootList);
        if (owner != null) {
            Resource indexRoot = (Resource)this.graph.syncRequest((Read)new PossibleIndexRoot(owner));
            return new TransferableGraphConfiguration2(indexRoot, this.roots, this.preStatus, this.ignoreVirtualResources, this.validate);
        }
        return new TransferableGraphConfiguration2(null, this.roots, this.preStatus, this.ignoreVirtualResources, this.validate);
    }
}

