/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.ModelDependency;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;

public class ModelDependenciesBean {
    public static final String EXTENSION_KEY = ModelDependenciesBean.class.getSimpleName();
    public static final Binding BINDING = Bindings.getBindingUnchecked(ModelDependenciesBean.class);
    public ModelDependency[] dependencies;

    public ModelDependenciesBean() {
        this.dependencies = new ModelDependency[0];
    }

    public ModelDependenciesBean(ModelDependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public static List<Resource> collectDependencies(ReadGraph graph, Resource resource) throws DatabaseException {
        LinkedList<Resource> order = new LinkedList<Resource>();
        ModelDependenciesBean.collectDependencies(graph, resource, order, new HashSet<Resource>());
        return order;
    }

    private static void collectDependencies(ReadGraph graph, Resource resource, LinkedList<Resource> order, Set<Resource> visited) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource library : (Collection)graph.syncRequest((Read)new ObjectsWithType(resource, L0.IsLinkedTo, L0.SharedOntology))) {
            if (order.contains(library)) continue;
            if (visited.contains(library)) {
                throw new DatabaseException("Cyclic dependency detected.");
            }
            visited.add(library);
            ModelDependenciesBean.collectDependencies(graph, library, order, visited);
            order.addFirst(library);
        }
    }

    private static List<ModelDependency> collectModelDependencies(ReadGraph graph, Resource resource) throws DatabaseException {
        List<Resource> order = ModelDependenciesBean.collectDependencies(graph, resource);
        Collections.reverse(order);
        ArrayList<ModelDependency> modelDependencies = new ArrayList<ModelDependency>(order.size());
        for (Resource library : order) {
            String uri = graph.getPossibleURI(library);
            if (uri == null) continue;
            CopyHandler ch = (CopyHandler)graph.adapt(library, CopyHandler.class);
            SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
            ch.copyToClipboard(graph, clipboard);
            for (Set<SimanticsClipboard.Representation> object : clipboard.getContents()) {
                TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept(graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                if (tg == null) continue;
                modelDependencies.add(new ModelDependency(uri, tg));
            }
        }
        return modelDependencies;
    }

    public static ModelDependenciesBean create(ReadGraph graph, Resource resource) throws DatabaseException {
        List<ModelDependency> dependencies = ModelDependenciesBean.collectModelDependencies(graph, resource);
        return new ModelDependenciesBean(dependencies.toArray(new ModelDependency[dependencies.size()]));
    }

    public static ModelDependenciesBean fromMigrationState(MigrationState state) throws DatabaseException, AdaptException {
        Map extensions = (Map)state.getProperty("tgExtensions");
        Variant variant = (Variant)extensions.get(EXTENSION_KEY);
        return variant != null ? (ModelDependenciesBean)variant.getValue(BINDING) : null;
    }
}

