/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.function;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.simantics.browsing.ui.model.modifiers.NoModifierRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ElementContext;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.function.DrawingTemplateInfo;
import org.simantics.modeling.template2d.ui.function.FlagInfo;
import org.simantics.modeling.template2d.ui.function.FlagTableInfo;
import org.simantics.modeling.template2d.ui.function.TranslateFlag;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.profile.request.RuntimeProfileActiveEntryResources;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class All {
    @SCLValue(type="a -> b -> c")
    public static Object variableTransformation(Object _graph, Object input) throws DatabaseException {
        ReadGraph graph = (ReadGraph)_graph;
        Resource object = (Resource)ISelectionUtils.getSinglePossibleKey((Object)input, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (object == null) {
            return null;
        }
        Resource runtime = (Resource)ISelectionUtils.getSinglePossibleKey((Object)input, (IHintContext.Key)SelectionHints.KEY_VARIABLE_RESOURCE, Resource.class);
        if (runtime == null) {
            return null;
        }
        Variable inputVariable = (Variable)graph.syncRequest((Read)new UnaryRead<Resource, Variable>(runtime){

            public Variable perform(ReadGraph graph) throws DatabaseException {
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                String diagramVariable = (String)graph.getPossibleRelatedValue((Resource)this.parameter, dr.RuntimeDiagram_HasVariable);
                return Variables.getVariable((ReadGraph)graph, (String)diagramVariable);
            }
        });
        if (inputVariable == null) {
            return null;
        }
        Resource component = ModelingUtils.getPossibleElementCorrespondendence((ReadGraph)graph, (Resource)object);
        if (component == null) {
            return null;
        }
        return inputVariable.browsePossible(graph, component);
    }

    @SCLValue(type="a -> b -> c")
    public static Object resourceVariableTransformation(Object _graph, Object input) throws DatabaseException {
        ReadGraph graph = (ReadGraph)_graph;
        Resource object = (Resource)ISelectionUtils.getSinglePossibleKey((Object)input, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (object == null) {
            return null;
        }
        return Variables.getVariable((ReadGraph)graph, (Resource)object);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String variableReference(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        String path = (String)graph.getRelatedValue(converter, TEMPLATE2D.Profiles_VariableReference_path, (Binding)Bindings.STRING);
        if (path == null) {
            return null;
        }
        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
        PredefinedVariables vars = PredefinedVariables.getInstance();
        Variable property = vars.getVariable(graph, path, converter, selection);
        if (property != null) {
            return property.getValue(graph).toString();
        }
        return null;
    }

    public static Resource getTemplate(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
        Resource template;
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram != null && (template = graph.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate)) != null) {
            return template;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> ElementContext -> a")
    public static Object flagTransform(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource flag = context.element;
        Resource runtimeDiagram = context.runtime;
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram == null) {
            return org.simantics.diagram.function.All.flagTransform((ReadGraph)graph, (Resource)converter, (ElementContext)context);
        }
        Resource template = All.getTemplate(graph, runtimeDiagram);
        if (template == null) {
            return org.simantics.diagram.function.All.flagTransform((ReadGraph)graph, (Resource)converter, (ElementContext)context);
        }
        double gridSize = DiagramGraphUtil.getGridSize((ReadGraph)graph, (Resource)diagram, (Double)0.0);
        String tableName = (String)graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, (Binding)Bindings.STRING);
        Integer rowIndex = (Integer)graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableRowIndex, (Binding)Bindings.INTEGER);
        FlagInfo flagInfo = new FlagInfo();
        flagInfo.flag = flag;
        if (tableName != null && tableName.length() > 0) {
            flagInfo.flagTableName = tableName;
        }
        flagInfo.flagTableRowIndex = rowIndex;
        Map<String, FlagTableInfo> name2table = (Map<String, FlagTableInfo>)graph.syncRequest((Read)new DrawingTemplateInfo(template), (Listener)TransientCacheListener.instance());
        if (name2table == null) {
            name2table = Collections.emptyMap();
        }
        if (!name2table.containsKey(flagInfo.flagTableName)) {
            return org.simantics.diagram.function.All.flagTransform((ReadGraph)graph, (Resource)converter, (ElementContext)context);
        }
        double[] mat = (double[])graph.getRelatedValue(flag, DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
        TranslateFlag com = new TranslateFlag(flagInfo, name2table, mat, gridSize);
        boolean isIOTablesActive = false;
        for (Resource entry : (Collection)graph.syncRequest((Read)new RuntimeProfileActiveEntryResources(runtimeDiagram))) {
            if (!TEMPLATE2D.Profiles_DrawingFlagTables.equals(entry)) continue;
            isIOTablesActive = true;
            break;
        }
        if (isIOTablesActive) {
            return com.perform();
        }
        return org.simantics.diagram.function.All.flagTransform((ReadGraph)graph, (Resource)converter, (ElementContext)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object variableReferencePath(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Variable) {
            Variable document = ((Variable)context).browse(graph, ".");
            String path = (String)document.getPossiblePropertyValue(graph, "path", (Binding)Bindings.STRING);
            return path;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object variableReferenceModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return NoModifierRule.NO_MODIFIER;
    }
}

