/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.tests.conversion;

import java.io.File;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.tests.conversion.TransferableGraph0;

public class TG0_TG1 {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println(String.valueOf(TG0_TG1.class.getName()) + " formatName input.tg output.tg");
            return;
        }
        String formatName = args[0];
        File input = new File(args[1]);
        File output = new File(args[2]);
        if (!input.exists()) {
            System.err.println(input + " does not exist.");
            return;
        }
        if (output.exists()) {
            output.delete();
        }
        try {
            DataContainer header = DataContainers.readHeader((File)input);
            if (formatName.equals(header.format)) {
                System.err.println(input + " already has a data container with the required format, version is " + header.version);
                return;
            }
            System.err.println(input + " already has a data container with another format '" + header.format + ", version is " + header.version);
            return;
        }
        catch (Throwable throwable) {
            TransferableGraph0 tg0 = (TransferableGraph0)Files.readFile((File)input, (Binding)TransferableGraph0.BINDING);
            TransferableGraph1 tg1 = new TransferableGraph1(tg0.resourceCount, tg0.identities, tg0.statements, tg0.values, tg0.extensions);
            DataContainers.writeFile((File)output, (DataContainer)new DataContainer(formatName, 1, new Variant(TransferableGraph1.BINDING, (Object)tg1)));
            return;
        }
    }
}

