/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.SketchElement;
import org.simantics.sysdyn.modelImport.model.Cloud;
import org.simantics.sysdyn.modelImport.model.Comment;
import org.simantics.sysdyn.modelImport.model.Symbol;

public class SketchComment
extends SketchElement {
    private static final String SKETCH_COMMENT = "12,([+-]?\\d+),([+-]?\\d+),(([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),[+-]?\\d+,[+-]?\\d+,([+-]?\\d+),.*)";
    private static final int commentId = 1;
    private static final int commentIcon = 2;
    private static final int commentSuffix = 3;
    private String text;
    private CommentIcon icon;

    protected SketchComment(int id, Sketch sketch, CommentIcon icon) {
        super(id, sketch);
        this.icon = icon;
    }

    public static SketchComment getPossible(String line, Sketch sketch) throws Exception {
        CommentIcon icon;
        Matcher matcher = Pattern.compile(SKETCH_COMMENT).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        int id = Integer.parseInt(matcher.group(1));
        switch (Integer.parseInt(matcher.group(2))) {
            case 48: {
                icon = CommentIcon.CLOUD;
                break;
            }
            default: {
                icon = CommentIcon.OTHER;
            }
        }
        SketchComment element = new SketchComment(id, sketch, icon);
        element.parseSuffix(matcher.group(3));
        return element;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public CommentIcon getIcon() {
        return this.icon;
    }

    @Override
    public Symbol getSymbol() {
        if (this.isInputOutput()) {
            return new Comment(this.getDimensions(), "I/O objects are not supported");
        }
        switch (this.icon) {
            case CLOUD: {
                return new Cloud(this.getDimensions());
            }
            case OTHER: {
                return new Comment(this.getDimensions(), this.text);
            }
        }
        return null;
    }

    public static enum CommentIcon {
        CLOUD,
        OTHER;

    }
}

