/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.elementaryCycles;

import java.util.List;
import java.util.Vector;
import org.simantics.sysdyn.elementaryCycles.AdjacencyList;
import org.simantics.sysdyn.elementaryCycles.SCCResult;
import org.simantics.sysdyn.elementaryCycles.StrongConnectedComponents;

public class ElementaryCyclesSearch {
    private List cycles = null;
    private int[][] adjList = null;
    private Object[] graphNodes = null;
    private boolean[] blocked = null;
    private Vector[] B = null;
    private Vector stack = null;

    public ElementaryCyclesSearch(boolean[][] matrix, Object[] graphNodes) {
        this.graphNodes = graphNodes;
        this.adjList = AdjacencyList.getAdjacencyList(matrix);
    }

    public List getElementaryCycles() {
        SCCResult sccResult;
        this.cycles = new Vector();
        this.blocked = new boolean[this.adjList.length];
        this.B = new Vector[this.adjList.length];
        this.stack = new Vector();
        StrongConnectedComponents sccs = new StrongConnectedComponents(this.adjList);
        int s = 0;
        while ((sccResult = sccs.getAdjacencyList(s)) != null && sccResult.getAdjList() != null) {
            Vector[] scc = sccResult.getAdjList();
            s = sccResult.getLowestNodeId();
            int j = 0;
            while (j < scc.length) {
                if (scc[j] != null && scc[j].size() > 0) {
                    this.blocked[j] = false;
                    this.B[j] = new Vector();
                }
                ++j;
            }
            this.findCycles(s, s, scc);
            ++s;
        }
        return this.cycles;
    }

    private boolean findCycles(int v, int s, Vector[] adjList) {
        int w;
        boolean f = false;
        this.stack.add(new Integer(v));
        this.blocked[v] = true;
        int i = 0;
        while (i < adjList[v].size()) {
            w = (Integer)adjList[v].get(i);
            if (w == s) {
                Vector<Object> cycle = new Vector<Object>();
                int j = 0;
                while (j < this.stack.size()) {
                    int index = (Integer)this.stack.get(j);
                    cycle.add(this.graphNodes[index]);
                    ++j;
                }
                this.cycles.add(cycle);
                f = true;
            } else if (!this.blocked[w] && this.findCycles(w, s, adjList)) {
                f = true;
            }
            ++i;
        }
        if (f) {
            this.unblock(v);
        } else {
            i = 0;
            while (i < adjList[v].size()) {
                w = (Integer)adjList[v].get(i);
                if (!this.B[w].contains(new Integer(v))) {
                    this.B[w].add(new Integer(v));
                }
                ++i;
            }
        }
        this.stack.remove(new Integer(v));
        return f;
    }

    private void unblock(int node) {
        this.blocked[node] = false;
        Vector Bnode = this.B[node];
        while (Bnode.size() > 0) {
            Integer w = (Integer)Bnode.get(0);
            Bnode.remove(0);
            if (!this.blocked[w]) continue;
            this.unblock(w);
        }
    }
}

