/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn;

import java.io.StringReader;
import java.util.HashMap;
import org.simantics.sysdyn.unitParser.ParseException;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.UnitParser;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;

public class TestParser {
    public static void main(String[] args) {
        HashMap<String, String> units = new HashMap<String, String>();
        boolean allowEquivalents = true;
        TestParser.doScenario(TestParser.scenario1(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario2(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario3(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario4(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario5(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario6(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario7(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario8(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario9(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario10(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario11(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario12(units), units, allowEquivalents);
        TestParser.doScenario(TestParser.scenario13(units), units, allowEquivalents);
    }

    private static void doScenario(String expression, HashMap<String, String> units, boolean allowEquivalents) {
        System.out.println("-----------------------------------");
        System.out.println("Expression: " + expression);
        System.out.println("Units: ");
        for (String key : units.keySet()) {
            System.out.println("   " + key + " -> " + units.get(key));
        }
        StringReader sr = new StringReader(expression);
        UnitParser parser = new UnitParser(sr);
        try {
            UnitCheckingNode node = (UnitCheckingNode)parser.expr();
            try {
                UnitResult u = node.getUnits(units, Function.getAllBuiltInFunctions(), allowEquivalents);
                System.out.println("Result: " + u.getCleanFullUnit());
            }
            catch (UnitCheckingException e) {
                e.printStackTrace();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static String scenario1(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        units.put("c", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("a*b*c");
        return sb.toString();
    }

    private static String scenario2(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        units.put("c", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("a+b+c");
        return sb.toString();
    }

    private static String scenario3(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        units.put("c", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("a/b+b/c");
        return sb.toString();
    }

    private static String scenario4(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        units.put("c", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("if a == b then a+b else b + c + a");
        return sb.toString();
    }

    private static String scenario5(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "s");
        units.put("c", "m");
        units.put("d", "s");
        StringBuilder sb = new StringBuilder();
        sb.append("c/(b*a)");
        return sb.toString();
    }

    private static String scenario6(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "s");
        units.put("c", "m");
        units.put("d", "m/s");
        StringBuilder sb = new StringBuilder();
        sb.append("if a > c then c*a/b else a*d");
        return sb.toString();
    }

    private static String scenario7(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m/s");
        units.put("b.e", "s");
        units.put("c", "m");
        units.put("d", "s");
        StringBuilder sb = new StringBuilder();
        sb.append("a[1] + c[1] / b.e[1]");
        return sb.toString();
    }

    private static String scenario8(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "s");
        units.put("c", "s*m");
        StringBuilder sb = new StringBuilder();
        sb.append("c + {a[i] * b[i] for i in 1:3}");
        return sb.toString();
    }

    private static String scenario9(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("1+a+1+b");
        return sb.toString();
    }

    private static String scenario10(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("1*a*1*a");
        return sb.toString();
    }

    private static String scenario11(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        StringBuilder sb = new StringBuilder();
        sb.append("-a+b");
        return sb.toString();
    }

    private static String scenario12(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "s");
        units.put("c", "m/s");
        StringBuilder sb = new StringBuilder();
        sb.append("1/a/b + 1/c");
        return sb.toString();
    }

    private static String scenario13(HashMap<String, String> units) {
        units.clear();
        units.put("a", "m");
        units.put("b", "m");
        units.put("c", "m");
        units.put("d", "s");
        StringBuilder sb = new StringBuilder();
        sb.append("(a/b+b/c)/d");
        return sb.toString();
    }
}

