/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.layout;

public class LayoutAlgorithm {
    final double OPTIMAL_DISTANCE = 150.0;
    final double C = 0.1;
    final double K = 6.666666666666668E-4;
    final double G = 6.666666666666668E-4;
    final double Q = 2250.0;
    final double TOLERANCE = 0.001;
    final int MAX_ITERATIONS = 10000;
    final double MAX_MOVE2 = 40000.0;
    int size;
    double[] posX;
    double[] posY;
    double[] forceX;
    double[] forceY;
    int[][] neighbors;

    public LayoutAlgorithm(int[][] neighbors) {
        this.size = neighbors.length;
        this.neighbors = neighbors;
        this.posX = new double[this.size];
        this.posY = new double[this.size];
        this.forceX = new double[this.size];
        this.forceY = new double[this.size];
    }

    public double[] getPosX() {
        return this.posX;
    }

    public double[] getPosY() {
        return this.posY;
    }

    private void computeForces() {
        int i = 0;
        while (i < this.size) {
            double x = this.posX[i];
            double y = this.posY[i];
            double fx = -6.666666666666668E-4 * x;
            double fy = -6.666666666666668E-4 * y;
            int j = 0;
            while (j < this.size) {
                if (j != i) {
                    double dx = this.posX[j] - x;
                    double dy = this.posY[j] - y;
                    double l2 = dx * dx + dy * dy;
                    fx -= 2250.0 * dx / l2;
                    fy -= 2250.0 * dy / l2;
                }
                ++j;
            }
            int[] nArray = this.neighbors[i];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                j = nArray[n2];
                double dx = this.posX[j] - x;
                double dy = this.posY[j] - y;
                double l2 = dx * dx + dy * dy;
                double l = Math.sqrt(l2);
                fx += 6.666666666666668E-4 * l * dx;
                fy += 6.666666666666668E-4 * l * dy;
                ++n2;
            }
            this.forceX[i] = fx;
            this.forceY[i] = fy;
            ++i;
        }
    }

    private boolean converged() {
        int i = 0;
        while (i < this.size) {
            double fx = this.forceX[i];
            double fy = this.forceY[i];
            double f2 = fx * fx + fy * fy;
            if (f2 > 0.001) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void moveAll() {
        int i = 0;
        while (i < this.size) {
            double fx = this.forceX[i];
            double fy = this.forceY[i];
            double f2 = fx * fx + fy * fy;
            if (f2 > 40000.0) {
                double s = Math.sqrt(40000.0 / f2);
                fx *= s;
                fy *= s;
            }
            int n = i;
            this.posX[n] = this.posX[n] + fx;
            int n2 = i++;
            this.posY[n2] = this.posY[n2] + fy;
        }
        this.computeForces();
    }

    public void optimize() {
        this.computeForces();
        int iter = 0;
        while (iter < 10000) {
            if (this.converged()) break;
            this.moveAll();
            ++iter;
        }
    }
}

