/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.simantics.db.MonitorContext;
import org.simantics.db.MonitorHandler;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.SessionMonitorSupport;

public class GraphRequestStatusTrim
extends Composite {
    final String requestStatusMessage = "{0}R / {1}W";
    final String requestToolTip = "Session: {0}\nPending: {1} read requests, {2} write requests";
    private boolean armed;
    private final Color bgCol;
    private final Color lowMemCol;
    private final Color freeMemCol;
    private Color topLeftCol;
    private final Color bottomRightCol;
    private final Color sepCol;
    private final Color textCol;
    private final IPreferenceStore prefStore;
    private final int updateInterval = 200;
    private boolean hasChanged;
    private Rectangle imgBounds = new Rectangle(0, 0, 12, 12);
    private SessionMonitorSupport session;
    private MonitorContext monitorContext;
    private long lastRedrawTime = 0L;
    private final Status status = new Status();
    private final MonitorHandler monitorHandler = new MonitorHandler(){

        public void valuesChanged(MonitorContext c) {
            long time = System.currentTimeMillis();
            if (time - 100L > GraphRequestStatusTrim.this.lastRedrawTime) {
                GraphRequestStatusTrim.this.lastRedrawTime = time;
                if (!GraphRequestStatusTrim.this.isDisposed()) {
                    GraphRequestStatusTrim.this.getDisplay().asyncExec(GraphRequestStatusTrim.this.timer);
                }
            }
        }
    };
    private final Runnable timer = new Runnable(){

        @Override
        public void run() {
            if (!GraphRequestStatusTrim.this.isDisposed()) {
                GraphRequestStatusTrim.this.updateStats();
                if (GraphRequestStatusTrim.this.hasChanged) {
                    GraphRequestStatusTrim.this.updateToolTip();
                    GraphRequestStatusTrim.this.redraw();
                    GraphRequestStatusTrim.this.hasChanged = false;
                }
                GraphRequestStatusTrim.this.getDisplay().timerExec(200, (Runnable)this);
            }
        }
    };
    private final IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
        }
    };

    public void attachToSession(Session session) {
        if (session != this.session) {
            if (this.monitorContext != null) {
                this.session.unregisterMonitor(this.monitorContext);
                this.monitorContext = null;
                this.session = null;
                this.status.clear();
            }
            SessionMonitorSupport support = null;
            if (session != null) {
                support = (SessionMonitorSupport)session.peekService(SessionMonitorSupport.class);
            }
            if (support == null) {
                this.hasChanged = true;
                return;
            }
            this.session = support;
            this.monitorContext = this.session.registerMonitor(this.monitorHandler);
            LifecycleSupport lifecycleSupport = (LifecycleSupport)session.getService(LifecycleSupport.class);
            this.status.sessionRef = lifecycleSupport.getSessionReference();
            this.getDisplay().asyncExec(this.timer);
        }
    }

    public GraphRequestStatusTrim(Composite parent, IPreferenceStore prefStore) {
        super(parent, 0);
        this.prefStore = prefStore;
        prefStore.addPropertyChangeListener(this.prefListener);
        Display display = this.getDisplay();
        this.lowMemCol = new Color((Device)display, 255, 70, 70);
        this.freeMemCol = new Color((Device)display, 255, 190, 125);
        this.bgCol = display.getSystemColor(22);
        this.sepCol = this.topLeftCol = display.getSystemColor(18);
        this.bottomRightCol = display.getSystemColor(20);
        this.textCol = display.getSystemColor(28);
        this.createContextMenu();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        GraphRequestStatusTrim.this.doDispose();
                        break;
                    }
                    case 9: {
                        if (event.widget != GraphRequestStatusTrim.this) break;
                        GraphRequestStatusTrim.this.paintComposite(event.gc);
                        break;
                    }
                    case 4: {
                        if (event.button != 1) break;
                        GraphRequestStatusTrim.this.arm(false);
                        break;
                    }
                    case 3: {
                        if (event.button != 1) break;
                        Widget cfr_ignored_0 = event.widget;
                        break;
                    }
                    case 7: {
                        GraphRequestStatusTrim.this.arm(false);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(3, listener);
        this.addListener(9, listener);
        this.addListener(11, listener);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GraphRequestStatusTrim.this.isDisposed()) {
                    GraphRequestStatusTrim.this.getDisplay().timerExec(200, GraphRequestStatusTrim.this.timer);
                }
            }
        });
    }

    private void doDispose() {
        this.prefStore.removePropertyChangeListener(this.prefListener);
        if (this.lowMemCol != null) {
            this.lowMemCol.dispose();
        }
        if (this.freeMemCol != null) {
            this.freeMemCol.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this);
        Point p = gc.textExtent("MMMMMMM");
        int height = this.imgBounds.height;
        height = Math.max(height, p.y) + 4;
        height = Math.max(TrimUtil.TRIM_DEFAULT_HEIGHT, height);
        gc.dispose();
        return new Point(p.x + 2, height);
    }

    private void arm(boolean armed) {
        if (this.armed == armed) {
            return;
        }
        this.armed = armed;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                GraphRequestStatusTrim.this.fillMenu(menuMgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this);
        this.setMenu(menu);
    }

    private void fillMenu(IMenuManager menuMgr) {
        menuMgr.add((IAction)new CloseAction());
    }

    private void paintComposite(GC gc) {
        Rectangle rect = this.getClientArea();
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        int bw = 0;
        int dx = x + w - bw - 2;
        gc.setBackground(this.bgCol);
        gc.fillRectangle(rect);
        gc.setForeground(this.sepCol);
        gc.drawLine(dx, y, dx, y + h);
        gc.setForeground(this.topLeftCol);
        gc.drawLine(x, y, x + w, y);
        gc.drawLine(x, y, x, y + h);
        gc.setForeground(this.bottomRightCol);
        gc.drawLine(x + w - 1, y, x + w - 1, y + h);
        gc.drawLine(x, y + h - 1, x + w, y + h - 1);
        String reads = String.valueOf(this.status.reads);
        String writes = String.valueOf(this.status.writes);
        String s = NLS.bind((String)"{0}R / {1}W", (Object[])new String[]{reads, writes});
        Point p = gc.textExtent(s);
        int sx = (rect.width - 2 - p.x) / 2 + rect.x + 1;
        int sy = (rect.height - 2 - p.y) / 2 + rect.y + 1;
        gc.setForeground(this.textCol);
        gc.setAlpha(192);
        gc.drawString(s, sx, sy, true);
    }

    private void updateStats() {
        if (this.monitorContext == null) {
            return;
        }
        int reads = this.monitorContext.getInteger("reads");
        int writes = this.monitorContext.getInteger("writes");
        if (reads != this.status.reads) {
            this.status.reads = reads;
            this.hasChanged = true;
        }
        if (writes != this.status.writes) {
            this.status.writes = writes;
            this.hasChanged = true;
        }
    }

    private void updateToolTip() {
        String server = "";
        if (this.status.sessionRef != null) {
            server = this.status.sessionRef.getServerReference().toString();
        }
        String reads = String.valueOf(this.status.reads);
        String writes = String.valueOf(this.status.writes);
        String toolTip = NLS.bind((String)"Session: {0}\nPending: {1} read requests, {2} write requests", (Object[])new String[]{server, reads, writes});
        if (!toolTip.equals(this.getToolTipText())) {
            this.setToolTipText(toolTip);
        }
    }

    class CloseAction
    extends Action {
        CloseAction() {
            super(WorkbenchMessages.WorkbenchWindow_close);
        }

        public void run() {
            GraphRequestStatusTrim.this.dispose();
        }
    }

    class ShowSessionsAction
    extends Action {
        ShowSessionsAction() {
            super("Show Local Sessions");
        }

        public void run() {
        }
    }

    class Status {
        SessionReference sessionRef;
        int reads;
        int writes;

        Status() {
        }

        void clear() {
            this.sessionRef = null;
            this.reads = 0;
            this.writes = 0;
        }
    }
}

