/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.Collection;
import java.util.HashSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.VersionInfo;
import org.simantics.db.common.utils.VersionInfoRequest;
import org.simantics.db.common.utils.VersionMap;
import org.simantics.db.common.utils.VersionMapRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class Versions {
    public static String make(String baseName, String version) {
        return String.valueOf(baseName) + "@" + version;
    }

    public static String getBaseVersion(String version) {
        try {
            Integer.parseInt(version);
            return "1";
        }
        catch (NumberFormatException numberFormatException) {
            return "A";
        }
    }

    public static String getBaseName(String name) {
        int pos = name.lastIndexOf(64);
        if (pos == -1) {
            return name;
        }
        return name.substring(0, pos);
    }

    public static String getVersion(String name) {
        if (name == null) {
            return null;
        }
        if (!name.contains("@")) {
            return null;
        }
        int pos = name.lastIndexOf(64);
        return name.substring(pos + 1);
    }

    public static String getBaseName(ReadGraph graph, Resource artifact) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(artifact, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            return "";
        }
        if (!name.contains("@")) {
            return name;
        }
        int pos = name.lastIndexOf(64);
        return name.substring(0, pos);
    }

    public static String getVersion(ReadGraph graph, Resource artifact) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(artifact, L0.HasName, (Binding)Bindings.STRING);
        return Versions.getVersion(name);
    }

    public static Collection<NamedResource> getOlderVersions(ReadGraph graph, Resource artifact) throws DatabaseException {
        HashSet<NamedResource> result = new HashSet<NamedResource>();
        VersionInfo info = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(artifact));
        result.addAll(info.getOlderVersions());
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(artifact));
        if (indexRoot == null || indexRoot.equals(artifact)) {
            return result;
        }
        VersionInfo versions = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(indexRoot));
        for (NamedResource ontology : versions.getOlderVersions()) {
            VersionMap map = Versions.match(graph, artifact, ontology.getResource());
            result.addAll(map.getOlderOrEqualVersions(graph, artifact));
        }
        return result;
    }

    public static Collection<NamedResource> getNewerVersions(ReadGraph graph, Resource artifact) throws DatabaseException {
        HashSet<NamedResource> result = new HashSet<NamedResource>();
        VersionInfo info = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(artifact));
        result.addAll(info.getNewerVersions());
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(artifact));
        if (indexRoot == null || indexRoot.equals(artifact)) {
            return result;
        }
        VersionInfo versions = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(indexRoot));
        for (NamedResource ontology : versions.getNewerVersions()) {
            VersionMap map = Versions.match(graph, artifact, ontology.getResource());
            result.addAll(map.getNewerOrEqualVersions(graph, artifact));
        }
        return result;
    }

    public static VersionMap match(ReadGraph graph, Resource type, Resource newOntology) throws DatabaseException {
        Resource originalOntology = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(type));
        String originalURI = graph.getURI(originalOntology);
        String newOntologyURI = graph.getURI(newOntology);
        String typeURI = graph.getURI(type);
        String typeURIInNewOntology = String.valueOf(newOntologyURI) + typeURI.substring(originalURI.length());
        String[] parts = URIStringUtils.splitURI((String)typeURIInNewOntology);
        Resource newLibrary = graph.getPossibleResource(parts[0]);
        if (newLibrary == null) {
            return null;
        }
        return (VersionMap)((Object)graph.syncRequest((Read)new VersionMapRequest(newLibrary)));
    }

    public static String getStandardNameString(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
        if (name != null) {
            VersionInfo versions = (VersionInfo)graph.syncRequest((Read)new VersionInfoRequest(r));
            if (versions.versions.size() != 1) {
                int pos = name.lastIndexOf(64);
                if (pos == -1) {
                    return String.valueOf(name) + " [No version]";
                }
                String base = name.substring(0, pos);
                String version = name.substring(pos + 1);
                return String.valueOf(base) + " [Version " + version + "]";
            }
            return versions.baseName;
        }
        return NameUtils.getSafeName(graph, r);
    }

    public static String getStandardPathNameString(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String standardName = Versions.getStandardNameString(graph, r);
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
        if (indexRoot.equals(r)) {
            return standardName;
        }
        Resource indexRootParent = graph.getPossibleObject(indexRoot, L0.PartOf);
        String indexRootName = Versions.getStandardNameString(graph, indexRoot);
        String indexRootParentURI = graph.getPossibleURI(indexRootParent);
        Resource parent = graph.getPossibleObject(r, L0.PartOf);
        String parentURI = graph.getURI(parent);
        String indexRootURI = graph.getPossibleURI(indexRoot);
        String path = parent.equals(indexRoot) ? "" : String.valueOf(parentURI.substring(indexRootURI.length() + 1)) + "/";
        return String.valueOf(path) + standardName + "  in  " + indexRootParentURI + indexRootName;
    }
}

