/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead3;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;

public final class SingleObjectWithType
extends ResourceRead3<Resource> {
    public SingleObjectWithType(Resource resource, Resource predicate, Resource type) {
        super(resource, predicate, type);
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        Resource result = null;
        for (Resource object : graph.getObjects(this.resource, this.resource2)) {
            if (!graph.isInstanceOf(object, this.resource3)) continue;
            if (result != null) {
                throw new NoSingleResultException("More than 1 objects for relation " + NameUtils.getSafeName(graph, this.resource2) + " with type " + NameUtils.getSafeName(graph, this.resource3) + " at " + NameUtils.getSafeName(graph, this.resource));
            }
            result = object;
        }
        if (result == null) {
            throw new NoSingleResultException("No objects for relation " + NameUtils.getSafeName(graph, this.resource2) + " with type " + NameUtils.getSafeName(graph, this.resource3) + " at " + NameUtils.getSafeName(graph, this.resource));
        }
        return result;
    }
}

