/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class CompositeHintSynchronizer
implements IHintSynchronizer {
    private final List<IHintSynchronizer> synchronizers = new ArrayList<IHintSynchronizer>();

    public CompositeHintSynchronizer() {
    }

    public CompositeHintSynchronizer(IHintSynchronizer ... synchronizers) {
        IHintSynchronizer[] iHintSynchronizerArray = synchronizers;
        int n = synchronizers.length;
        int n2 = 0;
        while (n2 < n) {
            IHintSynchronizer s = iHintSynchronizerArray[n2];
            this.synchronizers.add(s);
            ++n2;
        }
    }

    public CompositeHintSynchronizer(Collection<IHintSynchronizer> synchronizers) {
        this.synchronizers.addAll(synchronizers);
    }

    public CompositeHintSynchronizer add(IHintSynchronizer s) {
        this.synchronizers.add(s);
        return this;
    }

    @Override
    public int synchronize(ISynchronizationContext context, IHintObservable observable) {
        int count = 0;
        for (IHintSynchronizer synchronizer : this.synchronizers) {
            count += synchronizer.synchronize(context, observable);
        }
        return count;
    }

    @Override
    public boolean hintChanged(ISynchronizationContext context, IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        for (IHintSynchronizer s : this.synchronizers) {
            if (!s.hintChanged(context, sender, key, oldValue, newValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hintRemoved(ISynchronizationContext context, IHintObservable sender, IHintContext.Key key, Object oldValue) {
        for (IHintSynchronizer s : this.synchronizers) {
            if (!s.hintRemoved(context, sender, key, oldValue)) continue;
            return true;
        }
        return false;
    }
}

