/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.symbolcontribution.AdaptableTriple;
import org.simantics.diagram.symbolcontribution.IIdentifiedObject;
import org.simantics.diagram.symbolcontribution.SymbolItem;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ElementSymbolItem
extends SymbolItem {
    public ElementSymbolItem(Resource item, String name, ISymbolGroup group) {
        super(AdaptableTriple.make(item, group instanceof IIdentifiedObject ? ((IIdentifiedObject)((Object)group)).getId() : group, name), name, group);
    }

    public ElementSymbolItem(Resource item, String name, String description, ISymbolGroup group) {
        super(AdaptableTriple.make(item, group instanceof IIdentifiedObject ? ((IIdentifiedObject)((Object)group)).getId() : group, name), name, description, group);
    }

    @Override
    public ElementClass getElementClass(IHintObservable hints) {
        Resource item = this.adapt(Resource.class);
        Session sgrp = SimanticsUI.peekSession();
        if (sgrp == null) {
            throw new ProvisionException("No RequestProcessor available for querying an ElementClass for resource " + item);
        }
        try {
            ElementClass ec;
            Listener listener = (Listener)hints.getHint(ISymbolItem.KEY_ELEMENT_CLASS_LISTENER);
            ElementClass elementClass = ec = listener == null ? (ElementClass)sgrp.syncRequest(this.createRequest(item, hints)) : (ElementClass)sgrp.syncRequest(this.createRequest(item, hints), listener);
            if (ec == null) {
                throw new ProvisionException("ElementClass query failed, returned null");
            }
            if (!ec.containsClass(StaticSymbol.class)) {
                throw new ProvisionException("ElementClass " + ec + " does not provide a StaticSymbol handler");
            }
            return ec;
        }
        catch (DatabaseException e) {
            throw new ProvisionException((Throwable)e);
        }
    }

    private Read<ElementClass> createRequest(Resource item, final IHintObservable hints) {
        return new ResourceRead<ElementClass>(item){

            public ElementClass perform(ReadGraph graph) throws DatabaseException {
                BasicResources.getInstance(graph);
                return (ElementClass)graph.syncRequest(DiagramRequests.getElementClass(this.resource, hints));
            }
        };
    }
}

