/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.IsActive;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramModelActivityTracker
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_IN_ACTIVE_MODEL = new IHintContext.KeyOf(String.class, "IN_ACTIVE_MODEL");
    public static final IHintContext.Key KEY_ACTIVE_BACKGROUND = new IHintContext.KeyOf(Color.class, "ACTIVE_BACKGROUND");
    public static final IHintContext.Key KEY_INACTIVE_BACKGROUND = new IHintContext.KeyOf(Color.class, "INACTIVE_BACKGROUND");
    private static final Color DEFAULT_ACTIVE_BACKGROUND = Color.WHITE;
    private static final Color DEFAULT_INACTIVE_BACKGROUND = new Color(242, 242, 242);
    Resource input;
    IsInActiveModelListener listener;
    TextNode bannerNode;

    public DiagramModelActivityTracker(Resource input) {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        this.input = input;
    }

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CONTROL_BOUNDS")
    public void controlBoundsChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (this.bannerNode == null) {
            return;
        }
        if (newValue != null) {
            Rectangle2D cfr_ignored_0 = (Rectangle2D)newValue;
            AffineTransform at = new AffineTransform();
            at.translate(5.0, 5.0);
            this.bannerNode.setTransform(at);
        } else {
            this.bannerNode.setColor(null);
        }
    }

    @HintReflection.HintListener(Class=DiagramModelActivityTracker.class, Field="KEY_IN_ACTIVE_MODEL")
    public void containingModelActivityChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object _newValue) {
        String newValue = (String)_newValue;
        if (this.bannerNode == null) {
            return;
        }
        if (newValue == null) {
            this.bannerNode.setText("");
        } else {
            this.bannerNode.setText(newValue);
        }
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.listener = new IsInActiveModelListener(ctx);
        Simantics.getSession().async((ReadInterface)new IsActiveDiagram(this.input), (Listener)this.listener);
        if (!ctx.getHintStack().containsHint(KEY_ACTIVE_BACKGROUND)) {
            ctx.getDefaultHintContext().setHint(KEY_ACTIVE_BACKGROUND, (Object)DEFAULT_ACTIVE_BACKGROUND);
        }
        if (!ctx.getHintStack().containsHint(KEY_INACTIVE_BACKGROUND)) {
            ctx.getDefaultHintContext().setHint(KEY_INACTIVE_BACKGROUND, (Object)DEFAULT_INACTIVE_BACKGROUND);
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        super.removedFromContext(ctx);
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CONTROL)
    public void initSG(G2DParentNode parent) {
        this.bannerNode = (TextNode)((Object)parent.addNode("inactivity-banner", TextNode.class));
        this.bannerNode.setZIndex(-536870912);
        this.bannerNode.setHorizontalAlignment((byte)Alignment.LEADING.ordinal());
        this.bannerNode.setVerticalAlignment((byte)Alignment.LEADING.ordinal());
        this.bannerNode.setText("");
        this.bannerNode.setFont(Font.decode("Arial 16"));
        this.bannerNode.setPadding(10.0, 10.0);
        this.bannerNode.setBorderColor(Color.GRAY);
        this.bannerNode.setBorderWidth(0.0f);
        this.bannerNode.setEditable(false);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.bannerNode != null) {
            this.bannerNode.remove();
            this.bannerNode = null;
        }
    }

    static class IsActiveDiagram
    extends UnaryRead<Resource, String> {
        public IsActiveDiagram(Resource parameter) {
            super((Object)parameter);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            boolean published;
            Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.parameter));
            if (indexRoot == null) {
                return "This diagram is not part of any model or shared library";
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource composite = graph.getPossibleObject((Resource)this.parameter, MOD.DiagramToComposite);
            if (composite == null) {
                return "This diagram does not have a corresponding configuration";
            }
            Resource componentType = graph.getPossibleObject(composite, STR.Defines);
            if (componentType != null && (published = Layer0Utils.isPublished((ReadGraph)graph, (Resource)componentType))) {
                return "This diagram defines a published (read-only) user component";
            }
            if (graph.isInstanceOf(indexRoot, L0.SharedOntology)) {
                return "";
            }
            boolean activeModel = (Boolean)graph.syncRequest((Read)new IsActive(indexRoot));
            if (!activeModel) {
                return "The model of this diagram is not active";
            }
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Instances query = (Instances)graph.adapt(DIA.DiagramActivityCondition, Instances.class);
            for (Resource condition : query.find(graph, indexRoot)) {
                String value = (String)Simantics.tryInvokeSCL((ReadGraph)graph, (Resource)condition, (Resource)DIA.DiagramActivityCondition_test, (Object)((Resource)this.parameter));
                if (value == null || value.isEmpty()) continue;
                return value;
            }
            return "";
        }
    }

    static class IsInActiveModelListener
    implements Listener<String> {
        ICanvasContext context;

        public IsInActiveModelListener(ICanvasContext context) {
            this.context = context;
        }

        public void execute(final String result) {
            final Color color = result.isEmpty() ? (Color)this.context.getHintStack().getHint(KEY_ACTIVE_BACKGROUND) : (Color)this.context.getHintStack().getHint(KEY_INACTIVE_BACKGROUND);
            this.context.getThreadAccess().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ICanvasContext ctx = context;
                    if (ctx == null) {
                        return;
                    }
                    if (ctx.isDisposed()) {
                        return;
                    }
                    IHintContext hints = ctx.getDefaultHintContext();
                    if (color != null) {
                        hints.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)color);
                    }
                    hints.setHint(KEY_IN_ACTIVE_MODEL, (Object)result);
                }
            });
        }

        public void dispose() {
            this.context = null;
        }

        public boolean isDisposed() {
            ICanvasContext context = this.context;
            return context == null || context.isDisposed();
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }
    }
}

