/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.flag.IOTableUtil;
import org.simantics.diagram.flag.IOTablesInfo;
import org.simantics.diagram.handler.CopyPasteUtil;
import org.simantics.diagram.handler.PasteOperation;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.StatementEvaluation;
import org.simantics.diagram.synchronization.SynchronizationException;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.AddConnection;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.utils.datastructures.map.Tuple;

public class Paster {
    private final boolean DEBUG;
    private final Session session;
    private final PasteOperation op;
    private final Resource sourceDiagram;
    private final Resource targetDiagram;
    private final IModifiableSynchronizationContext targetContext;
    private WriteGraph graph;
    private ConnectionUtil cu;
    private Layer0 L0;
    private Layer0X L0X;
    private DiagramResource DIA;
    private ModelingResources MOD;
    private StructuralResource2 STR;
    private AffineTransform offsetTransform;
    private NodeMap nodeMap;
    private Resource sourceRoot;
    private Resource targetRoot;
    private String sourceRootUri;
    private String targetRootUri;
    private boolean operateWithinSameRoot;
    BiFunction<ReadGraph, Statement, StatementEvaluation> statementAdvisor = new BiFunction<ReadGraph, Statement, StatementEvaluation>(){

        @Override
        public StatementEvaluation apply(ReadGraph graph, Statement stm) {
            if (((Paster)Paster.this).DIA.HasFlagType.equals(stm.getPredicate())) {
                return StatementEvaluation.INCLUDE;
            }
            return StatementEvaluation.USE_DEFAULT;
        }
    };
    CopyProcedure nodeCopyProcedure = new CopyProcedure(this){

        @Override
        Resource copy(Resource source) throws Exception {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource copy = null;
            CopyAdvisor advisor = (CopyAdvisor)((Paster)this).op.target.getHint(SynchronizationHints.COPY_ADVISOR);
            if (advisor != null) {
                Resource sourceComposite = graph.getPossibleObject(source, L0.PartOf);
                if (sourceComposite == null || !graph.isInstanceOf(source, ((Paster)this).DIA.Composite)) {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    sourceComposite = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)source, (Resource)DIA.Composite);
                }
                copy = CopyAdvisorUtil.copy(targetContext, graph, advisor, source, sourceComposite, ((Paster)this).op.targetDiagram);
            }
            if (copy == null) {
                copy = CopyAdvisorUtil.copy2(graph, source, statementAdvisor);
            }
            graph.deny(copy, ((Paster)this).MOD.IsTemplatized, copy);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Copied element " + source + " to " + copy));
            OrderedSetUtils.add((WriteGraph)graph, (Resource)((Paster)this).op.targetDiagram, (Resource)copy);
            AddElement.claimFreshElementName(graph, ((Paster)this).op.targetDiagram, copy);
            graph.claim(((Paster)this).op.targetDiagram, L0.ConsistsOf, copy);
            GraphLayerManager glm = (GraphLayerManager)targetContext.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
            if (glm != null) {
                glm.removeFromAllLayers(graph, copy);
                glm.putElementOnVisibleLayers(((Paster)this).op.target, graph, copy);
            }
            return copy;
        }

        @Override
        void postCopy(Resource source, Resource copy) throws Exception {
            CopyPasteUtil.copyElementPosition(graph, ((Paster)this).op.ctx, source, copy, ((Paster)this).op.offset);
        }
    };

    public Paster(Session session, PasteOperation op) throws DatabaseException {
        this.DEBUG = true;
        this.session = session;
        this.op = op;
        this.sourceDiagram = op.sourceDiagram;
        this.targetDiagram = op.targetDiagram;
        if (this.sourceDiagram == null) {
            throw new IllegalArgumentException("source diagram has no resource");
        }
        if (this.targetDiagram == null) {
            throw new IllegalArgumentException("target diagram has no resource");
        }
        this.targetContext = (IModifiableSynchronizationContext)op.target.getHint(SynchronizationHints.CONTEXT);
        if (this.targetContext == null) {
            throw new IllegalArgumentException("target diagram has no synchronization context");
        }
        this.offsetTransform = AffineTransform.getTranslateInstance(op.offset.getX(), op.offset.getY());
    }

    private String toString(PasteOperation op) {
        StringBuilder sb = new StringBuilder();
        sb.append("Diagram paste ");
        sb.append(op.ea.all.size());
        sb.append(" element(s) ");
        if (op.cut) {
            sb.append("cut");
        } else {
            sb.append("copied");
        }
        sb.append(" from ");
        sb.append(op.sourceDiagram);
        sb.append(" to ");
        sb.append(op.targetDiagram);
        return sb.toString();
    }

    public void perform() throws DatabaseException {
        final String comment = this.toString(this.op);
        WriteRequest request = new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Paster.this.perform(graph);
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add(comment));
            }
        };
        this.session.syncRequest((Write)request);
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.L0X = Layer0X.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
        this.graph = graph;
        this.cu = new ConnectionUtil(graph);
        this.sourceRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(this.sourceDiagram));
        this.targetRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(this.targetDiagram));
        this.sourceRootUri = graph.getURI(this.sourceRoot);
        this.targetRootUri = graph.getURI(this.targetRoot);
        this.operateWithinSameRoot = this.sourceRoot.equals(this.targetRoot);
        try {
            try {
                if (this.op.cut) {
                    this.cut();
                } else {
                    this.copy();
                }
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        finally {
            this.cu = null;
            this.graph = null;
        }
    }

    private void onFinish() {
        CopyAdvisor advisor = (CopyAdvisor)this.op.target.getHint(SynchronizationHints.COPY_ADVISOR);
        if (advisor != null) {
            try {
                try {
                    this.targetContext.set(GraphSynchronizationHints.READ_TRANSACTION, this.graph);
                    this.targetContext.set(GraphSynchronizationHints.WRITE_TRANSACTION, this.graph);
                    advisor.onFinish(this.targetContext);
                }
                catch (SynchronizationException e) {
                    ErrorHandler eh = (ErrorHandler)this.targetContext.get(SynchronizationHints.ERROR_HANDLER);
                    eh.error(e.getMessage(), e);
                    this.targetContext.set(GraphSynchronizationHints.READ_TRANSACTION, null);
                    this.targetContext.set(GraphSynchronizationHints.WRITE_TRANSACTION, null);
                }
            }
            finally {
                this.targetContext.set(GraphSynchronizationHints.READ_TRANSACTION, null);
                this.targetContext.set(GraphSynchronizationHints.WRITE_TRANSACTION, null);
            }
        }
    }

    public void forEachResourceElement(String description, Collection<?> elements, Procedure procedure) throws Exception {
        for (Object object : elements) {
            if (object instanceof Resource) {
                procedure.execute((Resource)object);
                continue;
            }
            if (!this.DEBUG) continue;
            System.out.println("[" + description + "] Skipping non-resource element: " + object);
        }
    }

    private void applyPasteOffset(Resource forResource) throws DatabaseException {
        this.applyOffset(forResource, this.op.offset);
    }

    private void applyOffset(Resource forResource, Point2D offset) throws DatabaseException {
        AffineTransform at = DiagramGraphUtil.getTransform((ReadGraph)this.graph, forResource);
        at.preConcatenate(AffineTransform.getTranslateInstance(offset.getX(), offset.getY()));
        DiagramGraphUtil.setTransform(this.graph, forResource, at);
    }

    private void applyPasteOffsetToRouteLine(Resource routeLine) throws DatabaseException {
        Boolean isHorizontal = (Boolean)this.graph.getPossibleRelatedValue(routeLine, this.DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
        Double pos = (Double)this.graph.getPossibleRelatedValue(routeLine, this.DIA.HasPosition, (Binding)Bindings.DOUBLE);
        if (pos == null) {
            pos = 0.0;
        }
        pos = Boolean.TRUE.equals(isHorizontal) ? Double.valueOf(pos + this.op.offset.getY()) : Double.valueOf(pos + this.op.offset.getX());
        this.graph.claimLiteral(routeLine, this.DIA.HasPosition, (Object)pos, (Binding)Bindings.DOUBLE);
    }

    Resource parentElement(Resource resource, Resource referenceRelation) throws DatabaseException {
        Resource referencedParentComponent = this.graph.getPossibleObject(resource, referenceRelation);
        if (referencedParentComponent == null) {
            return null;
        }
        return this.graph.getPossibleObject(referencedParentComponent, this.MOD.ComponentToElement);
    }

    boolean parentIsIncludedInCut(Resource resource, Resource referenceRelation, boolean noParentElementReturnValue) throws DatabaseException {
        Resource referencedElement = this.parentElement(resource, referenceRelation);
        if (referencedElement != null) {
            return this.op.ea.all.contains(referencedElement);
        }
        return noParentElementReturnValue;
    }

    protected void cut() throws Exception {
        final GraphLayerManager glm = (GraphLayerManager)this.targetContext.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        final THashSet cutElements = new THashSet();
        CutProcedure registerNames = new CutProcedure(){

            @Override
            void postCut(Resource resource, Object cutResult) throws Exception {
                String name = (String)Paster.this.graph.getPossibleRelatedValue(resource, ((Paster)Paster.this).L0.HasName, (Binding)Bindings.STRING);
                if (name != null) {
                    cutElements.add((Object)resource);
                }
            }
        };
        final CutProcedure nodeCutProcedure = new CutProcedure(){

            @Override
            void postCut(Resource resource, Object cutResult) throws Exception {
                if (cutResult != null) {
                    Paster.this.applyPasteOffset(resource);
                    if (glm != null) {
                        glm.removeFromAllLayers(Paster.this.graph, resource);
                        glm.putElementOnVisibleLayers(((Paster)Paster.this).op.target, Paster.this.graph, resource);
                    }
                }
            }
        };
        CutProcedure flagCutProcedure = new CutProcedure(){
            Set<Resource> flagComposites = new HashSet<Resource>();
            Set<Resource> joinedComposites = new HashSet<Resource>();
            Set<Resource> invalidJoinedComposites = new HashSet<Resource>();

            @Override
            boolean preCut(Resource resource) throws Exception {
                return nodeCutProcedure.preCut(resource);
            }

            @Override
            void postCut(Resource resource, Object cutResult) throws Exception {
                nodeCutProcedure.postCut(resource, cutResult);
                if (FlagUtil.isJoinedInSingleDiagram((ReadGraph)Paster.this.graph, resource)) {
                    FlagLabelingScheme scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)Paster.this.graph);
                    String commonLabel = scheme.generateLabel((ReadGraph)Paster.this.graph, Paster.this.targetDiagram);
                    Paster.this.graph.claimLiteral(resource, ((Paster)Paster.this).L0.HasLabel, ((Paster)Paster.this).DIA.FlagLabel, (Object)commonLabel);
                    for (Resource otherFlag : FlagUtil.getCounterparts((ReadGraph)Paster.this.graph, resource)) {
                        Paster.this.graph.claimLiteral(otherFlag, ((Paster)Paster.this).L0.HasLabel, ((Paster)Paster.this).DIA.FlagLabel, (Object)commonLabel, (Binding)Bindings.STRING);
                    }
                }
                IOTablesInfo ioTablesInfo = IOTableUtil.getIOTablesInfo((ReadGraph)Paster.this.graph, ((Paster)Paster.this).op.targetDiagram);
                double[] transform = (double[])Paster.this.graph.getRelatedValue(resource, ((Paster)Paster.this).DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
                ioTablesInfo.updateBinding(Paster.this.graph, Paster.this.DIA, resource, transform[4], transform[5]);
                for (Resource join : Paster.this.graph.getObjects(resource, ((Paster)Paster.this).DIA.FlagIsJoinedBy)) {
                    this.fixConnectionJoin(join);
                }
            }

            void fixConnectionJoin(Resource join) throws DatabaseException {
                Collection flags = Paster.this.graph.getObjects(join, ((Paster)Paster.this).DIA.JoinsFlag);
                if (flags.size() < 2) {
                    Paster.this.graph.deny(join);
                } else {
                    this.flagComposites.clear();
                    this.possibleCompositesOfElements(flags, this.flagComposites);
                    this.joinedComposites.clear();
                    this.joinedComposites.addAll(Paster.this.graph.getObjects(join, ((Paster)Paster.this).STR.JoinsComposite));
                    this.invalidJoinedComposites.clear();
                    this.invalidJoinedComposites.addAll(this.joinedComposites);
                    this.invalidJoinedComposites.removeAll(this.flagComposites);
                    this.flagComposites.removeAll(this.joinedComposites);
                    if (!this.invalidJoinedComposites.isEmpty()) {
                        for (Resource invalidComposite : this.invalidJoinedComposites) {
                            Paster.this.graph.deny(join, ((Paster)Paster.this).STR.JoinsComposite, invalidComposite);
                        }
                    }
                    if (!this.flagComposites.isEmpty()) {
                        for (Resource joinedComposite : this.flagComposites) {
                            Paster.this.graph.claim(join, ((Paster)Paster.this).STR.JoinsComposite, joinedComposite);
                        }
                    }
                }
            }

            Set<Resource> possibleCompositesOfElements(Collection<Resource> elements, Set<Resource> result) throws DatabaseException {
                for (Resource e : elements) {
                    Resource composite = this.possibleCompositeOfElement(e);
                    if (composite == null) continue;
                    result.add(composite);
                }
                return result;
            }

            Resource possibleCompositeOfElement(Resource element) throws DatabaseException {
                Resource diagram = Paster.this.graph.getPossibleObject(element, ((Paster)Paster.this).L0.PartOf);
                return diagram != null ? Paster.this.graph.getPossibleObject(diagram, ((Paster)Paster.this).MOD.DiagramToComposite) : null;
            }
        };
        CutProcedure monitorCutProcedure = new CutProcedure(){

            @Override
            void postCut(Resource resource, Object cutResult) throws DatabaseException {
                if (cutResult != null) {
                    Resource parentElement = Paster.this.parentElement(resource, ((Paster)Paster.this).DIA.HasMonitorComponent);
                    if (parentElement == null) {
                        Paster.this.applyPasteOffset(resource);
                    } else if (!((Paster)Paster.this).op.ea.all.contains(parentElement)) {
                        Point2D offset = ((Paster)Paster.this).op.offset;
                        if (!Paster.this.op.sameDiagram()) {
                            Resource parentDiagram = (Resource)Paster.this.graph.sync((ReadInterface)new PossibleTypedParent(parentElement, ((Paster)Paster.this).DIA.Diagram));
                            AffineTransform monitoredComponentTr = DiagramGraphUtil.getWorldTransform((ReadGraph)Paster.this.graph, parentElement);
                            offset = ((Paster)Paster.this).op.targetDiagram.equals(parentDiagram) ? new Point2D.Double(((Paster)Paster.this).op.offset.getX() - monitoredComponentTr.getTranslateX(), ((Paster)Paster.this).op.offset.getY() - monitoredComponentTr.getTranslateY()) : new Point2D.Double(((Paster)Paster.this).op.offset.getX() + monitoredComponentTr.getTranslateX(), ((Paster)Paster.this).op.offset.getY() + monitoredComponentTr.getTranslateY());
                        }
                        Paster.this.applyOffset(resource, offset);
                    }
                    if (glm != null) {
                        glm.removeFromAllLayers(Paster.this.graph, resource);
                        glm.putElementOnVisibleLayers(((Paster)Paster.this).op.target, Paster.this.graph, resource);
                    }
                }
            }
        };
        CutProcedure referenceElementCutProcedure = new CutProcedure(){

            @Override
            boolean preCut(Resource resource) throws DatabaseException {
                return Paster.this.parentIsIncludedInCut(resource, ((Paster)Paster.this).MOD.HasParentComponent, true);
            }

            @Override
            void postCut(Resource resource, Object cutResult) throws Exception {
                if (cutResult != null) {
                    if (!Paster.this.parentIsIncludedInCut(resource, ((Paster)Paster.this).MOD.HasParentComponent, false)) {
                        Paster.this.applyPasteOffset(resource);
                    }
                    if (glm != null) {
                        glm.removeFromAllLayers(Paster.this.graph, resource);
                        glm.putElementOnVisibleLayers(((Paster)Paster.this).op.target, Paster.this.graph, resource);
                    }
                }
            }
        };
        CutProcedure connectionCutProcedure = new CutProcedure(){

            @Override
            void postCut(Resource resource, Object cutResult) throws Exception {
                if (cutResult != null) {
                    for (Resource rn : Paster.this.graph.getObjects(resource, ((Paster)Paster.this).DIA.HasInteriorRouteNode)) {
                        if (Paster.this.graph.isInstanceOf(rn, ((Paster)Paster.this).DIA.BranchPoint)) {
                            Paster.this.applyPasteOffset(rn);
                            continue;
                        }
                        if (!Paster.this.graph.isInstanceOf(rn, ((Paster)Paster.this).DIA.RouteLine)) continue;
                        Paster.this.applyPasteOffsetToRouteLine(rn);
                    }
                    if (glm != null) {
                        glm.removeFromAllLayers(Paster.this.graph, resource);
                        glm.putElementOnVisibleLayers(((Paster)Paster.this).op.target, Paster.this.graph, resource);
                    }
                }
            }
        };
        final HashSet<Resource> selectedConnections = new HashSet<Resource>();
        this.forEachResourceElement("Gather connections", this.op.ea.connections, new Procedure(){

            @Override
            public void execute(Resource resource) throws Exception {
                selectedConnections.add(resource);
            }
        });
        HashSet<Resource> affectedConnections = new HashSet<Resource>();
        this.disconnectExcludedConnections("Disconnect Nodes", this.op.ea.nodeList, selectedConnections, affectedConnections);
        this.disconnectExcludedConnections("Disconnect Flags", this.op.ea.flags, selectedConnections, affectedConnections);
        for (Resource connection : affectedConnections) {
            int connectedConnectors = this.cu.getConnectedConnectors(connection, null).size();
            int branchPoints = this.cu.getBranchPoints(connection, null).size();
            if (connectedConnectors > 0 && branchPoints > 0) continue;
            this.cu.removeConnection(connection);
        }
        this.cut("Cut Nodes", this.op.ea.nodeList, ComposedCutProcedure.compose(nodeCutProcedure, registerNames));
        this.cut("Cut Others", this.op.ea.others, ComposedCutProcedure.compose(nodeCutProcedure, registerNames));
        this.cut("Cut References", this.op.ea.references, ComposedCutProcedure.compose(referenceElementCutProcedure, registerNames));
        this.cut("Cut Flags", this.op.ea.flags, ComposedCutProcedure.compose(flagCutProcedure, registerNames));
        this.cut("Cut Connections", this.op.ea.connections, ComposedCutProcedure.compose(connectionCutProcedure, registerNames));
        this.cut("Cut Monitors", this.op.ea.monitors, ComposedCutProcedure.compose(monitorCutProcedure, registerNames));
        for (Resource element : cutElements) {
            AddElement.claimFreshElementName(this.graph, this.targetDiagram, element);
        }
        this.onFinish();
    }

    private Set<Resource> disconnectExcludedConnections(String description, Collection<Resource> nodes, final Set<Resource> selectedConnections, final Set<Resource> affectedConnections) throws Exception {
        final StructuralResource2 str = StructuralResource2.getInstance((ReadGraph)this.graph);
        this.forEachResourceElement(description, nodes, new Procedure(){

            @Override
            public void execute(Resource resource) throws Exception {
                for (Resource connector : Paster.this.graph.getObjects(resource, str.IsConnectedTo)) {
                    Resource connection = ConnectionUtil.tryGetConnection((ReadGraph)Paster.this.graph, connector);
                    if (connection == null) {
                        Paster.this.cu.removeConnectionPart(connector);
                        continue;
                    }
                    if (selectedConnections.contains(connection)) continue;
                    Paster.this.cu.removeConnectionPart(connector);
                    affectedConnections.add(connection);
                }
            }
        });
        return affectedConnections;
    }

    private void cut(final String description, Collection<Resource> elements, final CutProcedure cutProcedure) throws Exception {
        final CopyAdvisor advisor = (CopyAdvisor)this.op.target.getHint(SynchronizationHints.COPY_ADVISOR);
        this.forEachResourceElement(description, elements, new Procedure(){

            @Override
            public void execute(Resource resource) throws Exception {
                if (Paster.this.DEBUG) {
                    System.out.println("[" + description + "] " + NameUtils.getSafeName((ReadGraph)Paster.this.graph, (Resource)resource, (boolean)true));
                }
                if (cutProcedure != null && !cutProcedure.preCut(resource)) {
                    if (Paster.this.DEBUG) {
                        System.out.println("[" + description + "] ignoring element cut for " + NameUtils.getSafeName((ReadGraph)Paster.this.graph, (Resource)resource, (boolean)true));
                    }
                    return;
                }
                Object result = CopyAdvisorUtil.cut(Paster.this.targetContext, Paster.this.graph, advisor, resource, Paster.this.sourceDiagram, Paster.this.targetDiagram);
                if (Paster.this.DEBUG) {
                    System.out.println("[" + description + "] RESULT: " + result);
                }
                if (cutProcedure != null) {
                    cutProcedure.postCut(resource, result);
                }
            }
        });
    }

    protected void copy() throws Exception {
        this.nodeMap = new NodeMap();
        CommonDBUtils.selectClusterSet((WriteGraph)this.graph, (Resource)this.targetDiagram);
        if (this.op.initialNodeMap != null) {
            for (Map.Entry<Resource, Resource> entry : this.op.initialNodeMap.entrySet()) {
                this.nodeMap.put(entry.getKey(), null, new IdentifiedElement(entry.getValue(), null));
            }
        }
        this.copyNodes(this.nodeMap);
        this.copyReferences(this.nodeMap);
        this.copyFlags(this.nodeMap);
        this.copyConnections(this.nodeMap);
        this.copyMonitors(this.nodeMap);
        this.onFinish();
    }

    private NodeMap copyNodes(NodeMap nodeMap) throws Exception {
        this.copy("Copy Others", this.op.ea.others, nodeMap, this.nodeCopyProcedure);
        this.copy("Copy Nodes", this.op.ea.nodeList, nodeMap, this.nodeCopyProcedure);
        return nodeMap;
    }

    private NodeMap copyReferences(final NodeMap nodeMap) throws Exception {
        final boolean forceCopyReferences = this.op.hasOption(PasteOperation.ForceCopyReferences.class);
        this.copy("Copy References", this.op.ea.references, nodeMap, new CopyProcedure(this){

            @Override
            Resource copy(Resource source) throws Exception {
                Resource sourceParentComponent = graph.getPossibleObject(source, ((Paster)this).MOD.HasParentComponent);
                if (sourceParentComponent == null) {
                    return null;
                }
                Resource sourceParentElement = graph.getPossibleObject(sourceParentComponent, ((Paster)this).MOD.ComponentToElement);
                if (sourceParentElement != null) {
                    if (!forceCopyReferences && !((Paster)this).op.ea.all.contains(sourceParentElement)) {
                        return null;
                    }
                    IdentifiedElement copiedParentElement = nodeMap.get(sourceParentElement);
                    if (copiedParentElement == null) {
                        return null;
                    }
                    Resource copiedParentComponent = graph.getPossibleObject(copiedParentElement.getObject(), ((Paster)this).MOD.ElementToComponent);
                    if (copiedParentComponent == null) {
                        return null;
                    }
                    return this.copyReference(source, copiedParentComponent);
                }
                Resource partOf = graph.getPossibleObject(sourceParentComponent, ((Paster)this).L0.PartOf);
                if (partOf == null || graph.hasStatement(partOf, ((Paster)this).MOD.CompositeToDiagram)) {
                    return null;
                }
                Resource targetParentComponent = this.resolveTargetComponent(sourceParentComponent);
                if (targetParentComponent == null) {
                    return null;
                }
                return this.copyReference(source, targetParentComponent);
            }

            private Resource resolveTargetComponent(Resource sourceParentComponent) throws DatabaseException {
                if (operateWithinSameRoot) {
                    return sourceParentComponent;
                }
                String sourceUri = graph.getURI(sourceParentComponent);
                String targetUri = sourceUri.replace(sourceRootUri, targetRootUri);
                Resource targetParentComponent = graph.getPossibleResource(targetUri);
                return targetParentComponent;
            }

            private Resource copyReference(Resource source, Resource parentComponent) throws Exception {
                Resource referenceRelation = graph.getPossibleObject(source, ((Paster)this).MOD.HasReferenceRelation);
                if (referenceRelation == null) {
                    return null;
                }
                Resource relationCopy = CopyAdvisorUtil.copy4(graph, referenceRelation);
                if (relationCopy == null) {
                    return null;
                }
                Resource copy = nodeCopyProcedure.copy(source);
                for (Resource o : graph.getObjects(copy, ((Paster)this).L0.ConsistsOf)) {
                    boolean ownedByCopy = graph.hasStatement(o, ((Paster)this).L0.PartOf, copy);
                    if (ownedByCopy) {
                        graph.deny(copy, ((Paster)this).L0.ConsistsOf, o);
                        RemoverUtil.remove((WriteGraph)graph, (Resource)o);
                        continue;
                    }
                    graph.deny(copy, ((Paster)this).L0.ConsistsOf, o);
                }
                graph.deny(copy, ((Paster)this).MOD.HasParentComponent);
                if (parentComponent != null) {
                    graph.claim(copy, ((Paster)this).MOD.HasParentComponent, ((Paster)this).MOD.HasParentComponent_Inverse, parentComponent);
                }
                graph.claim(copy, ((Paster)this).L0.ConsistsOf, ((Paster)this).L0.PartOf, relationCopy);
                graph.claim(copy, ((Paster)this).MOD.HasReferenceRelation, ((Paster)this).MOD.HasReferenceRelation_Inverse, relationCopy);
                Layer0Utils.renewIdentifier((WriteGraph)graph, (Resource)relationCopy);
                for (Resource invRel : graph.getObjects(relationCopy, ((Paster)this).L0.ConsistsOf)) {
                    Layer0Utils.renewIdentifier((WriteGraph)graph, (Resource)invRel);
                }
                return copy;
            }

            @Override
            void postCopy(Resource source, Resource copy) throws Exception {
                Resource parentComponent = graph.getPossibleObject(source, ((Paster)this).MOD.HasParentComponent);
                if (parentComponent == null) {
                    return;
                }
                Resource parentElement = graph.getPossibleObject(parentComponent, ((Paster)this).MOD.ComponentToElement);
                if (parentElement == null) {
                    CopyPasteUtil.copyElementPosition(graph, ((Paster)this).op.ctx, source, copy, ((Paster)this).op.offset);
                }
            }
        });
        return nodeMap;
    }

    private NodeMap copyFlags(NodeMap nodeMap) throws Exception {
        Layer0 l0 = Layer0.getInstance((ReadGraph)this.graph);
        DiagramResource dia = DiagramResource.getInstance((ReadGraph)this.graph);
        class FlagCopy {
            private final Map<Resource, Resource> selectedFlags = new HashMap<Resource, Resource>();
            private final Map<Resource, Resource> flagSelectedCounterpart = new HashMap<Resource, Resource>();
            private final /* synthetic */ Layer0 val$l0;
            private final /* synthetic */ DiagramResource val$dia;

            FlagCopy(Layer0 layer0, DiagramResource diagramResource) {
                this.val$l0 = layer0;
                this.val$dia = diagramResource;
            }

            private void analyzeFlagSelection() throws DatabaseException {
                for (Resource flag : ((Paster)Paster.this).op.ea.flags) {
                    this.selectedFlags.put(flag, flag);
                }
                for (Resource flag : this.selectedFlags.keySet()) {
                    Resource counterpart;
                    boolean external = FlagUtil.isExternal((ReadGraph)Paster.this.graph, flag);
                    boolean inSingleDiagram = FlagUtil.isJoinedInSingleDiagram((ReadGraph)Paster.this.graph, flag);
                    if (external || !inSingleDiagram || !this.selectedFlags.containsKey(counterpart = FlagUtil.getPossibleCounterpart((ReadGraph)Paster.this.graph, flag))) continue;
                    this.flagSelectedCounterpart.put(flag, counterpart);
                    this.flagSelectedCounterpart.put(counterpart, flag);
                }
            }

            private void reconnectLocalFlagPairs(NodeMap nodeMap) throws DatabaseException {
                FlagLabelingScheme scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)Paster.this.graph);
                Resource diagram = ((Paster)Paster.this).op.targetDiagram;
                HashSet<Resource> visited = new HashSet<Resource>();
                ArrayDeque<Resource> queue = new ArrayDeque<Resource>(this.flagSelectedCounterpart.values());
                while (!queue.isEmpty()) {
                    String label;
                    Resource flag = queue.poll();
                    Resource counterpart = this.flagSelectedCounterpart.get(flag);
                    if (!visited.add(flag) || !visited.add(counterpart) || counterpart == null) continue;
                    Resource flagSourceElement = this.selectedFlags.get(flag);
                    Resource counterpartSourceElement = this.selectedFlags.get(counterpart);
                    IdentifiedElement flagCopy = nodeMap.get(flagSourceElement);
                    IdentifiedElement counterpartCopy = nodeMap.get(counterpartSourceElement);
                    FlagUtil.join(Paster.this.graph, flagCopy.getObject(), counterpartCopy.getObject());
                    if (scheme == null || (label = scheme.generateLabel((ReadGraph)Paster.this.graph, diagram)) == null) continue;
                    Paster.this.graph.claimLiteral(flagCopy.getObject(), this.val$l0.HasLabel, this.val$dia.FlagLabel, (Object)label, (Binding)Bindings.STRING);
                    Paster.this.graph.claimLiteral(counterpartCopy.getObject(), this.val$l0.HasLabel, this.val$dia.FlagLabel, (Object)label, (Binding)Bindings.STRING);
                }
            }

            public void perform(NodeMap nodeMap) throws Exception {
                this.analyzeFlagSelection();
                Paster.this.copy("Copy Flags", ((Paster)Paster.this).op.ea.flags, nodeMap, new CopyProcedure(Paster.this){

                    @Override
                    Resource copy(Resource source) throws Exception {
                        return ((FlagCopy)this).Paster.this.nodeCopyProcedure.copy(source);
                    }

                    @Override
                    public void postCopy(Resource source, Resource copy) throws Exception {
                        AffineTransform at = CopyPasteUtil.copyElementPosition(Paster.this.graph, ((Paster)((FlagCopy)this).Paster.this).op.ctx, source, copy, ((Paster)((FlagCopy)this).Paster.this).op.offset);
                        IOTablesInfo ioTablesInfo = IOTableUtil.getIOTablesInfo((ReadGraph)Paster.this.graph, ((Paster)((FlagCopy)this).Paster.this).op.targetDiagram);
                        ioTablesInfo.updateBinding(Paster.this.graph, Paster.this.DIA, copy, at.getTranslateX(), at.getTranslateY());
                        Paster.this.graph.denyValue(copy, val$l0.HasLabel);
                    }
                });
                this.reconnectLocalFlagPairs(nodeMap);
            }
        }
        new FlagCopy(l0, dia).perform(nodeMap);
        return nodeMap;
    }

    private NodeMap copyMonitors(final NodeMap nodeMap) throws Exception {
        this.copy("Copy Monitors", this.op.ea.monitors, nodeMap, new CopyProcedure(this){

            @Override
            Resource copy(Resource source) throws Exception {
                Resource monitorElement;
                Resource monitorComponent;
                if (!(operateWithinSameRoot || (monitorComponent = graph.getPossibleObject(source, ((Paster)this).DIA.HasMonitorComponent)) == null || (monitorElement = graph.getPossibleObject(monitorComponent, ((Paster)this).MOD.ComponentToElement)) != null && ((Paster)this).op.ea.all.contains(monitorElement))) {
                    return null;
                }
                Resource copy = nodeCopyProcedure.copy(source);
                return copy;
            }

            @Override
            void postCopy(Resource source, Resource copy) throws Exception {
                String monitorSuffix;
                Resource monitorElement = null;
                Resource monitorComponent = graph.getPossibleObject(source, ((Paster)this).DIA.HasMonitorComponent);
                if (monitorComponent != null) {
                    monitorElement = graph.getPossibleObject(monitorComponent, ((Paster)this).MOD.ComponentToElement);
                }
                if (monitorElement != null && ((Paster)this).op.ea.all.contains(monitorElement)) {
                    graph.deny(copy, ((Paster)this).DIA.HasMonitorComponent);
                    IdentifiedElement parent = nodeMap.get(monitorElement);
                    if (parent != null && (monitorComponent = graph.getPossibleObject(parent.getObject(), ((Paster)this).MOD.ElementToComponent)) != null) {
                        graph.claim(copy, ((Paster)this).DIA.HasMonitorComponent, monitorComponent);
                    }
                } else {
                    if (operateWithinSameRoot && monitorComponent != null) {
                        graph.claim(copy, ((Paster)this).DIA.HasMonitorComponent, monitorComponent);
                    }
                    Point2D offset = ((Paster)this).op.offset;
                    if (!op.sameDiagram() && monitorElement != null) {
                        AffineTransform monitoredComponentTr = DiagramGraphUtil.getWorldTransform((ReadGraph)graph, monitorElement);
                        offset = new Point2D.Double(((Paster)this).op.offset.getX() + monitoredComponentTr.getTranslateX(), ((Paster)this).op.offset.getY() + monitoredComponentTr.getTranslateY());
                    }
                    CopyPasteUtil.copyElementPosition(graph, ((Paster)this).op.ctx, source, copy, offset);
                }
                if ((monitorSuffix = (String)graph.getPossibleRelatedValue(source, ((Paster)this).DIA.HasMonitorSuffix, (Binding)Bindings.STRING)) != null) {
                    graph.claimLiteral(copy, ((Paster)this).DIA.HasMonitorSuffix, (Object)monitorSuffix, (Binding)Bindings.STRING);
                }
                graph.deny(copy, ((Paster)this).L0X.ObtainsProperty);
                for (Statement stm : graph.getStatements(source, ((Paster)this).L0X.ObtainsProperty)) {
                    graph.claim(copy, stm.getPredicate(), null, stm.getObject());
                }
            }
        });
        return nodeMap;
    }

    private void copy(final String description, Collection<Resource> elements, final NodeMap nodeMap, final CopyProcedure copyProcedure) throws Exception {
        if (copyProcedure == null) {
            throw new IllegalArgumentException("null copy procedure");
        }
        this.forEachResourceElement(description, elements, new Procedure(){

            @Override
            public void execute(Resource resource) throws Exception {
                Resource copy;
                if (Paster.this.DEBUG) {
                    System.out.println("[" + description + "] " + NameUtils.getSafeName((ReadGraph)Paster.this.graph, (Resource)resource, (boolean)true));
                }
                if ((copy = copyProcedure.copy(resource)) != null) {
                    if (Paster.this.DEBUG) {
                        System.out.println("[" + description + "] " + NameUtils.getSafeName((ReadGraph)Paster.this.graph, (Resource)resource, (boolean)true) + " copied as " + NameUtils.getSafeName((ReadGraph)Paster.this.graph, (Resource)copy, (boolean)true));
                    }
                    nodeMap.put(resource, null, new IdentifiedElement(copy, null));
                    if (((Paster)Paster.this).op.copyMap != null) {
                        ((Paster)Paster.this).op.copyMap.put(resource, copy);
                    }
                    copyProcedure.postCopy(resource, copy);
                }
            }
        });
    }

    public static RouteLine readRouteLine(ReadGraph graph, Resource src) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Double pos = (Double)graph.getPossibleRelatedValue(src, DIA.HasPosition, (Binding)Bindings.DOUBLE);
        Boolean hor = (Boolean)graph.getPossibleRelatedValue(src, DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
        return new RouteLine(pos, hor);
    }

    public static BranchPoint readBranchPoint(ReadGraph graph, Resource src) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        AffineTransform at = DiagramGraphUtil.getTransform(graph, src);
        boolean hor = graph.hasStatement(src, DIA.Horizontal);
        boolean ver = graph.hasStatement(src, DIA.Vertical);
        return new BranchPoint(at, hor, ver);
    }

    private NodeMap copyConnections(final NodeMap nodeMap) throws Exception {
        final StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)this.graph);
        final DiagramResource DIA = DiagramResource.getInstance((ReadGraph)this.graph);
        final CopyAdvisor ca = (CopyAdvisor)this.op.target.getHint(SynchronizationHints.COPY_ADVISOR);
        if (ca == null) {
            throw new UnsupportedOperationException("Cannot copy connections, no copy advisor available for diagram " + this.op.target);
        }
        this.forEachResourceElement("Copy Connections", this.op.ea.connections, new Procedure(){

            @Override
            public void execute(Resource sourceObject) throws DatabaseException {
                this.copyConnection(sourceObject);
            }

            private void copyConnection(Resource sourceObject) throws DatabaseException {
                Resource dst2;
                Resource copy;
                THashMap resourceMap = new THashMap();
                StatementMap connectorToNode = new StatementMap();
                Resource sourceDiagram = Paster.this.graph.getPossibleObject(sourceObject, Layer0.getInstance((ReadGraph)((Paster)Paster.this).graph).PartOf);
                if (sourceDiagram == null) {
                    sourceDiagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)Paster.this.graph, (Resource)sourceObject, (Resource)DIA.Diagram);
                }
                if ((copy = CopyAdvisorUtil.copy(Paster.this.targetContext, Paster.this.graph, ca, sourceObject, sourceDiagram, ((Paster)Paster.this).op.targetDiagram, (Map<Object, Object>)resourceMap)) == null) {
                    throw new UnsupportedOperationException("Could not copy connection " + sourceObject);
                }
                OrderedSetUtils.addFirst((WriteGraph)Paster.this.graph, (Resource)((Paster)Paster.this).op.targetDiagram, (Resource)copy);
                Paster.this.graph.deny(copy, ((Paster)Paster.this).MOD.IsTemplatized, copy);
                AddElement.claimFreshElementName(Paster.this.graph, ((Paster)Paster.this).op.targetDiagram, copy);
                AddConnection.copyConnectionType(Paster.this.graph, sourceObject, copy);
                GraphLayerManager glm = (GraphLayerManager)Paster.this.targetContext.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
                if (glm != null) {
                    glm.removeFromAllLayers(Paster.this.graph, copy);
                    glm.putElementOnVisibleLayers(((Paster)Paster.this).op.target, Paster.this.graph, copy);
                }
                nodeMap.put(sourceObject, null, new IdentifiedElement(copy, null));
                if (((Paster)Paster.this).op.copyMap != null) {
                    ((Paster)Paster.this).op.copyMap.put(sourceObject, copy);
                }
                boolean mapResources = resourceMap.isEmpty();
                Collection sourceHasConnectors = Paster.this.graph.getStatements(sourceObject, DIA.HasConnector);
                MapQueue<Resource, Resource> connectorsByType = new MapQueue<Resource, Resource>();
                block0: for (Statement hasConnector : sourceHasConnectors) {
                    connectorsByType.offer(hasConnector.getPredicate(), hasConnector.getObject());
                    for (Statement connects : Paster.this.graph.getStatements(hasConnector.getObject(), STR.Connects)) {
                        if (sourceObject.equals(connects.getObject())) continue;
                        connectorToNode.put(hasConnector.getObject(), connects);
                        continue block0;
                    }
                }
                if (mapResources) {
                    for (Statement hasConnector : Paster.this.graph.getStatements(copy, DIA.HasConnector)) {
                        Resource srcConnector = (Resource)connectorsByType.poll(hasConnector.getPredicate());
                        resourceMap.put(srcConnector, hasConnector.getObject());
                    }
                }
                Collection sourceInteriorRouteNodes = Paster.this.graph.getObjects(sourceObject, DIA.HasInteriorRouteNode);
                if (mapResources) {
                    ArrayDeque<Resource> branchPoints = new ArrayDeque<Resource>(sourceInteriorRouteNodes.size());
                    Iterator<Resource> routeLines = new ArrayDeque(sourceInteriorRouteNodes.size());
                    for (Resource dst2 : Paster.this.graph.getObjects(copy, DIA.HasInteriorRouteNode)) {
                        if (Paster.this.graph.isInstanceOf(dst2, DIA.BranchPoint)) {
                            branchPoints.offer(dst2);
                            continue;
                        }
                        if (!Paster.this.graph.isInstanceOf(dst2, DIA.RouteLine)) continue;
                        routeLines.offer(dst2);
                    }
                    for (Resource src : sourceInteriorRouteNodes) {
                        Resource dst3;
                        if (Paster.this.graph.isInstanceOf(src, DIA.BranchPoint)) {
                            dst3 = (Resource)branchPoints.poll();
                            resourceMap.put(src, dst3);
                            BranchPoint bp = Paster.readBranchPoint((ReadGraph)Paster.this.graph, src);
                            AffineTransform at = bp.getTransform();
                            at.preConcatenate(Paster.this.offsetTransform);
                            DiagramGraphUtil.setTransform(Paster.this.graph, dst3, at);
                            continue;
                        }
                        if (!Paster.this.graph.isInstanceOf(src, DIA.RouteLine)) continue;
                        dst3 = (Resource)routeLines.poll();
                        resourceMap.put(src, dst3);
                        RouteLine rl = Paster.readRouteLine((ReadGraph)Paster.this.graph, src);
                        double newPos = rl.getPosition() + (rl.isHorizontal() ? ((Paster)Paster.this).op.offset.getY() : ((Paster)Paster.this).op.offset.getX());
                        Paster.this.graph.claimLiteral(dst3, DIA.HasPosition, (Object)newPos, (Binding)Bindings.DOUBLE);
                    }
                } else {
                    for (Resource src : sourceInteriorRouteNodes) {
                        dst2 = (Resource)resourceMap.get(src);
                        if (dst2 == null) continue;
                        if (Paster.this.graph.isInstanceOf(src, DIA.BranchPoint)) {
                            BranchPoint bp = Paster.readBranchPoint((ReadGraph)Paster.this.graph, src);
                            AffineTransform at = bp.getTransform();
                            at.preConcatenate(Paster.this.offsetTransform);
                            DiagramGraphUtil.setTransform(Paster.this.graph, dst2, at);
                            continue;
                        }
                        if (!Paster.this.graph.isInstanceOf(src, DIA.RouteLine)) continue;
                        RouteLine rl = Paster.readRouteLine((ReadGraph)Paster.this.graph, src);
                        double newPos = rl.getPosition() + (rl.isHorizontal() ? ((Paster)Paster.this).op.offset.getY() : ((Paster)Paster.this).op.offset.getX());
                        Paster.this.graph.claimLiteral(dst2, DIA.HasPosition, (Object)newPos, (Binding)Bindings.DOUBLE);
                    }
                }
                for (Resource src : sourceInteriorRouteNodes) {
                    dst2 = (Resource)resourceMap.get(src);
                    for (Resource connectedToSrc : Paster.this.graph.getObjects(src, DIA.AreConnected)) {
                        Resource connectedToDst = (Resource)resourceMap.get(connectedToSrc);
                        if (connectedToDst != null) {
                            Paster.this.graph.claim(dst2, DIA.AreConnected, DIA.AreConnected, connectedToDst);
                            continue;
                        }
                        throw new DatabaseException("Connection copying failed due to an invalid DIA.AreConnected link between source resources " + src + " <-> " + connectedToSrc);
                    }
                }
                for (Statement hasConnector : sourceHasConnectors) {
                    Resource srcConnector = hasConnector.getObject();
                    Resource dstConnector = (Resource)resourceMap.get(srcConnector);
                    Statement srcConnects = (Statement)connectorToNode.get(srcConnector);
                    IdentifiedElement dstNode = nodeMap.get(srcConnects.getObject());
                    if (dstNode == null) {
                        throw new DatabaseException("Source element " + NameUtils.getURIOrSafeNameInternal((ReadGraph)Paster.this.graph, (Resource)srcConnects.getObject()) + " not copied causing copying of connection " + NameUtils.getURIOrSafeNameInternal((ReadGraph)Paster.this.graph, (Resource)sourceObject) + " to fail.");
                    }
                    Paster.this.graph.claim(dstConnector, srcConnects.getPredicate(), dstNode.getObject());
                    for (Resource connectedToSrc : Paster.this.graph.getObjects(srcConnector, DIA.AreConnected)) {
                        Resource connectedToDst = (Resource)resourceMap.get(connectedToSrc);
                        Paster.this.graph.claim(dstConnector, DIA.AreConnected, DIA.AreConnected, connectedToDst);
                    }
                }
                Resource sourceComponent = Paster.this.graph.getPossibleObject(sourceObject, ((Paster)Paster.this).MOD.ElementToComponent);
                if (sourceComponent != null) {
                    for (Statement hasConnector : sourceHasConnectors) {
                        Resource targetComponent;
                        Resource sourceConnector = hasConnector.getObject();
                        Resource targetConnector = (Resource)resourceMap.get(sourceConnector);
                        if (!$assertionsDisabled && targetConnector == null) {
                            throw new AssertionError();
                        }
                        Statement sourceConnectorToComponent = Paster.this.graph.getPossibleStatement(sourceConnector, ((Paster)Paster.this).MOD.ConnectorToComponent);
                        if (sourceConnectorToComponent == null || !sourceConnectorToComponent.getObject().equals(sourceComponent) || (targetComponent = Paster.this.graph.getPossibleObject(copy, ((Paster)Paster.this).MOD.ElementToComponent)) == null) continue;
                        Paster.this.graph.claim(targetConnector, sourceConnectorToComponent.getPredicate(), targetComponent);
                        for (Resource connectionMappingSpec : Paster.this.graph.getObjects(sourceConnector, ((Paster)Paster.this).MOD.HasConnectionMappingSpecification)) {
                            Paster.this.graph.claim(targetConnector, ((Paster)Paster.this).MOD.HasConnectionMappingSpecification, connectionMappingSpec);
                        }
                    }
                }
            }
        });
        return nodeMap;
    }

    private static Resource getAttachmentRelation(ReadGraph graph, ConnectionJudgement judgment, IConnectionPoint connectionPoint, Resource defaultValue) throws DatabaseException {
        if (judgment == null || !(connectionPoint instanceof CPTerminal) || judgment.attachmentRelations == null) {
            return defaultValue;
        }
        Resource attachment = judgment.attachmentRelations.get(graph, (CPTerminal)connectionPoint);
        return attachment != null ? attachment : defaultValue;
    }

    public NodeMap getNodeMap() {
        return this.nodeMap;
    }

    protected PasteOperation getOperation() {
        return this.op;
    }

    public WriteGraph getGraph() {
        return this.graph;
    }

    public static class BranchPoint
    extends Tuple3 {
        public BranchPoint(AffineTransform at, Boolean horizontal, Boolean vertical) {
            super((Object)at, (Object)horizontal, (Object)vertical);
        }

        public AffineTransform getTransform() {
            return (AffineTransform)this.get(0);
        }
    }

    static class ComposedCutProcedure
    extends CutProcedure {
        private final CutProcedure[] procedures;

        public static ComposedCutProcedure compose(CutProcedure ... procedures) {
            return new ComposedCutProcedure(procedures);
        }

        public ComposedCutProcedure(CutProcedure ... procedures) {
            this.procedures = procedures;
        }

        @Override
        boolean preCut(Resource resource) throws Exception {
            CutProcedure[] cutProcedureArray = this.procedures;
            int n = this.procedures.length;
            int n2 = 0;
            while (n2 < n) {
                CutProcedure proc = cutProcedureArray[n2];
                if (!proc.preCut(resource)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        void postCut(Resource resource, Object cutResult) throws Exception {
            CutProcedure[] cutProcedureArray = this.procedures;
            int n = this.procedures.length;
            int n2 = 0;
            while (n2 < n) {
                CutProcedure proc = cutProcedureArray[n2];
                proc.postCut(resource, cutResult);
                ++n2;
            }
        }
    }

    class CopyProcedure {
        CopyProcedure() {
        }

        Resource copy(Resource source) throws Exception {
            throw new UnsupportedOperationException();
        }

        void postCopy(Resource source, Resource copy) throws Exception {
        }
    }

    static class CutProcedure {
        CutProcedure() {
        }

        boolean preCut(Resource resource) throws Exception {
            return true;
        }

        void postCut(Resource resource, Object cutResult) throws Exception {
        }
    }

    static class IdentifiedElement
    extends Tuple {
        public IdentifiedElement(Resource object, IElement element) {
            super(new Object[]{object, element});
        }

        public Resource getObject() {
            return (Resource)this.getField(0);
        }

        public IElement getElement() {
            return (IElement)this.getField(1);
        }
    }

    static class MapQueue<K, V> {
        Map<K, Deque<V>> map = new HashMap<K, Deque<V>>();

        MapQueue() {
        }

        public void offer(K key, V value) {
            Deque<V> deque = this.map.get(key);
            if (deque == null) {
                deque = new ArrayDeque<V>();
                this.map.put(key, deque);
            }
            deque.offer(value);
        }

        public V poll(K key) {
            Deque<V> deque = this.map.get(key);
            if (deque == null) {
                return null;
            }
            V value = deque.poll();
            if (deque.isEmpty()) {
                this.map.remove(key);
            }
            return value;
        }
    }

    public static class NodeMap {
        Map<Resource, IdentifiedElement> resourceMap = new HashMap<Resource, IdentifiedElement>();
        Map<IElement, IdentifiedElement> elementMap = new HashMap<IElement, IdentifiedElement>();

        public void put(Resource sourceResource, IElement sourceElement, IdentifiedElement dst) {
            if (sourceResource == null) {
                throw new NullPointerException("null source resource");
            }
            this.resourceMap.put(sourceResource, dst);
            if (sourceElement != null) {
                this.elementMap.put(sourceElement, dst);
            }
        }

        public IdentifiedElement get(Resource source) {
            return this.resourceMap.get(source);
        }

        public IdentifiedElement get(IElement source) {
            return this.elementMap.get(source);
        }

        public Set<Resource> allResources() {
            return this.resourceMap.keySet();
        }

        public Resource getResource(Resource source) {
            IdentifiedElement ie = this.resourceMap.get(source);
            if (ie != null) {
                return ie.getObject();
            }
            return null;
        }

        public Resource getResource(IElement source) {
            IdentifiedElement ie = this.elementMap.get(source);
            if (ie != null) {
                return ie.getObject();
            }
            return null;
        }
    }

    static interface Procedure {
        public void execute(Resource var1) throws Exception;
    }

    static class ResourceMap
    extends HashMap<Resource, Resource> {
        private static final long serialVersionUID = 687528035082504835L;

        ResourceMap() {
        }
    }

    public static class RouteLine
    extends Tuple2 {
        public RouteLine(Double position, Boolean horizontal) {
            super((Object)position, (Object)horizontal);
        }

        public double getPosition() {
            Double pos = (Double)this.get(0);
            return pos != null ? pos : 0.0;
        }

        public boolean isHorizontal() {
            return Boolean.TRUE.equals(this.get(1));
        }
    }

    static class StatementMap
    extends HashMap<Resource, Statement> {
        private static final long serialVersionUID = 8520092255776208395L;

        StatementMap() {
        }
    }
}

