/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.simantics.diagram.elements.ResizeNode;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.PropertySetter;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ResizeRectangularSceneGraph
implements SceneGraph {
    private static final long serialVersionUID = -972741261034892976L;
    public static final ResizeRectangularSceneGraph INSTANCE = new ResizeRectangularSceneGraph();
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(ResizeNode.class, "RESIZE_RECTANGULAR_SG_NODE");
    private IHintContext.Key resizedNodeKey;
    private IHintContext.Key transformKey;
    private IHintContext.Key boundsKey;
    private ResizeNode.TranslateEdge xTranslateEdge;
    private ResizeNode.TranslateEdge yTranslateEdge;

    public ResizeRectangularSceneGraph() {
        this(null);
    }

    public ResizeRectangularSceneGraph(IHintContext.Key sgNode) {
        this(sgNode, ResizeNode.TranslateEdge.WEST, ResizeNode.TranslateEdge.NORTH, ElementHints.KEY_TRANSFORM, ElementHints.KEY_BOUNDS);
    }

    public ResizeRectangularSceneGraph(IHintContext.Key sgNode, ResizeNode.TranslateEdge xTranslateEdge, ResizeNode.TranslateEdge yTranslateEdge, IHintContext.Key transformKey, IHintContext.Key boundsKey) {
        this.resizedNodeKey = sgNode;
        this.xTranslateEdge = xTranslateEdge;
        this.yTranslateEdge = yTranslateEdge;
        this.transformKey = transformKey;
        this.boundsKey = boundsKey;
    }

    public void init(final IElement e, G2DParentNode parent) {
        if (!((Boolean)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_RESIZABLE, (Object)false)).booleanValue()) {
            return;
        }
        ResizeNode node = (ResizeNode)((Object)e.getHint(KEY_SG_NODE));
        if (node == null) {
            node = (ResizeNode)((Object)parent.addNode(ResizeNode.class));
            e.setHint(KEY_SG_NODE, (Object)node);
            node.setStroke(new BasicStroke(1.0f));
            node.setZIndex(-1500);
            node.setResizeListener(new ResizeNode.ResizeListener(){

                @Override
                public void elementResized(Rectangle2D newBounds, AffineTransform transform, boolean synchronizeToBackend) {
                    Map hints = e.getHints();
                    AffineTransform at = new AffineTransform((AffineTransform)hints.get(ResizeRectangularSceneGraph.this.transformKey));
                    at.concatenate(transform);
                    hints.put(ResizeRectangularSceneGraph.this.transformKey, at);
                    hints.put(ResizeRectangularSceneGraph.this.boundsKey, newBounds);
                    hints.put(Hints.KEY_DIRTY, Hints.VALUE_SG_DIRTY);
                    e.setHints(hints);
                    if (synchronizeToBackend) {
                        IDiagram diagram = ElementUtils.getDiagram((IElement)e);
                        DiagramUtils.synchronizeHintsToBackend((IDiagram)diagram, (IElement[])new IElement[]{e});
                    }
                }
            });
        }
        if (node != null) {
            Object resizedNode;
            node.setxTranslateEdge(this.xTranslateEdge);
            node.setYTranslateEdge(this.yTranslateEdge);
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            Rectangle2D b = null;
            if (b == null && this.resizedNodeKey != null && (resizedNode = e.getHint(this.resizedNodeKey)) != null && resizedNode instanceof G2DNode) {
                G2DNode n = (G2DNode)resizedNode;
                b = n.getBoundsInLocal();
                AffineTransform nodeTransform = n.getTransform();
                at = new AffineTransform(nodeTransform);
            }
            if (b == null) {
                b = ElementUtils.getElementBounds((IElement)e);
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
            node.setBounds(bounds);
            if (at != null) {
                node.setTransform(at);
            }
        }
        this.update(e);
    }

    public void update(IElement e) {
        PropertySetter setter = (PropertySetter)e.getElementClass().getSingleItem(PropertySetter.class);
        setter.syncPropertiesToNode(e);
    }

    public void cleanup(IElement e) {
        ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)KEY_SG_NODE);
    }

    public void setXTranslateEdge(ResizeNode.TranslateEdge xTranslateEdge) {
        this.xTranslateEdge = xTranslateEdge;
    }

    public void setYTranslateEdge(ResizeNode.TranslateEdge yTranslateEdge) {
        this.yTranslateEdge = yTranslateEdge;
    }
}

