/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.procedure.wrapper.SetListenerToSingleSetListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SetListener;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.profile.Group;

public class MappedTypeGroup
implements Group {
    private final List<Resource> types;
    private final String name;

    public MappedTypeGroup(String name, Resource type) {
        this(name, new Resource[0]);
    }

    public MappedTypeGroup(String name, Resource ... types) {
        this.types = Arrays.asList(types);
        this.name = name;
    }

    public MappedTypeGroup(ReadGraph graph, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.name = (String)graph.getPossibleRelatedValue(group, L0.HasName, (Binding)Bindings.STRING);
        this.types = new ArrayList<Resource>();
        this.types.addAll(graph.getObjects(group, DIA.TypeGroup_HasType));
    }

    public void trackItems(RequestProcessor processor, final Resource runtimeDiagram, SetListener<Resource> listener) {
        if (this.types.isEmpty()) {
            System.out.println("MappedTypeGroup has no types!");
            return;
        }
        processor.asyncRequest((Read)new BinaryRead<Resource, Collection<Resource>, Collection<Resource>>(runtimeDiagram, this.types){

            public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
                HashSet<Resource> result = new HashSet<Resource>();
                Resource realDiagram = graph.getPossibleObject(runtimeDiagram, DiagramResource.getInstance((ReadGraph)graph).RuntimeDiagram_HasConfiguration);
                if (realDiagram == null) {
                    return result;
                }
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Collection elements = graph.syncRequest((AsyncMultiRead)new OrderedSet(realDiagram));
                for (Resource element : elements) {
                    Resource mapped = graph.getPossibleObject(element, MOD.ElementToComponent);
                    if (mapped != null) {
                        Set mappedTypes = graph.getTypes(mapped);
                        if (Collections.disjoint(MappedTypeGroup.this.types, mappedTypes)) continue;
                        result.add(element);
                        continue;
                    }
                    Resource referenceRelation = graph.getPossibleObject(element, MOD.HasReferenceRelation);
                    if (referenceRelation == null) continue;
                    Collection referencedTypes = graph.getObjects(referenceRelation, MOD.HasReferencedType);
                    if (!Collections.disjoint(MappedTypeGroup.this.types, referencedTypes)) {
                        result.add(element);
                        continue;
                    }
                    for (Resource referencedType : referencedTypes) {
                        Set allTypes = graph.getSupertypes(referencedType);
                        if (Collections.disjoint(MappedTypeGroup.this.types, allTypes)) continue;
                        result.add(element);
                    }
                }
                return result;
            }
        }, (Listener)new SetListenerToSingleSetListener(listener));
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (MappedTypeGroup.class != object.getClass()) {
            return false;
        }
        MappedTypeGroup other = (MappedTypeGroup)object;
        return this.types.equals(other.types);
    }

    public String toString() {
        return "every '" + this.name + "'";
    }
}

