/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Rectangle2D;

public class Rectangle {
    public final double x0;
    public final double y0;
    public final double x1;
    public final double y1;

    public Rectangle(double x0, double y0, double x1, double y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public boolean intersects(Rectangle rect) {
        return this.x0 <= rect.x1 && rect.x0 <= this.x1 && this.y0 <= rect.y1 && rect.y0 <= this.y1;
    }

    public boolean contains(double x, double y) {
        return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
    }

    public static Rectangle of(Rectangle2D rect) {
        return new Rectangle(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[x0=" + this.x0 + ",y0=" + this.y0 + ",x1=" + this.x1 + ",y1=" + this.y1 + "]";
    }
}

