/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Map;
import org.simantics.g2d.chassis.GraphicsAdapter;

public class DebugGraphics
extends GraphicsAdapter {
    public final PrintStream o;

    public DebugGraphics(Graphics2D g, PrintStream out) {
        super(g);
        this.o = out;
    }

    public DebugGraphics(Graphics2D g) {
        super(g);
        this.o = System.out;
    }

    public void print(Object ... args) {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        this.o.print(e[2].getMethodName());
        if (args != null && args.length > 0) {
            this.o.print(Arrays.toString(args));
        }
        this.o.println();
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.print(new Object[0]);
        super.addRenderingHints(hints);
    }

    @Override
    public void clip(Shape s) {
        this.print(new Object[0]);
        super.clip(s);
    }

    @Override
    public void draw(Shape s) {
        this.print(s);
        super.draw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        super.drawGlyphVector(g, x, y);
        this.print(g, Float.valueOf(x), Float.valueOf(y));
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.print(img, xform, obs);
        return this.g.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.print(img, op, x, y);
        super.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.print(img, xform);
        super.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.print(img, xform);
        super.drawRenderedImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.print(str, x, y);
        super.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.print(str, Float.valueOf(x), Float.valueOf(y));
        super.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.print(iterator, x, y);
        super.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.print(iterator, Float.valueOf(x), Float.valueOf(y));
        super.drawString(iterator, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.print(s);
        super.fill(s);
    }

    @Override
    public Color getBackground() {
        this.print(new Object[0]);
        return this.g.getBackground();
    }

    @Override
    public Composite getComposite() {
        this.print(new Object[0]);
        return this.g.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        this.print(new Object[0]);
        return this.g.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        this.print(new Object[0]);
        return this.g.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        this.print(new Object[0]);
        return this.g.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        this.print(hintKey);
        return this.g.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        this.print(new Object[0]);
        return this.g.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        this.print(new Object[0]);
        return this.g.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        this.print(new Object[0]);
        return this.g.getTransform();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.print(rect, s, onStroke);
        return this.g.hit(rect, s, onStroke);
    }

    @Override
    public void rotate(double theta) {
        this.print(theta);
        super.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.print(theta, x, y);
        super.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.print(sx, sy);
        super.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        this.print(color);
        super.setBackground(color);
    }

    @Override
    public void setComposite(Composite comp) {
        this.print(comp);
        super.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.print(paint);
        super.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.print(hintKey, hintValue);
        super.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.print(hints);
        super.setRenderingHints(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.print(s);
        super.setStroke(s);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.print(Tx);
        super.setTransform(Tx);
    }

    @Override
    public void shear(double shx, double shy) {
        this.print(shx, shy);
        super.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.print(Tx);
        super.transform(Tx);
    }

    @Override
    public void translate(int x, int y) {
        this.print(x, y);
        super.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.print(tx, ty);
        super.translate(tx, ty);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.print(x, y, width, height);
        super.clearRect(x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.print(x, y, width, height);
        super.clearRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.print(x, y, width, height, dx, dy);
        super.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        this.print(new Object[0]);
        return new DebugGraphics((Graphics2D)this.g.create());
    }

    @Override
    public void dispose() {
        this.print(new Object[0]);
        super.dispose();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.print(x, y, width, height, startAngle, arcAngle);
        super.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.print(img, x, y, observer);
        return this.g.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.print(img, x, y, bgcolor, observer);
        return this.g.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.print(img, x, y, width, height, observer);
        return this.g.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.print(img, x, y, width, height, bgcolor, observer);
        return this.g.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.print(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.print(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.print(x1, y1, x2, y2);
        super.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.print(x, y, width, height);
        super.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] points, int[] points2, int points3) {
        this.print(points, points2, points3);
        super.drawPolygon(points, points2, points3);
    }

    @Override
    public void drawPolyline(int[] points, int[] points2, int points3) {
        this.print(points, points2, points3);
        super.drawPolyline(points, points2, points3);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.print(x, y, width, height, arcWidth, arcHeight);
        super.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.print(x, y, width, height, startAngle, arcAngle);
        super.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.print(x, y, width, height);
        super.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] points, int[] points2, int points3) {
        this.print(points, points2, points3);
        super.fillPolygon(points, points2, points3);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.print(x, y, width, height);
        super.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.print(x, y, width, height, arcWidth, arcHeight);
        super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Shape getClip() {
        this.print(new Object[0]);
        return this.g.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        this.print(new Object[0]);
        return this.g.getClipBounds();
    }

    @Override
    public Color getColor() {
        this.print(new Object[0]);
        return this.g.getColor();
    }

    @Override
    public Font getFont() {
        this.print(new Object[0]);
        return this.g.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        this.print(new Object[0]);
        return this.g.getFontMetrics(f);
    }

    @Override
    public void setClip(Shape clip) {
        this.print(clip);
        super.setClip(clip);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.print(x, y, width, height);
        super.setClip(x, y, width, height);
    }

    @Override
    public void setColor(Color c) {
        this.print(c);
        super.setColor(c);
    }

    @Override
    public void setFont(Font font) {
        this.print(font);
        super.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.print(new Object[0]);
        super.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.print(c1);
        super.setXORMode(c1);
    }
}

