/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.rule.instructions.IRuleInstruction;

public class AndRuleInstruction
implements IRuleInstruction {
    IRuleInstruction[] rules;

    public AndRuleInstruction(IRuleInstruction ... rules) {
        this.rules = rules;
    }

    @Override
    public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        int i = 0;
        while (i < this.rules.length) {
            IRuleInstruction rule = this.rules[i];
            final IModification modi = rule.execute(g, bindings);
            if (modi != null) {
                final int si = i + 1;
                if (si == this.rules.length) {
                    return modi;
                }
                final Object[] curBindings = Arrays.copyOf(bindings, bindings.length);
                return new IModification(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        modi.perform(g);
                        int j = si;
                        while (j < AndRuleInstruction.this.rules.length) {
                            AndRuleInstruction.this.rules[j].doExecute(g, curBindings);
                            ++j;
                        }
                    }

                    public String toString() {
                        StringBuilder b = new StringBuilder();
                        b.append("AndRuleInstruction");
                        IRuleInstruction[] iRuleInstructionArray = AndRuleInstruction.this.rules;
                        int n = AndRuleInstruction.this.rules.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRuleInstruction i = iRuleInstructionArray[n2];
                            i.toString(b, 2);
                            ++n2;
                        }
                        return b.toString();
                    }
                };
            }
            ++i;
        }
        return null;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        IRuleInstruction[] iRuleInstructionArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRuleInstruction rule = iRuleInstructionArray[n2];
            rule.doExecute(g, bindings);
            ++n2;
        }
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        IRuleInstruction[] iRuleInstructionArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRuleInstruction r = iRuleInstructionArray[n2];
            r.collectVariables(reads, writes);
            ++n2;
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        IRuleInstruction[] iRuleInstructionArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRuleInstruction r = iRuleInstructionArray[n2];
            r.mapVariables(map);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        IRuleInstruction[] iRuleInstructionArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRuleInstruction rule = iRuleInstructionArray[n2];
            rule.toString(b, indent);
            ++n2;
        }
    }
}

