/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.BinaryQueryHash;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;

public class BinaryQueryHashMap<Procedure>
extends BinaryQueryHash<Procedure> {
    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        return capacity;
    }

    public BinaryQuery<Procedure> put(long id, BinaryQuery<Procedure> value) {
        BinaryQuery previous = null;
        int index = this.insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._set[index];
            isNewMapping = false;
            new Exception().printStackTrace();
            throw new Error("Duplicate entry in BinaryQueryHashMap2 " + value);
        }
        BinaryQuery oldKey = this._set[index];
        this._set[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        BinaryQuery[] oldKeys = this._set;
        this._set = (BinaryQuery[])Array.newInstance(BinaryQuery.class, newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == this.REMOVED) continue;
            BinaryQuery o = oldKeys[i];
            int index = this.insertionIndex(o.id);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
        }
    }

    public BinaryQuery<Procedure> get(long id) {
        int index = this.index(id);
        return index < 0 ? null : this._set[index];
    }

    public Object remove(long id) {
        BinaryQuery prev = null;
        int index = this.index(id);
        if (index >= 0) {
            prev = this._set[index];
            this.removeAt(index);
        }
        return prev;
    }

    public final void values(int level, CacheCollectionResult result) {
        int i = this._set.length;
        while (i-- > 0) {
            BinaryQuery entry = this._set[i];
            if (entry == null || entry == this.REMOVED || entry.getLevel() > level) continue;
            result.add(entry);
        }
    }

    public final ArrayList<CacheEntry> values() {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == null || this._set[i] == this.REMOVED) continue;
            result.add(this._set[i]);
        }
        return result;
    }

    public final <T extends BinaryQuery> ArrayList<T> values(int r1) {
        ArrayList<BinaryQuery> result = new ArrayList<BinaryQuery>();
        int i = this._set.length;
        while (i-- > 0) {
            BinaryQuery e;
            if (this._set[i] == null || this._set[i] == this.REMOVED || (e = this._set[i]).r1() != r1) continue;
            result.add(e);
        }
        return result;
    }
}

