/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.parser;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;

public abstract class SCLParser {
    public static final boolean TRACE = false;
    private static final int INITIAL_CAPACITY = 16;
    private static final int STATE_COUNT = 363;
    private static final int TERMINAL_COUNT = 86;
    private static final int NONTERMINAL_COUNT = 52;
    private static final int PRODUCT_COUNT = 139;
    private static final int[] ACTION_ROW_ID = new int[363];
    private static final int[] ACTION_COLUMN_ID = new int[86];
    private static final short[] ACTION_TABLE = new short[6765];
    private static final int[] ERROR_TABLE = new int[976];
    private static final int[] GOTO_ROW_ID = new int[363];
    private static final int[] GOTO_COLUMN_ID = new int[52];
    private static final short[] GOTO_TABLE = new short[1953];
    private static final int[] PRODUCT_LHS = new int[139];
    private static final short STATE_MASK = 4095;
    private static final short REDUCE_MASK = Short.MIN_VALUE;
    private static final short POP_MASK = 16384;
    private static final short PUSH_MASK = 8192;
    private static final short ERROR_ACTION = -1;
    private static final short ACCEPT_ACTION = -2;
    public static final String[] TERMINAL_NAMES = new String[]{"SEMICOLON", "LBRACE", "RBRACE", "MODULE", "COMMA", "HASTYPE", "DATA", "ID", "EQUALS", "BAR", "TYPE", "CLASS", "WHERE", "INSTANCE", "DERIVING", "BEGIN_STRING", "END_STRING", "ANNOTATION_ID", "INFIX", "INFIXL", "INFIXR", "INTEGER", "IMPORTJAVA", "EFFECT", "RULE", "ABSTRACT_RULE", "EXTENDS", "MAPPING_RELATION", "FOLLOWS", "RULESET", "IMPORT", "INCLUDE", "AS", "LPAREN", "RPAREN", "HIDING", "ARROW", "COLON", "MINUS", "SYMBOL", "LESS", "GREATER", "SEPARATED_DOT", "ESCAPED_ID", "LAMBDA", "LAMBDA_MATCH", "LET", "IF", "MATCH", "DO", "MDO", "EDO", "ENFORCE", "BLANK", "FLOAT", "LBRACKET", "ESCAPED_SYMBOL", "CHAR", "WHEN", "ATTACHED_HASH", "SELECT", "SELECT_FIRST", "SELECT_DISTINCT", "TRANSFORMATION", "EQ", "CHR_SELECT", "ATTACHED_DOT", "IN", "THEN", "ELSE", "WITH", "RBRACKET", "DOTDOT", "AT", "SUSPEND_STRING", "CONTINUE_STRING", "BINDS", "IMPLIES", "THEN_AFTER_WHEN", "CONSTRAINT", "BY", "QUERY_OP", "FORALL", "COMMENT", "EOL", "EOF"};
    public static final String[] NONTERMINAL_NAMES = new String[]{"module", "commands", "import", "type", "exp", "equationBlock", "declaration", "command", "statement", "declarations", "field", "var", "bexp", "rhs", "constructor", "context", "fundeps", "atype", "aexp", "ruleDeclarations", "statements", "importSpec", "importItem", "fieldDeclaration", "guardedExpEq", "fundep", "ruleDeclaration", "query", "lexp", "symbol", "faexp", "accessor", "case", "queryBlock", "verboseChrQuery", "stringLiteral", "symbolWithoutMinus", "listQualifier", "chrQuery", "chrQueryPart", "caseRhs", "guardedExpArrow", "equation", "etype", "btype", "dummy", "init$6", "init$5", "init$4", "init$3", "init$2", "init$1"};
    private Object[] symbolStack = new Object[16];
    private int symbolStackLength = 0;
    private int[] stateStack = new int[16];
    private int[] symbolStackPositionStack = new int[16];
    private int stateStackLength = 0;
    private int reductionLength;

    static {
        try {
            DataInputStream input = new DataInputStream(SCLParser.class.getResourceAsStream("SCLParser.dat"));
            int i = 0;
            while (i < ACTION_ROW_ID.length) {
                SCLParser.ACTION_ROW_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < ACTION_COLUMN_ID.length) {
                SCLParser.ACTION_COLUMN_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < ACTION_TABLE.length) {
                SCLParser.ACTION_TABLE[i] = input.readShort();
                ++i;
            }
            i = 0;
            while (i < ERROR_TABLE.length) {
                SCLParser.ERROR_TABLE[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_ROW_ID.length) {
                SCLParser.GOTO_ROW_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_COLUMN_ID.length) {
                SCLParser.GOTO_COLUMN_ID[i] = input.readInt();
                ++i;
            }
            i = 0;
            while (i < GOTO_TABLE.length) {
                SCLParser.GOTO_TABLE[i] = input.readShort();
                ++i;
            }
            i = 0;
            while (i < PRODUCT_LHS.length) {
                SCLParser.PRODUCT_LHS[i] = input.readInt();
                ++i;
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static short getAction(int state, int symbol) {
        int id = 86 * state + symbol;
        if ((ERROR_TABLE[id >> 5] >> (id & 0x1F) & 1) != 0) {
            return -1;
        }
        return ACTION_TABLE[ACTION_ROW_ID[state] + ACTION_COLUMN_ID[symbol]];
    }

    private static short getGoto(int state, int symbol) {
        return GOTO_TABLE[GOTO_ROW_ID[state] + GOTO_COLUMN_ID[symbol]];
    }

    protected abstract Token nextToken();

    protected int length() {
        return this.reductionLength;
    }

    protected Object get(int i) {
        if (i < 0 || i >= this.reductionLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.symbolStack[this.symbolStackLength + i];
    }

    private String parseErrorDescription(int state, Token token, int tokenId) {
        StringBuilder b = new StringBuilder();
        b.append("Unexpected token '").append(token).append("' (").append(TERMINAL_NAMES[tokenId]).append("). Expected one of ");
        ArrayList<String> possibleTerminals = new ArrayList<String>();
        int i = 0;
        while (i < 86) {
            if (SCLParser.getAction(state, i) != -1) {
                possibleTerminals.add(TERMINAL_NAMES[i]);
            }
            ++i;
        }
        Collections.sort(possibleTerminals);
        i = 0;
        while (i < possibleTerminals.size()) {
            if (i > 0) {
                b.append(", ");
            }
            b.append((String)possibleTerminals.get(i));
            ++i;
        }
        b.append('.');
        return b.toString();
    }

    protected abstract RuntimeException syntaxError(Token var1, String var2);

    private static String describeAction(boolean isGoto, int action) {
        if (action == -1) {
            return "ERROR";
        }
        if (action == -2) {
            return "ACCEPT";
        }
        StringBuilder b = new StringBuilder();
        if (isGoto) {
            b.append("GOTO ");
        } else if ((action & Short.MIN_VALUE) != 0) {
            action ^= Short.MIN_VALUE;
            b.append("REDUCE");
        } else {
            b.append("SHIFT");
        }
        if ((action & 0x4000) != 0) {
            action ^= 0x4000;
            b.append(" POP");
        }
        if ((action & 0x2000) != 0) {
            action ^= 0x2000;
            b.append(" PUSH");
        }
        b.append(' ').append(action);
        return b.toString();
    }

    private void printState(int state) {
        System.out.print("state=" + state + ":");
        int i = this.symbolStackLength - 1;
        int j = this.stateStackLength - 1;
        while (i >= 0) {
            Object s = this.symbolStack[i];
            if (s instanceof Token) {
                System.out.print(" " + TERMINAL_NAMES[((Token)s).id]);
            } else if (s == null) {
                System.out.print(" null");
            } else {
                System.out.print(" " + s.getClass().getSimpleName());
            }
            while (j >= 0 && this.symbolStackPositionStack[j] == i) {
                System.out.print(" (" + this.stateStack[j--] + ")");
            }
            --i;
        }
        System.out.println();
    }

    private Object parse(int state) {
        while (true) {
            short action;
            Token token = this.nextToken();
            int tokenId = token.id;
            while (((action = SCLParser.getAction(state, tokenId)) & Short.MIN_VALUE) != 0) {
                if (action == -2) {
                    return this.symbolStack[this.symbolStackLength - 1];
                }
                if (action == -1) {
                    throw this.syntaxError(token, this.parseErrorDescription(state, token, tokenId));
                }
                int popAmount = action >>> 13 & 3;
                this.stateStackLength -= popAmount;
                action = (short)(action & 0xFFF);
                int reductionBegin = this.symbolStackPositionStack[--this.stateStackLength];
                this.reductionLength = this.symbolStackLength - reductionBegin;
                this.symbolStackLength = reductionBegin;
                if (this.symbolStackLength == this.symbolStack.length) {
                    this.symbolStack = Arrays.copyOf(this.symbolStack, this.symbolStackLength * 2);
                }
                Object symbol = this.reduce(action);
                this.postReduce(symbol);
                this.symbolStack[this.symbolStackLength] = symbol;
                state = this.stateStack[this.stateStackLength];
                action = SCLParser.getGoto(state, PRODUCT_LHS[action]);
                if ((action & 0x4000) != 0) {
                    --this.stateStackLength;
                }
                if ((action & 0x2000) != 0) {
                    if (this.stateStackLength == this.stateStack.length) {
                        this.stateStack = Arrays.copyOf(this.stateStack, this.stateStackLength * 2);
                        this.symbolStackPositionStack = Arrays.copyOf(this.symbolStackPositionStack, this.stateStackLength * 2);
                    }
                    this.symbolStackPositionStack[this.stateStackLength] = this.symbolStackLength;
                    this.stateStack[this.stateStackLength++] = state;
                }
                state = action & 0xFFF;
                ++this.symbolStackLength;
            }
            if ((action & 0x4000) != 0) {
                --this.stateStackLength;
            }
            if ((action & 0x2000) != 0) {
                if (this.stateStackLength == this.stateStack.length) {
                    this.stateStack = Arrays.copyOf(this.stateStack, this.stateStackLength * 2);
                    this.symbolStackPositionStack = Arrays.copyOf(this.symbolStackPositionStack, this.stateStackLength * 2);
                }
                this.symbolStackPositionStack[this.stateStackLength] = this.symbolStackLength;
                this.stateStack[this.stateStackLength++] = state;
            }
            state = action & 0xFFF;
            if (this.symbolStackLength == this.symbolStack.length) {
                this.symbolStack = Arrays.copyOf(this.symbolStack, this.symbolStackLength * 2);
            }
            this.symbolStack[this.symbolStackLength++] = token;
        }
    }

    public Object parseModule() {
        return this.parse(0);
    }

    public Object parseCommands() {
        return this.parse(347);
    }

    public Object parseImport() {
        return this.parse(355);
    }

    public Object parseType() {
        return this.parse(357);
    }

    public Object parseExp() {
        return this.parse(359);
    }

    public Object parseEquationBlock() {
        return this.parse(361);
    }

    /*
     * Unable to fully structure code
     */
    protected Object reduce(int productionId) {
        try {
            switch (productionId) {
                case 0: {
                    return this.reduceModule();
                }
                case 1: {
                    return this.reduceOneCommand();
                }
                case 2: {
                    return this.reduceManyCommands();
                }
                case 3: {
                    return this.reduceImport();
                }
                case 4: {
                    return this.reduceArrow();
                }
                case 5: {
                    return this.reduceLocalTypeAnnotation();
                }
                case 6: {
                    return this.reduceEquationBlock();
                }
                case 7: {
                    return this.reduceModuleHeader();
                }
                case 8: {
                    return this.reduceTypeAnnotation();
                }
                case 9: {
                    return this.reduceValueDefinition();
                }
                case 10: {
                    return this.reduceDataDefinition();
                }
                case 11: {
                    return this.reduceTypeDefinition();
                }
                case 12: {
                    return this.reduceClassDefinition();
                }
                case 13: {
                    return this.reduceInstanceDefinition();
                }
                case 14: {
                    return this.reduceDerivingInstanceDefinition();
                }
                case 15: {
                    return this.reduceDocumentationString();
                }
                case 16: {
                    return this.reduceAnnotation();
                }
                case 17: {
                    return this.reducePrecedenceDefinition();
                }
                case 18: {
                    return this.reduceJustImport();
                }
                case 19: {
                    return this.reduceImportJava();
                }
                case 20: {
                    return this.reduceEffectDefinition();
                }
                case 21: {
                    return this.reduceRuleDefinition();
                }
                case 22: {
                    return this.reduceMappingRelationDefinition();
                }
                case 23: {
                    return this.reduceRelationDefinition();
                }
                case 24: {
                    return this.reduceRulesetDefinition();
                }
                case 25: {
                    return this.reduceStatementCommand();
                }
                case 26: {
                    return this.reduceImportCommand();
                }
                case 27: {
                    return this.reduceGuardStatement();
                }
                case 28: {
                    return this.reduceLetStatement();
                }
                case 29: {
                    return this.reduceBindStatement();
                }
                case 30: {
                    return this.reduceRuleStatement();
                }
                case 31: {
                    return this.reduceCHRStatement();
                }
                case 32: {
                    return this.reduceVerboseCHRStatement();
                }
                case 33: {
                    return this.reduceConstraintStatement();
                }
                case 34: {
                    return this.reduceLocalInclude();
                }
                case 35: {
                    return this.reduceDeclarations();
                }
                case 36: {
                    return this.reduceField();
                }
                case 37: {
                    return this.reduceFieldShorthand();
                }
                case 38: {
                    return this.reduceWildcard();
                }
                case 39: {
                    return this.reduceVarId();
                }
                case 40: {
                    return this.reduceEscapedSymbol();
                }
                case 41: {
                    return this.reduceTupleConstructor();
                }
                case 42: {
                    return this.reduceBinary();
                }
                case 43: {
                    return this.reduceSimpleRhs();
                }
                case 44: {
                    return this.reduceGuardedRhs();
                }
                case 45: {
                    return this.reduceConstructor();
                }
                case 46: {
                    return this.reduceRecordConstructor();
                }
                case 47: {
                    return this.reduceContext();
                }
                case 48: {
                    return this.reduceFundeps();
                }
                case 49: {
                    return this.reduceTypeVar();
                }
                case 50: {
                    return this.reduceTupleType();
                }
                case 51: {
                    return this.reduceListType();
                }
                case 52: {
                    return this.reduceListTypeConstructor();
                }
                case 53: {
                    return this.reduceTupleTypeConstructor();
                }
                case 54: {
                    return this.reduceLambda();
                }
                case 55: {
                    return this.reduceLambdaMatch();
                }
                case 56: {
                    return this.reduceLet();
                }
                case 57: {
                    return this.reduceIf();
                }
                case 58: {
                    return this.reduceMatch();
                }
                case 59: {
                    return this.reduceDo();
                }
                case 60: {
                    return this.reduceSelect();
                }
                case 61: {
                    return this.reduceCHRSelect();
                }
                case 62: {
                    return this.reduceEnforce();
                }
                case 63: {
                    return this.reduceVar();
                }
                case 64: {
                    return this.reduceHashedId();
                }
                case 65: {
                    return this.reduceBlank();
                }
                case 66: {
                    return this.reduceInteger();
                }
                case 67: {
                    return this.reduceFloat();
                }
                case 68: {
                    return this.reduceString();
                }
                case 69: {
                    return this.reduceChar();
                }
                case 70: {
                    return this.reduceTuple();
                }
                case 71: {
                    return this.reduceViewPattern();
                }
                case 72: {
                    return this.reduceRightSection();
                }
                case 73: {
                    return this.reduceLeftSection();
                }
                case 74: {
                    return this.reduceListLiteral();
                }
                case 75: {
                    return this.reduceRange();
                }
                case 76: {
                    return this.reduceListComprehension();
                }
                case 77: {
                    return this.reduceAs();
                }
                case 78: {
                    return this.reduceRecord();
                }
                case 79: {
                    return this.reduceTransformation();
                }
                case 80: {
                    return this.reduceEq();
                }
                case 81: {
                    return this.reduceRuleDeclarations();
                }
                case 82: {
                    return this.reduceStatements();
                }
                case 83: {
                    return this.reduceImportShowing();
                }
                case 84: {
                    return this.reduceImportHiding();
                }
                case 85: {
                    return this.reduceImportValueItem();
                }
                case 86: {
                    return this.reduceFieldDescription();
                }
                case 87: {
                    return this.reduceGuardedExpEq();
                }
                case 88: {
                    return this.reduceFundep();
                }
                case 89: {
                    return this.reduceQueryRuleDeclaration();
                }
                case 90: {
                    return this.reduceAnnotation();
                }
                case 91: {
                    return this.reduceGuardQuery();
                }
                case 92: {
                    return this.reduceEqualsQuery();
                }
                case 93: {
                    return this.reduceBindQuery();
                }
                case 94: {
                    return this.reduceCompositeQuery();
                }
                case 95: {
                    return this.reduceApply();
                }
                case 96: {
                    return this.reduceSymbol();
                }
                case 97: {
                    return this.reduceEscapedId();
                }
                case 98: {
                    return this.reduceMinus();
                }
                case 99: {
                    return this.reduceLess();
                }
                case 100: {
                    return this.reduceGreater();
                }
                case 101: {
                    return this.reduceDot();
                }
                case 102: {
                    return this.reduceFieldAccess();
                }
                case 103: {
                    return this.reduceIdAccessor();
                }
                case 104: {
                    return this.reduceStringAccessor();
                }
                case 105: {
                    return this.reduceExpAccessor();
                }
                case 106: {
                    return this.reduceCase();
                }
                case 107: {
                    return this.reduceQueryBlock();
                }
                case 108: {
                    return this.reduceVerboseCHRConjunction();
                }
                case 109: {
                    return this.reduceStringLiteral();
                }
                case 110: {
                    return this.reduceSymbol();
                }
                case 111: {
                    return this.reduceEscapedId();
                }
                case 112: {
                    return this.reduceLess();
                }
                case 113: {
                    return this.reduceGreater();
                }
                case 114: {
                    return this.reduceDot();
                }
                case 115: {
                    return this.reduceGuardQualifier();
                }
                case 116: {
                    return this.reduceLetQualifier();
                }
                case 117: {
                    return this.reduceBindQualifier();
                }
                case 118: {
                    return this.reduceThenQualifier();
                }
                case 119: {
                    return this.reduceCHRConjunction();
                }
                case 120: {
                    return this.reduceCHRAtom();
                }
                case 121: {
                    return this.reduceCHREquals();
                }
                case 122: {
                    return this.reduceCHRBinds();
                }
                case 123: {
                    return this.reduceSimpleCaseRhs();
                }
                case 124: {
                    return this.reduceGuardedCaseRhs();
                }
                case 125: {
                    return this.reduceGuardedExpArrow();
                }
                case 126: {
                    return this.reduceGuardEquation();
                }
                case 127: {
                    return this.reduceBasicEquation();
                }
                case 128: {
                    return this.reduceEffect();
                }
                case 129: {
                    return this.reduceJustEtype();
                }
                case 130: {
                    return this.reduceForAll();
                }
                case 131: {
                    return this.reduceApplyType();
                }
                case 132: {
                    return this.reduceDummy();
                }
            }
            throw new RuntimeException("Internal parser error.");
        }
        catch (SCLSyntaxErrorException e) {
            b = new StringBuilder();
            b.append("Failed to reduce");
            i = 0;
            ** while (i < this.length())
        }
lbl-1000:
        // 1 sources

        {
            obj = this.get(i);
            b.append("\n    (").append(i).append(") \"").append(obj).append('\"');
            if (obj instanceof Token) {
                b.append(" (").append(SCLParser.TERMINAL_NAMES[((Token)obj).id]).append(")");
            } else {
                b.append(" [").append(obj.getClass().getSimpleName()).append("]");
            }
            ++i;
            continue;
        }
lbl287:
        // 1 sources

        throw new RuntimeException(b.toString(), e);
    }

    protected abstract Object reduceModule();

    protected abstract Object reduceOneCommand();

    protected abstract Object reduceManyCommands();

    protected abstract Object reduceImport();

    protected abstract Object reduceArrow();

    protected abstract Object reduceLocalTypeAnnotation();

    protected abstract Object reduceEquationBlock();

    protected abstract Object reduceModuleHeader();

    protected abstract Object reduceTypeAnnotation();

    protected abstract Object reduceValueDefinition();

    protected abstract Object reduceDataDefinition();

    protected abstract Object reduceTypeDefinition();

    protected abstract Object reduceClassDefinition();

    protected abstract Object reduceInstanceDefinition();

    protected abstract Object reduceDerivingInstanceDefinition();

    protected abstract Object reduceDocumentationString();

    protected abstract Object reduceAnnotation();

    protected abstract Object reducePrecedenceDefinition();

    protected abstract Object reduceJustImport();

    protected abstract Object reduceImportJava();

    protected abstract Object reduceEffectDefinition();

    protected abstract Object reduceRuleDefinition();

    protected abstract Object reduceMappingRelationDefinition();

    protected abstract Object reduceRelationDefinition();

    protected abstract Object reduceRulesetDefinition();

    protected abstract Object reduceStatementCommand();

    protected abstract Object reduceImportCommand();

    protected abstract Object reduceGuardStatement();

    protected abstract Object reduceLetStatement();

    protected abstract Object reduceBindStatement();

    protected abstract Object reduceRuleStatement();

    protected abstract Object reduceCHRStatement();

    protected abstract Object reduceVerboseCHRStatement();

    protected abstract Object reduceConstraintStatement();

    protected abstract Object reduceLocalInclude();

    protected abstract Object reduceDeclarations();

    protected abstract Object reduceField();

    protected abstract Object reduceFieldShorthand();

    protected abstract Object reduceWildcard();

    protected abstract Object reduceVarId();

    protected abstract Object reduceEscapedSymbol();

    protected abstract Object reduceTupleConstructor();

    protected abstract Object reduceBinary();

    protected abstract Object reduceSimpleRhs();

    protected abstract Object reduceGuardedRhs();

    protected abstract Object reduceConstructor();

    protected abstract Object reduceRecordConstructor();

    protected abstract Object reduceContext();

    protected abstract Object reduceFundeps();

    protected abstract Object reduceTypeVar();

    protected abstract Object reduceTupleType();

    protected abstract Object reduceListType();

    protected abstract Object reduceListTypeConstructor();

    protected abstract Object reduceTupleTypeConstructor();

    protected abstract Object reduceLambda();

    protected abstract Object reduceLambdaMatch();

    protected abstract Object reduceLet();

    protected abstract Object reduceIf();

    protected abstract Object reduceMatch();

    protected abstract Object reduceDo();

    protected abstract Object reduceSelect();

    protected abstract Object reduceCHRSelect();

    protected abstract Object reduceEnforce();

    protected abstract Object reduceVar();

    protected abstract Object reduceHashedId();

    protected abstract Object reduceBlank();

    protected abstract Object reduceInteger();

    protected abstract Object reduceFloat();

    protected abstract Object reduceString();

    protected abstract Object reduceChar();

    protected abstract Object reduceTuple();

    protected abstract Object reduceViewPattern();

    protected abstract Object reduceRightSection();

    protected abstract Object reduceLeftSection();

    protected abstract Object reduceListLiteral();

    protected abstract Object reduceRange();

    protected abstract Object reduceListComprehension();

    protected abstract Object reduceAs();

    protected abstract Object reduceRecord();

    protected abstract Object reduceTransformation();

    protected abstract Object reduceEq();

    protected abstract Object reduceRuleDeclarations();

    protected abstract Object reduceStatements();

    protected abstract Object reduceImportShowing();

    protected abstract Object reduceImportHiding();

    protected abstract Object reduceImportValueItem();

    protected abstract Object reduceFieldDescription();

    protected abstract Object reduceGuardedExpEq();

    protected abstract Object reduceFundep();

    protected abstract Object reduceQueryRuleDeclaration();

    protected abstract Object reduceGuardQuery();

    protected abstract Object reduceEqualsQuery();

    protected abstract Object reduceBindQuery();

    protected abstract Object reduceCompositeQuery();

    protected abstract Object reduceApply();

    protected abstract Object reduceSymbol();

    protected abstract Object reduceEscapedId();

    protected abstract Object reduceMinus();

    protected abstract Object reduceLess();

    protected abstract Object reduceGreater();

    protected abstract Object reduceDot();

    protected abstract Object reduceFieldAccess();

    protected abstract Object reduceIdAccessor();

    protected abstract Object reduceStringAccessor();

    protected abstract Object reduceExpAccessor();

    protected abstract Object reduceCase();

    protected abstract Object reduceQueryBlock();

    protected abstract Object reduceVerboseCHRConjunction();

    protected abstract Object reduceStringLiteral();

    protected abstract Object reduceGuardQualifier();

    protected abstract Object reduceLetQualifier();

    protected abstract Object reduceBindQualifier();

    protected abstract Object reduceThenQualifier();

    protected abstract Object reduceCHRConjunction();

    protected abstract Object reduceCHRAtom();

    protected abstract Object reduceCHREquals();

    protected abstract Object reduceCHRBinds();

    protected abstract Object reduceSimpleCaseRhs();

    protected abstract Object reduceGuardedCaseRhs();

    protected abstract Object reduceGuardedExpArrow();

    protected abstract Object reduceGuardEquation();

    protected abstract Object reduceBasicEquation();

    protected abstract Object reduceEffect();

    protected abstract Object reduceJustEtype();

    protected abstract Object reduceForAll();

    protected abstract Object reduceApplyType();

    protected abstract Object reduceDummy();

    protected void postReduce(Object reduced) {
    }
}

