/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.interpreted;

import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.runtime.function.Function;

public class IConstant
implements IExpression {
    private final Object value;

    public IConstant(Object value) {
        this.value = value;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof Number || this.value instanceof Function) {
            return this.value.toString();
        }
        if (this.value instanceof String) {
            return "\"" + this.value.toString() + "\"";
        }
        if (this.value instanceof Class) {
            return ((Class)this.value).getSimpleName();
        }
        return "(" + this.value.toString() + "::" + this.value.getClass().getSimpleName() + ")";
    }
}

