/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpression;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Throw;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class GuardedExpressionGroup
extends Expression {
    public GuardedExpression[] expressions;

    public GuardedExpressionGroup(GuardedExpression[] expressions) {
        this.expressions = expressions;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.expressions[0].value.getType());
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        CodeWriter success = w.createBlock(this.getType());
        IVal result = success.getParameters()[0];
        CodeWriter failure = w.createBlock();
        this.compile(context, w, success.getContinuation(), failure.getContinuation());
        w.continueAs(success);
        failure.throw_(this.location, Throw.MatchingException, "Matching failure at: " + this.toString());
        return result;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        GuardedExpression[] guardedExpressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            GuardedExpression expression = guardedExpressionArray[n2];
            int i = 0;
            while (i < expression.guards.length) {
                expression.guards[i] = expression.guards[i].simplify(context);
                ++i;
            }
            expression.value = expression.value.simplify(context);
            ++n2;
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        GuardedExpression[] guardedExpressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            GuardedExpression expression = guardedExpressionArray[n2];
            int i = 0;
            while (i < expression.guards.length) {
                expression.guards[i] = expression.guards[i].resolve(context);
                ++i;
            }
            expression.value = expression.value.resolve(context);
            ++n2;
        }
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        GuardedExpression[] guardedExpressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            GuardedExpression expression = guardedExpressionArray[n2];
            int i = 0;
            while (i < expression.guards.length) {
                expression.guards[i] = expression.guards[i].checkType(context, Types.BOOLEAN);
                ++i;
            }
            expression.value = expression.value.checkType(context, requiredType);
            ++n2;
        }
        return this;
    }

    public void compile(CompilationContext context, CodeWriter firstWriter, ICont success, ICont lastFailure) {
        CodeWriter[] writers = new CodeWriter[this.expressions.length];
        ICont[] failures = new ICont[this.expressions.length];
        writers[0] = firstWriter;
        failures[this.expressions.length - 1] = lastFailure;
        int i = 1;
        while (i < this.expressions.length) {
            CodeWriter writer;
            writers[i] = writer = firstWriter.createBlock();
            failures[i - 1] = writer.getContinuation();
            ++i;
        }
        i = 0;
        while (i < this.expressions.length) {
            CodeWriter w = writers[i];
            ICont failure = failures[i];
            Expression[] expressionArray = this.expressions[i].guards;
            int n = this.expressions[i].guards.length;
            int n2 = 0;
            while (n2 < n) {
                Expression guard = expressionArray[n2];
                CodeWriter nextW = w.createBlock();
                w.if_(guard.toVal(context, w), nextW.getContinuation(), failure);
                w = nextW;
                ++n2;
            }
            w.jump(success, this.expressions[i].value.toVal(context, w));
            ++i;
        }
    }

    @Override
    public Expression replace(ReplaceContext context) {
        GuardedExpression[] newExpressions = new GuardedExpression[this.expressions.length];
        int i = 0;
        while (i < this.expressions.length) {
            newExpressions[i] = this.expressions[i].replace(context);
            ++i;
        }
        return new GuardedExpressionGroup(newExpressions);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            GuardedExpression[] guardedExpressionArray = this.expressions;
            int n = this.expressions.length;
            int n2 = 0;
            while (n2 < n) {
                GuardedExpression expression = guardedExpressionArray[n2];
                expression.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return this.expressions[0].value.getSyntacticFunctionArity();
    }
}

