/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants.generic;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.constants.generic.MethodRef;
import org.simantics.scl.compiler.constants.generic.OutputFilter;
import org.simantics.scl.compiler.constants.generic.ParameterStackItem;
import org.simantics.scl.compiler.constants.generic.StackItem;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public class CallJava
extends FunctionValue {
    StackItem[] stackItems;
    MethodRef methodRef;
    OutputFilter filter;
    public static final int INCOMPARABLE = -2;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;

    public CallJava(TVar[] typeParameters, Type effect, Type returnType, Type[] parameterTypes, StackItem[] stackItems, MethodRef methodRef, OutputFilter filter) {
        super(typeParameters, effect, returnType, parameterTypes);
        if (stackItems == null) {
            stackItems = new StackItem[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                stackItems[i] = new ParameterStackItem(i, parameterTypes[i]);
                ++i;
            }
        }
        this.stackItems = stackItems;
        this.methodRef = methodRef;
        this.filter = filter;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        this.methodRef.invoke(mb, this.stackItems, parameters);
        if (this.filter != null) {
            this.filter.filter(mb);
        }
        return this.getReturnType();
    }

    public MethodRef getMethodRef() {
        return this.methodRef;
    }

    public String toString() {
        return this.methodRef.getName();
    }

    public int compareTo(JavaReferenceValidator validator, CallJava other) {
        TypeDesc[] ps2;
        MethodRef m1 = this.methodRef;
        MethodRef m2 = other.methodRef;
        TypeDesc[] ps1 = m1.getParameterTypes();
        if (ps1.length != (ps2 = m2.getParameterTypes()).length) {
            return -2;
        }
        boolean lessOrEqual = true;
        boolean greaterOrEqual = true;
        int i = 0;
        while (i < ps1.length) {
            if (!ps1[i].equals(ps2[i])) {
                if (!validator.isAssignableFrom(ps1[i], ps2[i])) {
                    lessOrEqual = false;
                }
                if (!validator.isAssignableFrom(ps2[i], ps1[i])) {
                    greaterOrEqual = false;
                }
            }
            ++i;
        }
        if (lessOrEqual) {
            if (greaterOrEqual) {
                return 0;
            }
            return -1;
        }
        if (greaterOrEqual) {
            return 1;
        }
        return -2;
    }

    @Override
    public void prepare(MethodBuilder mb) {
        StackItem[] stackItemArray = this.stackItems;
        int n = this.stackItems.length;
        int n2 = 0;
        while (n2 < n) {
            StackItem item = stackItemArray[n2];
            item.prepare(mb);
            ++n2;
        }
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        if (this.parameterTypes.length != 0) {
            super.deconstruct(mb, parameter, success, failure);
        }
        this.push(mb);
        mb.push(parameter, this.getType());
        mb.invokeVirtual(TypeDesc.OBJECT, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        mb.ifZeroComparisonBranch(failure, "==");
        mb.jump(success);
    }
}

