/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.CompilationTimer;
import org.simantics.scl.compiler.compilation.EnvironmentOfModule;
import org.simantics.scl.compiler.compilation.NameExistenceChecks;
import org.simantics.scl.compiler.compilation.SupplementedValueType;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.constants.JavaTypeInstanceConstructor;
import org.simantics.scl.compiler.constants.SCLConstructor;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.constants.generic.CallJava;
import org.simantics.scl.compiler.constants.generic.ClassRef;
import org.simantics.scl.compiler.constants.generic.ConvertToListFilter;
import org.simantics.scl.compiler.constants.generic.MethodRef;
import org.simantics.scl.compiler.constants.generic.OutputFilter;
import org.simantics.scl.compiler.constants.generic.ParameterStackItem;
import org.simantics.scl.compiler.constants.generic.Pop2OutputFilter;
import org.simantics.scl.compiler.constants.generic.PopOutputFilter;
import org.simantics.scl.compiler.constants.generic.StackItem;
import org.simantics.scl.compiler.constants.generic.ThreadLocalStackItem;
import org.simantics.scl.compiler.constants.singletons.SafeCoerce;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EGetConstraint;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EPreCHRRulesetConstructor;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.annotations.AnnotationUtils;
import org.simantics.scl.compiler.elaboration.fundeps.Fundep;
import org.simantics.scl.compiler.elaboration.java.JavaMethodDeclaration;
import org.simantics.scl.compiler.elaboration.macros.StandardMacroRule;
import org.simantics.scl.compiler.elaboration.modules.DeprecatedProperty;
import org.simantics.scl.compiler.elaboration.modules.DerivedProperty;
import org.simantics.scl.compiler.elaboration.modules.InlineProperty;
import org.simantics.scl.compiler.elaboration.modules.MethodImplementation;
import org.simantics.scl.compiler.elaboration.modules.PrivateProperty;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.pre.QPreGuard;
import org.simantics.scl.compiler.elaboration.relations.ConcreteRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.SectionName;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.EnvironmentFactory;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.errors.ErrorSeverity;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.internal.codegen.effects.ThreadLocalVariable;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidatorFactory;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.deriving.InstanceDeriver;
import org.simantics.scl.compiler.internal.deriving.InstanceDerivers;
import org.simantics.scl.compiler.internal.elaboration.profiling.BranchPointInjector;
import org.simantics.scl.compiler.internal.elaboration.utils.StronglyConnectedComponents;
import org.simantics.scl.compiler.internal.header.ModuleHeader;
import org.simantics.scl.compiler.internal.parsing.declarations.ConstructorAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DClassAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDataAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DEffectAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DFixityAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DMappingRelationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRelationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRuleAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRulesetAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DTypeAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDClassAst;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.internal.parsing.translation.RelationRepository;
import org.simantics.scl.compiler.internal.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.InvalidModulePathException;
import org.simantics.scl.compiler.module.ModuleUtils;
import org.simantics.scl.compiler.module.debug.ModuleDebugInfo;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.KMetaVar;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.runtime.profiling.BranchPoint;

public class Elaboration {
    private final CompilationContext compilationContext;
    private final ErrorLog errorLog;
    private final String moduleName;
    private final ModuleHeader moduleHeader;
    private final ArrayList<ImportDeclaration> importsAst;
    private final JavaReferenceValidatorFactory jrvFactory;
    final JavaReferenceValidator<Object, Object, Object, Object> javaReferenceValidator;
    private final ValueRepository valueDefinitionsAst;
    private final RelationRepository relationDefinitionsAst;
    ConcreteModule module;
    Environment importedEnvironment;
    ArrayList<SupplementedValueType> supplementedTypeAnnotations;
    JavaTypeTranslator javaTypeTranslator;
    ArrayList<StandardTypeConstructor> dataTypes;
    THashMap<String, ClassRef> classRefs;
    THashMap<String, BranchPoint[]> branchPoints;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    THashMap<String, DRuleAst> ruleAstMap;

    /*
     * Unable to fully structure code
     */
    public Elaboration(CompilationContext compilationContext, CompilationTimer timer, EnvironmentFactory localEnvironmentFactory, String moduleName, ModuleHeader moduleHeader, ArrayList<ImportDeclaration> importsAst, JavaReferenceValidatorFactory jrvFactory, ValueRepository valueDefinitionsAst, RelationRepository relationDefinitionsAst) {
        block11: {
            super();
            this.supplementedTypeAnnotations = new ArrayList<E>();
            this.dataTypes = new ArrayList<E>();
            this.classRefs = new THashMap();
            this.ruleAstMap = new THashMap();
            this.compilationContext = compilationContext;
            this.errorLog = compilationContext.errorLog;
            this.moduleName = moduleName;
            this.moduleHeader = moduleHeader;
            if (moduleName != null) {
                importsAst = Elaboration.processRelativeImports(compilationContext.errorLog, moduleName, importsAst);
            }
            this.importsAst = importsAst;
            this.jrvFactory = jrvFactory;
            v0 = this.javaReferenceValidator = moduleHeader == null || moduleHeader.classLoader == null ? jrvFactory.getDefaultJavaReferenceValidator() : jrvFactory.getJavaReferenceValidator(moduleHeader.classLoader);
            if (this.javaReferenceValidator == null) {
                this.errorLog.log(moduleHeader.classLoaderLocation, "Didn't find the specified class loader.");
            }
            this.valueDefinitionsAst = valueDefinitionsAst;
            this.relationDefinitionsAst = relationDefinitionsAst;
            compilationContext.module = this.module = new ConcreteModule(moduleName);
            compilationContext.moduleRepository = localEnvironmentFactory.getModuleRepository();
            if (moduleHeader != null) {
                if (moduleHeader.defaultLocalName != null) {
                    this.module.setDefaultLocalName(moduleHeader.defaultLocalName);
                }
                if (moduleHeader.deprecated != null) {
                    this.module.setDeprecation(moduleHeader.deprecated);
                }
            }
            try {
                if (timer != null) {
                    timer.suspendTimer();
                }
                this.importedEnvironment = localEnvironmentFactory.createEnvironment(compilationContext, importsAst.toArray(new ImportDeclaration[importsAst.size()]));
                if (timer != null) {
                    timer.continueTimer();
                }
                compilationContext.environment = new EnvironmentOfModule(this.importedEnvironment, this.module);
                break block11;
            }
            catch (ImportFailureException e) {
                ** for (failure : e.failures)
            }
lbl-1000:
            // 1 sources

            {
                this.errorLog.log(new CompilationError(failure.location, failure.toString(), ErrorSeverity.IMPORT_ERROR));
                continue;
            }
lbl38:
            // 1 sources

            return;
        }
        for (ImportDeclaration importAst : importsAst) {
            this.module.addDependency(new ImportDeclaration(importAst.moduleName, importAst.reexport != false ? importAst.localName : null, false, importAst.spec));
        }
        localEnvironmentFactory.addBuiltinDependencies(this.module);
        compilationContext.namingPolicy = new JavaNamingPolicy(moduleName);
    }

    public static ArrayList<ImportDeclaration> processRelativeImports(ErrorLog errorLog, String moduleName, ArrayList<ImportDeclaration> relativeImports) {
        ArrayList<ImportDeclaration> absoluteImports = new ArrayList<ImportDeclaration>(relativeImports.size());
        for (ImportDeclaration relativeImport : relativeImports) {
            if (relativeImport.moduleName.startsWith(".")) {
                try {
                    String absoluteModuleName = ModuleUtils.resolveAbsolutePath(moduleName, relativeImport.moduleName);
                    ImportDeclaration absoluteImport = new ImportDeclaration(relativeImport.location, absoluteModuleName, relativeImport.localName, relativeImport.reexport, relativeImport.spec);
                    absoluteImports.add(absoluteImport);
                }
                catch (InvalidModulePathException e) {
                    if (errorLog == null) continue;
                    errorLog.log(relativeImport.location, e.getMessage());
                }
                continue;
            }
            absoluteImports.add(relativeImport);
        }
        return absoluteImports;
    }

    public void addTypesToEnvironment(ArrayList<DDataAst> dataTypesAst, ArrayList<DTypeAst> typeAliasesAst, ArrayList<DEffectAst> effectsAst, ArrayList<DRulesetAst> rulesetsAst) {
        for (DDataAst dataType : dataTypesAst) {
            dataType.parameterKinds = new Kind[dataType.parameters.length];
            Kind constructorKind = Kinds.STAR;
            int i = dataType.parameters.length - 1;
            while (i >= 0) {
                KMetaVar kind = Kinds.metaVar();
                dataType.parameterKinds[i] = kind;
                constructorKind = Kinds.arrow(kind, constructorKind);
                --i;
            }
            StandardTypeConstructor typeConstructor = new StandardTypeConstructor(Types.con(this.moduleName, dataType.name), constructorKind);
            NameExistenceChecks.checkIfTypeExists(this.errorLog, dataType.location, this.importedEnvironment, dataType.name);
            this.addTypeDescriptor(dataType.location, dataType.name, typeConstructor);
            dataType.typeConstructor = typeConstructor;
        }
        for (DTypeAst typeAlias : typeAliasesAst) {
            TypeAlias alias = new TypeAlias(Types.con(this.moduleName, typeAlias.name), typeAlias.parameters.length);
            NameExistenceChecks.checkIfTypeExists(this.errorLog, typeAlias.location, this.importedEnvironment, typeAlias.name);
            this.addTypeDescriptor(typeAlias.location, typeAlias.name, alias);
        }
        for (DEffectAst effect : effectsAst) {
            EffectConstructor effectConstructor = new EffectConstructor(Types.con(this.moduleName, effect.name));
            effectConstructor.addThreadLocalVariable(new ThreadLocalVariable(effect.variableName, TypeDesc.forClass(effect.threadLocalType)));
            if (!this.module.addEffectConstructor(effect.name, effectConstructor)) continue;
            this.errorLog.log(effect.location, "Effect " + effect.name + " has already been defined in this module.");
        }
        for (DRulesetAst ruleset : rulesetsAst) {
            ruleset.type = Types.con(this.moduleName, ruleset.name);
            ruleset.className = this.compilationContext.namingPolicy.getDataTypeClassName(ruleset.name);
            StandardTypeConstructor typeConstructor = new StandardTypeConstructor(ruleset.type, Kinds.STAR, TypeDesc.forClass(ruleset.className), ruleset.documentation == null ? null : ruleset.documentation.documentation);
            typeConstructor.external = true;
            this.addTypeDescriptor(ruleset.location, ruleset.name, typeConstructor);
        }
        this.compilationContext.javaTypeTranslator = this.javaTypeTranslator = new JavaTypeTranslator(this.compilationContext.environment);
    }

    private void addTypeDescriptor(long location, String name, TypeDescriptor typeDescriptor) {
        if (this.module.addTypeDescriptor(name, typeDescriptor)) {
            this.errorLog.log(location, "Type " + name + " has already been defined in this module.");
        }
    }

    public void processTypeAliases(final ArrayList<DTypeAst> typeAliasesAst) {
        final TObjectIntHashMap typeAliasMap = new TObjectIntHashMap();
        int i = 0;
        while (i < typeAliasesAst.size()) {
            typeAliasMap.put((Object)typeAliasesAst.get((int)i).name, i);
            ++i;
        }
        final TIntHashSet tempIntSet = new TIntHashSet();
        final ArrayList orderedTypeAliases = new ArrayList(typeAliasesAst.size());
        new StronglyConnectedComponents(typeAliasesAst.size()){

            @Override
            protected int[] findDependencies(int u) {
                ((DTypeAst)typeAliasesAst.get((int)u)).type.collectReferences((TObjectIntHashMap<String>)typeAliasMap, tempIntSet);
                if (tempIntSet.isEmpty()) {
                    return EMPTY_INT_ARRAY;
                }
                if (tempIntSet.contains(u)) {
                    Elaboration.this.errorLog.log(((DTypeAst)typeAliasesAst.get((int)u)).location, "Type alias has a self reference.");
                    tempIntSet.remove(u);
                }
                int[] result = tempIntSet.toArray();
                tempIntSet.clear();
                return result;
            }

            @Override
            protected void reportComponent(int[] component) {
                if (component.length > 1) {
                    StringBuilder b = new StringBuilder();
                    b.append("Recursively defined type alias (");
                    long minLocation = ((DTypeAst)typeAliasesAst.get((int)component[0])).location;
                    boolean first = true;
                    int[] nArray = component;
                    int n = component.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int u = nArray[n2];
                        DTypeAst typeAlias = (DTypeAst)typeAliasesAst.get(u);
                        if (first) {
                            first = false;
                        } else {
                            b.append(", ");
                        }
                        b.append(typeAlias.name);
                        if (Locations.beginOf(typeAlias.location) < Locations.beginOf(minLocation)) {
                            minLocation = typeAlias.location;
                        }
                        ++n2;
                    }
                    b.append(").");
                    Elaboration.this.errorLog.log(minLocation, b.toString());
                } else {
                    orderedTypeAliases.add((DTypeAst)typeAliasesAst.get(component[0]));
                }
            }
        }.findComponents();
        if (this.errorLog.hasNoErrors()) {
            for (DTypeAst typeAlias : orderedTypeAliases) {
                TypeAlias alias = (TypeAlias)this.module.getTypeDescriptor(typeAlias.name);
                TypeTranslationContext context = this.createTypeTranslationContext();
                int i2 = 0;
                while (i2 < typeAlias.parameters.length) {
                    context.pushTypeVar(typeAlias.parameters[i2]);
                    ++i2;
                }
                alias.body = typeAlias.type.toType(context, Kinds.metaVar());
                i2 = 0;
                while (i2 < typeAlias.parameters.length) {
                    alias.parameters[i2] = context.popTypeVar(typeAlias.parameters[i2], null);
                    ++i2;
                }
            }
        }
    }

    public void processDataTypes(ArrayList<DDataAst> dataTypesAst) {
        ArrayList<2> fieldAccessorGenerators = new ArrayList<2>();
        for (DDataAst dDataAst : dataTypesAst) {
            boolean trivialDataType;
            TypeTranslationContext context = this.createTypeTranslationContext();
            TVar[] typeParameters = new TVar[dDataAst.parameters.length];
            int i = 0;
            while (i < dDataAst.parameters.length) {
                typeParameters[i] = context.addTypeVar(dDataAst.parameters[i]);
                ++i;
            }
            Constructor[] constructors = new Constructor[dDataAst.constructors.length];
            String className = null;
            boolean external = false;
            for (DAnnotationAst annotation : dDataAst.getAnnotations()) {
                if (!annotation.id.text.equals("@JavaType")) continue;
                if (annotation.parameters.length != 1 || !(annotation.parameters[0] instanceof ELiteral) || !(((ELiteral)annotation.parameters[0]).getValue() instanceof StringConstant)) {
                    this.errorLog.log(annotation.location, "Invalid parameters. Expected @JavaType \"className\".");
                    continue;
                }
                className = ((StringConstant)((ELiteral)annotation.parameters[0]).getValue()).getValue().replace('.', '/');
                external = true;
                break;
            }
            boolean bl = trivialDataType = dDataAst.constructors.length == 1 && dDataAst.constructors[0].parameters.length == 1;
            if (className == null && !trivialDataType) {
                className = this.compilationContext.namingPolicy.getDataTypeClassName(dDataAst.name);
            }
            final StandardTypeConstructor dataType = dDataAst.typeConstructor;
            dataType.setType(Types.con(this.moduleName, dDataAst.name), typeParameters);
            dataType.setConstructors(constructors);
            if (!trivialDataType) {
                dataType.setTypeDesc(TypeDesc.forClass(className));
            }
            if (!external || dDataAst.constructors.length > 0) {
                dataType.isOpen = false;
            }
            dataType.external = external;
            this.dataTypes.add(dataType);
            int j = 0;
            while (j < constructors.length) {
                ConstructorAst constructor = dDataAst.constructors[j];
                String name = constructor.name.text;
                Type[] parameterTypes = new Type[constructor.parameters.length];
                int i2 = constructor.parameters.length - 1;
                while (i2 >= 0) {
                    parameterTypes[i2] = context.toType(constructor.parameters[i2]);
                    --i2;
                }
                String javaName = constructors.length == 1 ? className : this.compilationContext.namingPolicy.getConstructorClassName(name);
                String[] fieldNames = null;
                DAnnotationAst[] dAnnotationAstArray = constructor.annotations;
                int n = constructor.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    DAnnotationAst annotation = dAnnotationAstArray[n2];
                    if (annotation.id.text.equals("@JavaType")) {
                        try {
                            javaName = ((StringConstant)((ELiteral)annotation.parameters[0]).getValue()).getValue();
                        }
                        catch (Exception exception) {
                            this.errorLog.log(annotation.parameters[0].location, "Invalid annotation parameter.");
                        }
                    } else if (annotation.id.text.equals("@FieldNames")) {
                        try {
                            EListLiteral literal = (EListLiteral)annotation.parameters[0];
                            fieldNames = new String[literal.getComponents().length];
                            int i3 = 0;
                            while (i3 < fieldNames.length) {
                                Expression component = literal.getComponents()[i3];
                                if (component instanceof EVar) {
                                    fieldNames[i3] = ((EVar)component).name;
                                } else if (component instanceof ELiteral) {
                                    fieldNames[i3] = ((StringConstant)((ELiteral)component).getValue()).getValue();
                                }
                                ++i3;
                            }
                        }
                        catch (Exception exception) {
                            this.errorLog.log(annotation.parameters[0].location, "Invalid annotation parameter.");
                            fieldNames = null;
                        }
                    }
                    ++n2;
                }
                constructors[j] = new Constructor(constructor.location, dataType, Name.create(this.moduleName, name), parameterTypes, javaName);
                constructors[j].fieldNames = fieldNames;
                constructors[j].recordFieldNames = constructor.fieldNames;
                ++j;
            }
            if (constructors.length != 1) continue;
            final Constructor constructor = constructors[0];
            if (constructor.recordFieldNames == null) continue;
            fieldAccessorGenerators.add(new Runnable(){

                @Override
                public void run() {
                    Type in = Types.apply((Type)dataType.name, dataType.parameters);
                    int i = 0;
                    while (i < constructor.recordFieldNames.length) {
                        Type out = constructor.parameterTypes[i];
                        FunctionValue accessor = trivialDataType ? new SafeCoerce(dataType.parameters, in, out) : new CallJava(dataType.parameters, (Type)Types.NO_EFFECTS, out, new Type[]{in}, new StackItem[]{new ParameterStackItem(0, in)}, new MethodRef.FieldRef(constructor.javaName, constructor.fieldNames != null ? constructor.fieldNames[i] : "c" + i, Elaboration.this.javaTypeTranslator.toTypeDesc(out)), null);
                        Elaboration.this.module.addFieldAccessor(constructor.recordFieldNames[i], accessor);
                        ++i;
                    }
                }
            });
        }
        for (Runnable runnable : fieldAccessorGenerators) {
            runnable.run();
        }
    }

    public void processTypeClasses(ArrayList<ProcessedDClassAst> typeClassesAst) {
        for (ProcessedDClassAst pClassAst : typeClassesAst) {
            DClassAst classAst = pClassAst.orig;
            if (this.module.getTypeClass(classAst.name) != null) {
                this.errorLog.log(classAst.location, "Class " + classAst.name + " has already been defined in this module.");
                continue;
            }
            TypeTranslationContext context = this.createTypeTranslationContext();
            TPred[] classContext = new TPred[classAst.context.length];
            int i = 0;
            while (i < classContext.length) {
                classContext[i] = context.toTFuncApply(classAst.context[i]);
                ++i;
            }
            TVar[] parameters = new TVar[classAst.parameters.length];
            if (classAst.name.equals("Functor") || classAst.name.equals("Monad")) {
                parameters[0] = context.resolveTypeVariable(pClassAst.orig.location, classAst.parameters[0], Kinds.STAR_TO_STAR);
            } else {
                int i2 = 0;
                while (i2 < parameters.length) {
                    parameters[i2] = context.resolveTypeVariable(pClassAst.orig.location, classAst.parameters[i2], Kinds.metaVar());
                    ++i2;
                }
            }
            TCon con = Types.con(this.moduleName, classAst.name);
            TypeClass typeClass = new TypeClass(classAst.location, classContext, con, this.compilationContext.namingPolicy.getTypeClassInterfaceName(con), parameters, Fundep.mapFundeps(classAst.parameters, classAst.fundeps));
            THashMap<String, TypeClassMethod> methods = typeClass.methods;
            for (DValueTypeAst methodDecl : pClassAst.typeDeclarations) {
                try {
                    Type type;
                    try {
                        type = context.toType(methodDecl.type);
                    }
                    catch (SCLSyntaxErrorException e) {
                        this.errorLog.log(e.location, e.getMessage());
                        continue;
                    }
                    EVar[] eVarArray = methodDecl.names;
                    int n = methodDecl.names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EVar name = eVarArray[n2];
                        typeClass.methodNames.add(name.name);
                        methods.put((Object)name.name, (Object)new TypeClassMethod(typeClass, name.name, this.compilationContext.namingPolicy.getMethodName(name.name), type, Types.getArity(type), name.location));
                        ++n2;
                    }
                }
                catch (RuntimeException e) {
                    this.errorLog.setExceptionPosition(methodDecl.location);
                    throw e;
                }
            }
            for (String methodName : pClassAst.defaultImplementations.getValueNames()) {
                String fullName = "_" + classAst.name + "_default_" + methodName;
                ArrayList<DValueAst> defs = pClassAst.defaultImplementations.getDefinition(methodName);
                TypeClassMethod method = (TypeClassMethod)typeClass.methods.get((Object)methodName);
                if (method == null) {
                    this.errorLog.log(defs.get((int)0).location, "Method " + methodName + " is not defined in this class.");
                    continue;
                }
                method.setDefaultImplementation(Name.create(this.moduleName, fullName));
                this.valueDefinitionsAst.addDefinitions(fullName, defs);
                this.supplementedTypeAnnotations.add(new SupplementedValueType(defs.get((int)0).location, fullName, method.getType()));
                this.valueDefinitionsAst.setDerived(fullName);
            }
            this.module.addTypeClass(classAst.name, typeClass);
        }
    }

    private TypeTranslationContext createTypeTranslationContext() {
        return new TypeTranslationContext(this.compilationContext);
    }

    public void processDerivingInstances(ArrayList<DDerivingInstanceAst> derivingInstancesAst, ArrayList<ProcessedDInstanceAst> instancesAst) {
        for (DDerivingInstanceAst derivingInstance : derivingInstancesAst) {
            TCon con;
            String name = derivingInstance.name.name;
            try {
                con = Environments.getTypeClassName(this.compilationContext.environment, name);
            }
            catch (AmbiguousNameException e) {
                this.errorLog.log(derivingInstance.name.location, e.getMessage());
                continue;
            }
            if (con == null) {
                this.errorLog.log(derivingInstance.name.location, "Couldn't resolve class " + name + ".");
                continue;
            }
            InstanceDeriver deriver = InstanceDerivers.get(con);
            if (deriver == null) {
                this.errorLog.log(derivingInstance.location, "Doesn't know how to derive " + name + ".");
                continue;
            }
            deriver.derive(this.errorLog, this.compilationContext.environment, instancesAst, derivingInstance);
        }
    }

    public void processInstances(ArrayList<ProcessedDInstanceAst> instancesAst) {
        THashSet instanceClashCheckSet = new THashSet();
        for (ProcessedDInstanceAst pInstanceAst : instancesAst) {
            DInstanceAst instanceAst = pInstanceAst.orig;
            try {
                TypeClass typeClass;
                TCon typeClassCon;
                TypeTranslationContext context = this.createTypeTranslationContext();
                String name = instanceAst.name.name;
                try {
                    typeClassCon = Environments.getTypeClassName(this.compilationContext.environment, name);
                }
                catch (AmbiguousNameException e) {
                    this.errorLog.log(instanceAst.name.location, e.getMessage());
                    continue;
                }
                if (typeClassCon == null) {
                    this.errorLog.log(instanceAst.name.location, "Couldn't resolve class " + name + ".");
                    continue;
                }
                pInstanceAst.typeClass = typeClass = this.compilationContext.environment.getTypeClass(typeClassCon);
                if (instanceAst.types.length != typeClass.parameters.length) {
                    this.errorLog.log(instanceAst.location, "Wrong number of parameters to type class " + typeClassCon.name + ".");
                    continue;
                }
                Type[] parameters = new Type[instanceAst.types.length];
                int i = 0;
                while (i < parameters.length) {
                    parameters[i] = context.toType(instanceAst.types[i], typeClass.parameters[i].getKind());
                    ++i;
                }
                TPred instance = Types.pred(typeClassCon, parameters);
                if (!instanceClashCheckSet.add((Object)instance)) {
                    this.errorLog.log(instanceAst.location, "Duplicate definition of the instance " + instance + ".");
                    continue;
                }
                Type[] instanceContext = new TPred[instanceAst.context.length];
                int i2 = 0;
                while (i2 < instanceContext.length) {
                    instanceContext[i2] = context.toTFuncApply(instanceAst.context[i2]);
                    ++i2;
                }
                String javaName = this.compilationContext.namingPolicy.getInstanceClassName(instance);
                String instancePrefix = String.valueOf(instance.toName()) + "$";
                ValueRepository valueDefs = pInstanceAst.valueDefs;
                THashMap methodImplementations = new THashMap();
                for (String valueName : valueDefs.getValueNames()) {
                    String fullName = String.valueOf(instancePrefix) + valueName;
                    long loc = valueDefs.getDefinition((String)valueName).get((int)0).location;
                    this.valueDefinitionsAst.addFrom(valueDefs, valueName, fullName);
                    this.valueDefinitionsAst.setDerived(fullName);
                    TypeClassMethod method = (TypeClassMethod)typeClass.methods.get((Object)valueName);
                    if (method == null) {
                        this.errorLog.log(loc, "Method " + valueName + " is not defined in the type class " + typeClass.name.name + ".");
                        continue;
                    }
                    Type type = method.getBaseType().replace(typeClass.parameters, parameters);
                    int i3 = instanceContext.length - 1;
                    while (i3 >= 0) {
                        type = Types.constrained((TPred)instanceContext[i3], type);
                        --i3;
                    }
                    this.supplementedTypeAnnotations.add(new SupplementedValueType(loc, fullName, type));
                    methodImplementations.put((Object)valueName, (Object)new MethodImplementation(Name.create(this.moduleName, fullName), false));
                }
                for (String methodName : typeClass.methods.keySet()) {
                    if (methodImplementations.containsKey((Object)methodName)) continue;
                    Name defaultImplementation = ((TypeClassMethod)typeClass.methods.get((Object)methodName)).getDefaultImplementation();
                    if (defaultImplementation == null) {
                        this.errorLog.log(instanceAst.location, "Method " + methodName + " is not defined.");
                        continue;
                    }
                    methodImplementations.put((Object)methodName, (Object)new MethodImplementation(defaultImplementation, true));
                }
                JavaTypeInstanceConstructor generator = new JavaTypeInstanceConstructor(javaName, (Type)instance, instanceContext);
                if (instanceContext.length == 0) {
                    generator.setHasStaticInstance(true);
                }
                TypeClassInstance typeClassInstance = new TypeClassInstance(instanceAst.location, typeClass, generator, generator.getTypeParameters(), (TPred[])instanceContext, instance, (THashMap<String, MethodImplementation>)methodImplementations, javaName);
                generator.setInstance(typeClassInstance);
                this.module.addTypeClassInstance(typeClassCon, typeClassInstance);
            }
            catch (RuntimeException e) {
                this.errorLog.setExceptionPosition(instanceAst.location);
                throw e;
            }
        }
        for (ArrayList instanceArray : this.module.getTypeInstances().values()) {
            for (TypeClassInstance instance : instanceArray) {
                try {
                    TypeClass typeClass = instance.typeClass;
                    int superCount = typeClass.context.length;
                    instance.superExpressions = new SCLValue[superCount];
                    int i = 0;
                    while (i < superCount) {
                        TPred type = (TPred)typeClass.context[i].replace(typeClass.parameters, instance.instance.parameters);
                        SCLValue value = new SCLValue(Name.create(this.moduleName, String.valueOf(instance.javaName.substring(instance.javaName.indexOf(36) + 1)) + "_super" + i));
                        this.module.addValue(value);
                        EGetConstraint expression = new EGetConstraint(instance.location, type);
                        value.setExpression(expression);
                        value.setType(Types.forAll(instance.generatorParameters, Types.constrained(instance.context, (Type)type)));
                        value.getProperties().add(new InlineProperty(instance.context.length, -1));
                        instance.superExpressions[i] = value;
                        ++i;
                    }
                }
                catch (RuntimeException e) {
                    this.errorLog.setExceptionPosition(instance.getLocation());
                    throw e;
                }
            }
        }
    }

    public void processJavaMethods(ArrayList<JavaMethodDeclaration> javaMethodDeclarations) {
        for (JavaMethodDeclaration javaMethod : javaMethodDeclarations) {
            Type type;
            CallJava callJava;
            String name;
            String javaName = name = javaMethod.methodName.name;
            ArrayList<DAnnotationAst> annotations = this.valueDefinitionsAst.getAnnotations(name);
            boolean isPrivate = false;
            if (annotations != null) {
                for (DAnnotationAst annotation : annotations) {
                    if (annotation.id.text.equals("@JavaName")) {
                        String temp = AnnotationUtils.processStringAnnotation(this.errorLog, annotation);
                        if (temp == null) continue;
                        javaName = temp;
                        continue;
                    }
                    if (!annotation.id.text.equals("@private")) continue;
                    AnnotationUtils.processTagAnnotation(this.errorLog, annotation);
                    isPrivate = true;
                }
            }
            if ((callJava = this.resolveMethod(javaMethod.location, javaMethod.className, javaName, type = this.createTypeTranslationContext().toType(javaMethod.type))) == null) continue;
            NameExistenceChecks.checkIfValueExists(this.errorLog, javaMethod.location, this.importedEnvironment, this.module, name);
            SCLValue value = this.module.addValue(name, callJava);
            value.definitionLocation = javaMethod.methodName.location;
            if (!isPrivate) continue;
            value.addProperty(PrivateProperty.INSTANCE);
        }
    }

    public void processRulesets(ArrayList<DRulesetAst> rulesetsAst) {
        for (DRulesetAst ruleset : rulesetsAst) {
            String constructorName = "create" + ruleset.name;
            this.supplementedTypeAnnotations.add(new SupplementedValueType(ruleset.location, constructorName, Types.functionE(Types.PUNIT, (Type)Types.PROC, (Type)ruleset.type)));
            try {
                this.valueDefinitionsAst.add(new DValueAst(new EVar(constructorName), new EPreCHRRulesetConstructor(ruleset)));
            }
            catch (NotPatternException e) {
                throw new InternalCompilerError(ruleset.location, (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private CallJava resolveMethod(long loc, String className, String methodName, Type type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CallJava matchType(MethodRef methodRef, Type type) {
        TypeDesc expectedReturnType;
        type = Types.canonical(type);
        while (type instanceof TForAll) {
            type = Types.canonical(((TForAll)type).type);
        }
        TypeDesc[] expectedParameterTypes = methodRef.getParameterTypes();
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        Type effect = Types.NO_EFFECTS;
        Type returnType = type;
        StackItem[] stackItems = new StackItem[expectedParameterTypes.length];
        TIntArrayList unresolvedItems = new TIntArrayList();
        int i = 0;
        block1: while (i < expectedParameterTypes.length) {
            block21: {
                Type parameterType;
                Object providedParameterType;
                do {
                    if (effect != Types.NO_EFFECTS || !(returnType instanceof TFun)) {
                        while (i < expectedParameterTypes.length) {
                            unresolvedItems.add(i++);
                        }
                        break block1;
                    }
                    TFun fun = (TFun)returnType;
                    parameterType = Types.canonical(fun.domain);
                    parameterTypes.add(parameterType);
                    effect = Types.canonical(fun.effect);
                    returnType = Types.canonical(fun.range);
                } while (((TypeDesc)(providedParameterType = this.javaTypeTranslator.toTypeDesc(parameterType))).equals(TypeDesc.VOID));
                do {
                    TypeDesc expectedParameterType;
                    if (this.javaReferenceValidator.isAssignableFrom(expectedParameterType = expectedParameterTypes[i], (TypeDesc)providedParameterType)) {
                        stackItems[i] = new ParameterStackItem(parameterTypes.size() - 1, parameterType);
                        break block21;
                    }
                    unresolvedItems.add(i++);
                } while (i != expectedParameterTypes.length);
                parameterTypes.remove(parameterTypes.size() - 1);
                returnType = Types.functionE(parameterType, effect, returnType);
            }
            ++i;
        }
        if (!unresolvedItems.isEmpty()) {
            ArrayList<TCon> concreteEffects = new ArrayList<TCon>();
            ((Type)effect).collectConcreteEffects(concreteEffects);
            for (TCon eff : concreteEffects) {
                EffectConstructor effC = this.compilationContext.environment.getEffectConstructor(eff);
                for (ThreadLocalVariable var : effC.getThreadLocalVariables()) {
                    int i2 = 0;
                    while (i2 < unresolvedItems.size()) {
                        int id = unresolvedItems.get(i2);
                        if (!expectedParameterTypes[id].equals(TypeDesc.OBJECT) && this.javaReferenceValidator.isAssignableFrom(expectedParameterTypes[id], var.type)) {
                            stackItems[id] = new ThreadLocalStackItem(var.variableName, var.type);
                            unresolvedItems.removeAt(i2);
                            --i2;
                        }
                        ++i2;
                    }
                }
            }
            if (!unresolvedItems.isEmpty()) {
                return null;
            }
        }
        Enum filter = null;
        TypeDesc providedReturnType = methodRef.getReturnType();
        if (!providedReturnType.equals(Constants.FUNCTION)) {
            while (returnType instanceof TFun && effect == Types.NO_EFFECTS) {
                TFun fun = (TFun)returnType;
                Type parameterType = Types.canonical(fun.domain);
                if (!this.javaTypeTranslator.toTypeDesc(parameterType).equals(TypeDesc.VOID)) {
                    return null;
                }
                parameterTypes.add(parameterType);
                effect = Types.canonical(fun.effect);
                returnType = Types.canonical(fun.range);
            }
        }
        if (!this.javaReferenceValidator.isAssignableFrom(expectedReturnType = this.javaTypeTranslator.toTypeDesc(returnType), providedReturnType)) {
            if (expectedReturnType.equals(TypeDesc.VOID)) {
                filter = providedReturnType.equals(TypeDesc.DOUBLE) || providedReturnType.equals(TypeDesc.LONG) ? Pop2OutputFilter.INSTANCE : PopOutputFilter.INSTANCE;
            } else if (expectedReturnType.equals(Constants.LIST) && providedReturnType.equals(Constants.COLLECTION)) {
                filter = ConvertToListFilter.INSTANCE;
            } else {
                return null;
            }
        }
        CallJava result = new CallJava(Types.freeVarsArray(type), effect, returnType, parameterTypes.toArray(new Type[parameterTypes.size()]), stackItems, methodRef, (OutputFilter)((Object)filter));
        return result;
    }

    public void processMappingRelations(ArrayList<DMappingRelationAst> mappingRelationsAst) {
        for (DMappingRelationAst mappingRelation : mappingRelationsAst) {
            TypeAst[] parameterTypesAst = mappingRelation.parameterTypes;
            Type[] parameterTypes = new Type[parameterTypesAst.length];
            TypeTranslationContext typeTranslationContext = this.createTypeTranslationContext();
            int i = 0;
            while (i < parameterTypes.length) {
                parameterTypes[i] = parameterTypesAst[i].toType(typeTranslationContext, Kinds.STAR);
                ++i;
            }
            MappingRelation mRel = new MappingRelation(Name.create(this.moduleName, mappingRelation.name), parameterTypes);
            mRel.location = mappingRelation.location;
            if (!this.module.addMappingRelation(mRel)) continue;
            this.errorLog.log(mappingRelation.location, "Mapping relation " + mappingRelation.name + " has already been defined.");
        }
    }

    public void processRules(ArrayList<DRuleAst> rulesAst) {
        for (DRuleAst ruleA : rulesAst) {
            ArrayList whereSection = (ArrayList)ruleA.getSections().get((Object)"where");
            if (whereSection != null) {
                for (Query query : whereSection) {
                    String name;
                    EApply apply;
                    if (!(query instanceof QPreGuard)) continue;
                    QPreGuard guard = (QPreGuard)query;
                    if (!(guard.guard instanceof EApply) || !((apply = (EApply)guard.guard).getFunction() instanceof EVar) || this.module.getMappingRelation(name = ((EVar)apply.getFunction()).name) != null) continue;
                    int arity = apply.getParameters().length;
                    Type[] parameterTypes = new Type[arity];
                    int i = 0;
                    while (i < arity) {
                        parameterTypes[i] = Types.metaVar(Kinds.STAR);
                        ++i;
                    }
                    MappingRelation mRel = new MappingRelation(Name.create(this.moduleName, name), parameterTypes);
                    mRel.location = query.location;
                    this.module.addMappingRelation(mRel);
                }
            }
            if (this.ruleAstMap.put((Object)ruleA.name, (Object)ruleA) == null) continue;
            this.errorLog.log(ruleA.location, "Rule " + ruleA.name + " has already been defined.");
        }
        for (String ruleName : this.ruleAstMap.keySet()) {
            this.processRule(ruleName);
        }
    }

    private TransformationRule processRule(String ruleName) {
        Variable[] variables;
        TransformationRule[] extendsRules;
        TransformationRule rule = this.module.getRule(ruleName);
        if (rule != null) {
            return rule;
        }
        DRuleAst ruleAst = (DRuleAst)this.ruleAstMap.get((Object)ruleName);
        if (ruleAst.alreadyProcessing) {
            this.errorLog.log(ruleAst.location, "Cyclic chain of rule extensions.");
            return null;
        }
        int length = ruleAst.extendsNames.length;
        if (length == 0) {
            extendsRules = TransformationRule.EMPTY_ARRAY;
        } else {
            extendsRules = new TransformationRule[length];
            int i = 0;
            while (i < length) {
                try {
                    TransformationRule extendsRule;
                    String extendsName = ruleAst.extendsNames[i];
                    if (this.ruleAstMap.containsKey((Object)extendsName)) {
                        extendsRule = this.processRule(extendsName);
                    } else {
                        extendsRule = Environments.getRule(this.compilationContext.environment, extendsName);
                        if (extendsRule == null) {
                            this.errorLog.log(ruleAst.location, "Couldn't resolve rule name " + extendsName + ".");
                        }
                    }
                    extendsRules[i] = extendsRule;
                }
                catch (AmbiguousNameException e) {
                    this.errorLog.log(ruleAst.location, e.getMessage());
                }
                ++i;
            }
        }
        final THashMap sections = new THashMap();
        final TranslationContext context = this.createTranslationContext(ruleName);
        if (length > 0) {
            variables = context.getVariables();
            TransformationRule[] transformationRuleArray = extendsRules;
            int n = extendsRules.length;
            int n2 = 0;
            while (n2 < n) {
                TransformationRule extendsRule = transformationRuleArray[n2];
                if (extendsRule != null) {
                    Variable[] variableArray = extendsRule.variables;
                    int n3 = extendsRule.variables.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Variable var = variableArray[n4];
                        if (variables.put((Object)var.getName(), (Object)var) != null) {
                            this.errorLog.log(ruleAst.location, "Variable " + var.getName() + " is defined in more than one base rule, which is not currently allowed.");
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        context.pushExistentialFrame();
        ruleAst.getSections().forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, ArrayList<Query>>(){

            public boolean execute(String sectionNameString, ArrayList<Query> queries) {
                Query[] resolvedQueries = new Query[queries.size()];
                int i = 0;
                while (i < resolvedQueries.length) {
                    resolvedQueries[i] = queries.get(i).resolve(context);
                    ++i;
                }
                SectionName sectionName = SectionName.getSectionName(sectionNameString);
                if (sectionName == null) {
                    context.getErrorLog().log(queries.get((int)0).location, "Invalid section name " + sectionNameString + ".");
                } else {
                    sections.put((Object)sectionName, (Object)resolvedQueries);
                }
                return true;
            }
        });
        variables = context.getVariables().values().toArray(new Variable[context.getVariables().size()]);
        rule = new TransformationRule(ruleAst.isAbstract, Name.create(this.moduleName, ruleAst.name), extendsRules, (THashMap<SectionName, Query[]>)sections, variables);
        rule.location = ruleAst.location;
        this.module.addRule(rule);
        return rule;
    }

    public void addDataTypesToEnvironment() {
        for (StandardTypeConstructor dataType : this.dataTypes) {
            int constructorTag = 0;
            Constructor[] constructorArray = dataType.constructors;
            int n = dataType.constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor constructor = constructorArray[n2];
                SCLValue value = new SCLValue(constructor.name);
                value.definitionLocation = constructor.loc;
                SCLConstructor sclConstructor = new SCLConstructor(constructor.name.name, constructor.javaName, constructor.getTypeVariables(), constructorTag++, constructor.getReturnType(), constructor.fieldNames == null ? SCLConstructor.DEFAULT_FIELD_NAMES[constructor.getParameterTypes().length] : constructor.fieldNames, constructor.recordFieldNames, constructor.getParameterTypes());
                if (dataType.constructors.length == 1 && (dataType.getTypeDesc() == null || dataType.constructors[0].javaName != null && dataType.constructors[0].javaName.equals(MethodBuilderBase.getClassName(dataType.getTypeDesc())))) {
                    sclConstructor.setOnlyConstructor(true);
                }
                value.setValue(sclConstructor);
                value.setType(constructor.getType());
                NameExistenceChecks.checkIfValueExists(this.errorLog, constructor.loc, this.importedEnvironment, this.module, constructor.name.name);
                if (this.module.addValue(value)) {
                    this.errorLog.log(constructor.loc, "Value " + constructor.name.name + " is already defined.");
                }
                ++n2;
            }
        }
    }

    public void addTypeClassesToEnvironment() {
        for (TypeClass typeClass : this.module.getTypeClasses()) {
            for (TypeClassMethod method : typeClass.methods.values()) {
                SCLValue value = method.createValue();
                value.definitionLocation = method.location;
                NameExistenceChecks.checkIfValueExists(this.errorLog, 9223372034707292160L, this.importedEnvironment, this.module, value.getName().name);
                if (!this.module.addValue(value)) continue;
                String name = method.getName();
                long location = 9223372034707292160L;
                ArrayList<DValueAst> definitions = this.valueDefinitionsAst.getDefinition(name);
                if (definitions != null && !definitions.isEmpty()) {
                    location = definitions.get((int)0).location;
                }
                this.errorLog.log(location, "Value " + name + " is already defined.");
            }
        }
    }

    public void preprocessValueDefinitions(ArrayList<DValueTypeAst> typeAnnotationsAst) {
        for (String name : this.valueDefinitionsAst.getValueNames()) {
            SCLValue value = new SCLValue(Name.create(this.moduleName, name));
            long location = this.valueDefinitionsAst.getLocation(name);
            NameExistenceChecks.checkIfValueExists(this.errorLog, location, this.importedEnvironment, this.module, value.getName().name);
            value.definitionLocation = location;
            if (this.module.addValue(value)) {
                this.errorLog.log(location, "Value " + name + " is already defined.");
            }
            if (!this.valueDefinitionsAst.isDerived(name)) continue;
            value.addProperty(DerivedProperty.INSTANCE);
        }
        for (DValueTypeAst valueTypeAst : typeAnnotationsAst) {
            EVar[] eVarArray = valueTypeAst.names;
            int n = valueTypeAst.names.length;
            int n2 = 0;
            while (n2 < n) {
                EVar name = eVarArray[n2];
                SCLValue value = this.module.getValue(name.name);
                if (value == null) {
                    this.errorLog.log(valueTypeAst.location, String.valueOf(name.name) + " is not defined.");
                    value = new SCLValue(Name.create(this.moduleName, name.name));
                    this.module.addValue(value);
                }
                value.definitionLocation = name.location;
                ++n2;
            }
        }
        for (String name : this.relationDefinitionsAst.getRelationNames()) {
            ConcreteRelation relation = new ConcreteRelation(name);
            this.module.addRelation(name, relation);
        }
    }

    public void addValueDefinitionsToEnvironment(ArrayList<DValueTypeAst> typeAnnotationsAst) {
        Expression expression;
        TranslationContext context;
        THashMap typeMap = new THashMap();
        for (DValueTypeAst valueTypeAst : typeAnnotationsAst) {
            EVar[] eVarArray = valueTypeAst.names;
            int n = valueTypeAst.names.length;
            int n2 = 0;
            while (n2 < n) {
                EVar name = eVarArray[n2];
                if (typeMap.containsKey((Object)name.name)) {
                    this.errorLog.log(valueTypeAst.location, "Type of " + name.name + " has already been declared in this module.");
                } else {
                    typeMap.put((Object)name.name, (Object)valueTypeAst);
                }
                ++n2;
            }
        }
        THashMap exportMap = null;
        if (this.moduleHeader != null && this.moduleHeader.export != null) {
            exportMap = new THashMap();
            for (EVar export : this.moduleHeader.export) {
                if (exportMap.put((Object)export.name, (Object)export) == null) continue;
                this.errorLog.log(export.location, "The symbol " + export.name + " is exported multiple times.");
            }
        }
        for (String name : this.valueDefinitionsAst.getValueNames()) {
            ArrayList<DValueAst> defs = this.valueDefinitionsAst.getDefinition(name);
            if (defs.size() != 1 || !(defs.get((int)0).value instanceof EPreCHRRulesetConstructor)) continue;
            try {
                SCLValue value = this.module.getValue(name);
                context = this.createTranslationContext(name);
                expression = context.translateCases2(defs);
                value.setExpression(expression);
                if (exportMap == null || exportMap.remove((Object)name) != null) continue;
                value.addProperty(PrivateProperty.INSTANCE);
            }
            catch (RuntimeException e) {
                this.errorLog.setExceptionPosition(defs.get((int)0).location);
                throw e;
            }
        }
        for (String name : this.valueDefinitionsAst.getValueNames()) {
            ArrayList<DValueAst> defs = this.valueDefinitionsAst.getDefinition(name);
            if (defs.size() == 1 && defs.get((int)0).value instanceof EPreCHRRulesetConstructor) continue;
            try {
                ArrayList<DAnnotationAst> annotations;
                SCLValue value = this.module.getValue(name);
                context = this.createTranslationContext(name);
                expression = context.translateCases2(defs);
                value.setExpression(expression);
                DValueTypeAst valueTypeAst = (DValueTypeAst)typeMap.remove((Object)name);
                if (valueTypeAst != null) {
                    value.setType(Types.closure(context.toType(valueTypeAst.type)));
                }
                if ((annotations = this.valueDefinitionsAst.getAnnotations(name)) != null) {
                    for (DAnnotationAst annotation : annotations) {
                        this.handleAnnotation(value, defs, annotation);
                    }
                }
                if (exportMap == null || exportMap.remove((Object)name) != null) continue;
                value.addProperty(PrivateProperty.INSTANCE);
            }
            catch (RuntimeException e) {
                this.errorLog.setExceptionPosition(defs.get((int)0).location);
                throw e;
            }
        }
        if (exportMap != null) {
            for (EVar export : exportMap.values()) {
                this.errorLog.log(export.location, "The symbol " + export.name + " is not defined in the module.");
            }
        }
        for (String name : this.relationDefinitionsAst.getRelationNames()) {
            ArrayList<DRelationAst> definitions = this.relationDefinitionsAst.getDefinition(name);
            if (definitions.size() > 1) {
                this.errorLog.log(definitions.get((int)1).location, "Does not yet support definition of relations by more than one rule.");
                continue;
            }
            DRelationAst definition = definitions.get(0);
            ConcreteRelation relation = (ConcreteRelation)this.module.getRelation(name);
            relation.location = definition.location;
            TranslationContext context2 = this.createTranslationContext(name);
            definition.translateTo(context2, relation);
        }
    }

    private TranslationContext createTranslationContext(String definitionName) {
        return new TranslationContext(this.compilationContext, null, definitionName);
    }

    private void handleAnnotation(SCLValue value, ArrayList<DValueAst> defs, DAnnotationAst annotation) {
        if (annotation.id.text.equals("@macro")) {
            value.setMacroRule(new StandardMacroRule());
        } else if (annotation.id.text.equals("@inline")) {
            try {
                int arity = defs.get((int)0).lhs.getFunctionDefinitionPatternArity();
                int phaseMask = -1;
                if (annotation.parameters.length > 0) {
                    phaseMask = Integer.parseInt(((EIntegerLiteral)annotation.parameters[0]).getValue());
                }
                value.addProperty(new InlineProperty(arity, phaseMask));
            }
            catch (NotPatternException notPatternException) {
                this.errorLog.log(annotation.location, "Inline annotation is invalid: this is not a function.");
            }
        } else if (annotation.id.text.equals("@private")) {
            if (this.moduleHeader != null && this.moduleHeader.export != null) {
                this.errorLog.log(annotation.location, "Annotation @private is not used when module header contains export property.");
            }
            value.addProperty(PrivateProperty.INSTANCE);
        } else if (annotation.id.text.equals("@deprecated")) {
            String description = "";
            if (annotation.parameters.length > 0) {
                if (annotation.parameters.length > 1) {
                    this.errorLog.log(annotation.location, "Invalid number of parameters, expected one string.");
                } else {
                    String temp = AnnotationUtils.extractString(annotation.parameters[0]);
                    if (temp == null) {
                        this.errorLog.log(annotation.location, "Invalid parameter, expected one string.");
                    } else {
                        description = temp;
                    }
                }
            }
            value.addProperty(new DeprecatedProperty(description));
        } else {
            this.errorLog.log(annotation.location, "Unknown annotation.");
        }
    }

    public void addSupplementedTypeAnnotationsToEnvironment() {
        for (SupplementedValueType valueType : this.supplementedTypeAnnotations) {
            Type type = Types.closure(valueType.type);
            String name = valueType.name;
            SCLValue value = this.module.getValue(name);
            if (value == null) {
                this.errorLog.log(valueType.position, String.valueOf(name) + " is not defined.");
                continue;
            }
            if (value.getType() == null) {
                value.setType(type);
                continue;
            }
            this.errorLog.log(valueType.position, "Type of " + name + " has already been declared in this module.");
        }
    }

    public void addFixityToEnvironment(ArrayList<DFixityAst> fixityAst) {
        for (DFixityAst fixity : fixityAst) {
            EVar[] eVarArray = fixity.symbols;
            int n = fixity.symbols.length;
            int n2 = 0;
            while (n2 < n) {
                EVar symbol = eVarArray[n2];
                String name = symbol.name;
                SCLValue value = this.module.getValue(name);
                if (value == null) {
                    this.errorLog.log(symbol.location, String.valueOf(name) + " is not defined.");
                } else {
                    value.setPrecedence(fixity.precedence);
                }
                ++n2;
            }
        }
    }

    public void addCoverageBranchPoints() {
        this.branchPoints = new THashMap();
        BranchPointInjector injector = new BranchPointInjector();
        for (String valueName : this.valueDefinitionsAst.getValueNames()) {
            for (DValueAst valueAst : this.valueDefinitionsAst.getDefinition(valueName)) {
                valueAst.value = injector.injectBranchPoint(valueAst.value);
            }
            this.branchPoints.put((Object)valueName, (Object)injector.getAndClearBranchPoints());
        }
    }

    public void collectDebugInfo() {
        this.module.moduleDebugInfo = this.compilationContext.moduleDebugInfo = new ModuleDebugInfo();
    }
}

