/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.awt.geom.Point2D;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.tableParser.ParseException;
import org.simantics.sysdyn.tableParser.TableParser;
import org.simantics.sysdyn.tableParser.Token;
import org.simantics.sysdyn.ui.properties.widgets.expressions.LookupInputOutputTable;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartTableWidget
implements Widget {
    Text input;
    Text output;
    Button add;
    LookupInputOutputTable table;
    Resource expression;

    public ChartTableWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        Composite valueTableComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)valueTableComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(valueTableComposite);
        this.table = new LookupInputOutputTable(valueTableComposite, 0);
        GridDataFactory.fillDefaults().span(3, 1).grab(false, true).applyTo((Control)this.table);
        this.table.getTableViewer().getTable().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    Table t = (Table)e.widget;
                    TableItem item = t.getItem(new Point(e.x, e.y));
                    ChartTableWidget.this.table.removeItem(t.indexOf(item));
                    ChartTableWidget.this.tableModified();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.input = new Text(valueTableComposite, 133120);
        this.input.setText("");
        this.output = new Text(valueTableComposite, 133120);
        this.output.setText("");
        this.add = new Button(valueTableComposite, 0);
        this.add.setText("Add");
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Double in = Double.parseDouble(ChartTableWidget.this.input.getText());
                    Double out = Double.parseDouble(ChartTableWidget.this.output.getText());
                    ChartTableWidget.this.table.addLocation(new Point2D.Double(in, out));
                    ChartTableWidget.this.tableModified();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ChartTableWidget.this.input.setText("");
                ChartTableWidget.this.output.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FocusListener flistener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text text = (Text)e.widget;
                text.setSelection(0, text.getCharCount());
            }

            public void focusLost(FocusEvent e) {
            }
        };
        KeyListener listener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    block3: {
                        try {
                            Double in = Double.parseDouble(ChartTableWidget.this.input.getText());
                            Double out = Double.parseDouble(ChartTableWidget.this.output.getText());
                            ChartTableWidget.this.table.addLocation(new Point2D.Double(in, out));
                            ChartTableWidget.this.tableModified();
                        }
                        catch (NumberFormatException e1) {
                            if (!ChartTableWidget.this.input.getText().isEmpty() || !ChartTableWidget.this.output.getText().isEmpty()) break block3;
                            ChartTableWidget.this.add.forceFocus();
                            return;
                        }
                    }
                    ChartTableWidget.this.input.setText("");
                    ChartTableWidget.this.output.setText("");
                    ChartTableWidget.this.input.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.input.addFocusListener(flistener);
        this.input.addKeyListener(listener);
        this.output.addFocusListener(flistener);
        this.output.addKeyListener(listener);
    }

    public void setInput(ISessionContext context, Object input) {
        this.expression = (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Resource.class);
        try {
            SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    if (!graph.isInstanceOf(ChartTableWidget.this.expression, sr.WithLookupExpression)) {
                        return null;
                    }
                    return (String)graph.getPossibleRelatedValue(ChartTableWidget.this.expression, sr.WithLookupExpression_lookup);
                }
            }, (org.simantics.db.procedure.Listener)new org.simantics.db.procedure.Listener<String>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(String lookup) {
                    if (lookup == null) {
                        return;
                    }
                    TableParser parser = new TableParser((Reader)new StringReader(""));
                    parser.ReInit((Reader)new StringReader(lookup));
                    ChartTableWidget.this.table.clearTable();
                    try {
                        parser.table();
                        ArrayList xTokens = parser.getXTokens();
                        ArrayList yTokens = parser.getYTokens();
                        int i = 0;
                        while (i < xTokens.size()) {
                            ChartTableWidget.this.table.addLocation(new Point2D.Double(Double.parseDouble(((Token)xTokens.get((int)i)).image), Double.parseDouble(((Token)yTokens.get((int)i)).image)));
                            ++i;
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }

                public boolean isDisposed() {
                    return ChartTableWidget.this.table.isDisposed();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.table.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ChartTableWidget.this.tableModified();
            }
        });
    }

    private void tableModified() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        ArrayList inputOutputList = (ArrayList)this.table.getTableViewer().getInput();
        Collections.sort(inputOutputList, new LookupInputOutputTable.InputOutputComparator(this.table));
        Iterator iterator = inputOutputList.iterator();
        while (iterator.hasNext()) {
            LookupInputOutputTable.InputOutput io = (LookupInputOutputTable.InputOutput)iterator.next();
            b.append("{" + io.getInput(String.class) + "," + io.getOutput(String.class) + "}");
            if (!iterator.hasNext()) continue;
            b.append(",");
        }
        b.append("}");
        final String table = b.toString();
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                graph.claimLiteral(ChartTableWidget.this.expression, sr.WithLookupExpression_lookup, (Object)table);
            }
        });
    }
}

