/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.ConfigurableEdgeVisuals;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.ParentImpl;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.connection.EdgeClass;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.editor.routing.DependencyRouter;
import org.simantics.sysdyn.ui.elements.connections.Arcs;
import org.simantics.sysdyn.ui.elements.connections.DependencyNode;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DependencyEdgeClass {
    public static final float DEFAULT_STROKE_WIDTH = 0.3f;
    public static final ElementClass CLASS = ElementClass.compile((ElementHandler[])new ElementHandler[]{SysdynEdgeSceneGraph.INSTANCE, EdgeClass.EdgeHandler.INSTANCE, new ConfigurableEdgeVisuals(EdgeVisuals.ArrowType.None, EdgeVisuals.ArrowType.Fill, (Stroke)new BasicStroke(0.3f, 0, 1, 10.0f, null, 0.0f), 1.0, 1.0), FillColorImpl.BLACK, EdgeClass.FixedTransform.INSTANCE, TextImpl.INSTANCE, TextColorImpl.BLACK, TextFontImpl.DEFAULT, NodePick.INSTANCE, ConnectionSelectionOutline.INSTANCE, SimpleElementLayers.INSTANCE, ParentImpl.INSTANCE}).setId("EdgeClass.STRAIGHT");

    private static class NodePick
    implements Pick {
        private static final long serialVersionUID = 1L;
        public static NodePick INSTANCE = new NodePick();

        private NodePick() {
        }

        public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
            Rectangle2D pickRect = null;
            pickRect = s instanceof Rectangle2D ? (Rectangle2D)s : s.getBounds2D();
            DependencyNode node = (DependencyNode)e.getHint(SysdynEdgeSceneGraph.KEY_SG_NODE);
            if (node == null) {
                return false;
            }
            return Arcs.hitTest(node.getBeginBounds(), node.getEndBounds(), node.getAngle(), pickRect.getCenterX(), pickRect.getCenterY(), 1.7);
        }
    }

    public static class SysdynEdgeSceneGraph
    implements SceneGraph {
        private static final long serialVersionUID = 2914383071126238996L;
        public static final SysdynEdgeSceneGraph INSTANCE = new SysdynEdgeSceneGraph();
        public static final Stroke ARROW_STROKE = new BasicStroke(1.0f, 0, 0);
        public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(DependencyNode.class, "EDGE_NODE");

        public void init(IElement e, G2DParentNode parent) {
            DependencyNode node = (DependencyNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)KEY_SG_NODE, (String)("edge_" + e.hashCode()), DependencyNode.class);
            Font font = ElementUtils.getTextFont((IElement)e);
            Color color = ElementUtils.getTextColor((IElement)e);
            HashMap properties = (HashMap)e.getHint(DiagramHints.PROPERTIES);
            Pair polarityPair = (Pair)properties.get("polarity");
            Pair polarityLocationPair = (Pair)properties.get("polarityLocation");
            boolean delayMark = properties.containsKey("delayMark");
            boolean arrowHead = !properties.containsKey("hideArrow");
            String location = polarityLocationPair == null ? "Inside" : (String)polarityLocationPair.second;
            String text = polarityPair != null ? (String)polarityPair.second : "";
            node.init(text, location, delayMark, arrowHead, font, color, 0.0, 0.0, 0.235);
            this.update(e);
        }

        public void cleanup(IElement e) {
            ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)KEY_SG_NODE);
        }

        public void update(final IElement e) {
            EdgeClass.EdgeHandler eh;
            Path2D path;
            Topology topology;
            DependencyNode node = (DependencyNode)e.getHint(KEY_SG_NODE);
            if (node == null) {
                return;
            }
            IDiagram diagram = ElementUtils.peekDiagram((IElement)e);
            IElement edgeParent = ElementUtils.getParent((IElement)e);
            Object edgeParentObject = edgeParent != null ? edgeParent.getHint(ElementHints.KEY_OBJECT) : null;
            final Resource parentElement = edgeParentObject instanceof Resource ? (Resource)edgeParentObject : null;
            node.setFieldListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent event) {
                    if (parentElement == null) {
                        return;
                    }
                    String field = event.getPropertyName();
                    Map properties = (Map)e.getHint(DiagramHints.PROPERTIES);
                    if (properties == null) {
                        return;
                    }
                    final Pair property = (Pair)properties.get(field);
                    if (property == null) {
                        return;
                    }
                    try {
                        Simantics.getSession().syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                graph.claimLiteral(parentElement, (Resource)property.first, event.getNewValue());
                            }
                        });
                    }
                    catch (DatabaseException ex) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.sysdyn.ui", "Failed to synchronize property " + field + ".", (Throwable)ex));
                    }
                }
            });
            Shape beginTerminalShape = null;
            Shape endTerminalShape = null;
            if (diagram != null && (topology = (Topology)diagram.getDiagramClass().getAtMostOneItemOfClass(Topology.class)) != null) {
                Topology.Connection beginConnection = topology.getConnection(e, EdgeVisuals.EdgeEnd.Begin);
                Topology.Connection endConnection = topology.getConnection(e, EdgeVisuals.EdgeEnd.End);
                beginTerminalShape = SysdynEdgeSceneGraph.getCanvasTerminalShape(beginConnection);
                endTerminalShape = SysdynEdgeSceneGraph.getCanvasTerminalShape(endConnection);
            }
            if (beginTerminalShape == null || endTerminalShape == null) {
                return;
            }
            EdgeVisuals vh = (EdgeVisuals)e.getElementClass().getSingleItem(EdgeVisuals.class);
            Map properties = (Map)e.getHint(DiagramHints.PROPERTIES);
            Pair strokeWidthPair = (Pair)properties.get("strokeWidth");
            float strokeWidth = strokeWidthPair == null ? 0.3f : ((Float)strokeWidthPair.second).floatValue();
            vh.setStroke(e, (Stroke)new BasicStroke(strokeWidth, 0, 0, 10.0f, null, 0.0f));
            Stroke stroke = vh.getStroke(e);
            Font font = ElementUtils.getTextFont((IElement)e);
            Color color = ElementUtils.getTextColor((IElement)e);
            Color borderColor = ElementUtils.getBorderColor((IElement)e, (Color)Color.BLACK);
            Alignment hAlign = (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)ElementHints.KEY_HORIZONTAL_ALIGN, (Object)Alignment.CENTER);
            node.setBackgroundColor(null);
            node.setBorderColor(borderColor);
            node.setHorizontalAlignment((byte)hAlign.ordinal());
            node.setPadding(0.0, 0.0);
            node.setBorderWidth(0.0f);
            node.setEditable(false);
            node.setFont(font);
            node.setBeginBounds(beginTerminalShape);
            node.setEndBounds(endTerminalShape);
            node.setStroke(stroke);
            node.setColor(color);
            node.setShapes(DependencyRouter.createArrowShape(node.getShapes(), node.getBeginBounds(), node.getEndBounds(), node.getAngle(), node.getStroke()));
            if (properties != null) {
                for (Map.Entry entry : properties.entrySet()) {
                    NodeUtil.setPropertyIfSupported((String)((String)entry.getKey()), (Object)((Pair)entry.getValue()).second, (INode)node);
                }
            }
            if ((path = (eh = (EdgeClass.EdgeHandler)e.getElementClass().getAtMostOneItemOfClass(EdgeClass.EdgeHandler.class)).getPath(e)) == null) {
                path = new Path2D.Double();
            } else {
                path.reset();
            }
            path.append((Shape)node.getShapes().first, false);
            eh.setPath(e, path);
        }

        private static Shape getCanvasTerminalShape(Topology.Connection connection) {
            TerminalLayout layout;
            if (connection != null && connection.node != null && connection.terminal != null && (layout = (TerminalLayout)connection.node.getElementClass().getAtMostOneItemOfClass(TerminalLayout.class)) != null) {
                Shape shp = layout.getTerminalShape(connection.node, connection.terminal);
                Transform tr = (Transform)connection.node.getElementClass().getAtMostOneItemOfClass(Transform.class);
                if (tr == null) {
                    return shp;
                }
                return tr.getTransform(connection.node).createTransformedShape(shp);
            }
            return null;
        }
    }
}

