/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.procedure.TObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.scl.OntologyModule;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.PrecompiledModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OntologyModuleSourceRepository implements ModuleSourceRepository
{
    INSTANCE;

    private static final Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(OntologyModuleSourceRepository.class);
    }

    public ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        if (!moduleName.startsWith("http://")) {
            return null;
        }
        try {
            return (ModuleSource)Simantics.getAvailableRequestProcessor().syncRequest((Read)new ModuleSourceRequest(moduleName));
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read ontology module " + moduleName + ".", (Throwable)e);
            return null;
        }
    }

    public void forAllModules(TObjectProcedure<String> procedure) {
    }

    public Collection<String> getModuleNames() {
        return Collections.emptyList();
    }

    static class ModuleSourceRequest
    extends UnaryRead<String, ModuleSource> {
        public ModuleSourceRequest(String moduleName) {
            super((Object)moduleName);
        }

        public ModuleSource perform(ReadGraph graph) throws DatabaseException {
            return new PrecompiledModuleSource((Module)new OntologyModule(graph, (String)this.parameter), -1.0);
        }
    }
}

