/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLLabelRule
implements LabelRule {
    private Resource rule;

    public SCLLabelRule(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.rule);
        Function1 getLabels = (Function1)ruleVariable.getPossiblePropertyValue(graph, MOD.SCLLabelRule_getLabels);
        if (getLabels == null) {
            return Collections.emptyMap();
        }
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            sclContext.put((Object)"graph", (Object)graph);
            List value = (List)getLabels.apply(content);
            HashMap<String, String> result = new HashMap<String, String>();
            int i = 0;
            while (i < value.size()) {
                result.put((String)value.get(i), (String)value.get(i + 1));
                i += 2;
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }
}

