/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import gnu.trove.list.array.TByteArrayList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.acorn.FileCache;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.LRU;
import org.simantics.acorn.lru.LRUObject;
import org.simantics.db.service.Bytes;
import org.simantics.utils.datastructures.Pair;

public class ChangeSetInfo
extends LRUObject<Long, ChangeSetInfo> {
    private byte[] metadataBytes;
    private ArrayList<String> clusterChangeSetIds;

    public ChangeSetInfo(LRU<Long, ChangeSetInfo> LRU2, FileCache fileCache, Path readDir, Long revision, int offset, int length) throws AcornAccessVerificationException {
        super(LRU2, fileCache, revision, readDir, "clusterStream", offset, length, false, false);
        LRU2.map(this);
    }

    public ChangeSetInfo(LRU<Long, ChangeSetInfo> LRU2, FileCache fileCache, Long revision, byte[] bytes, ArrayList<String> clusterChangeSetIds) throws AcornAccessVerificationException {
        super(LRU2, fileCache, revision, LRU2.getDirectory(), "clusterStream", true, true);
        this.metadataBytes = bytes;
        this.metadataBytes = bytes;
        this.clusterChangeSetIds = clusterChangeSetIds;
        LRU2.insert(this, this.accessTime);
    }

    public ArrayList<String> getCCSIds() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.clusterChangeSetIds;
    }

    public byte[] getMetadataBytes() throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident();
        return this.metadataBytes;
    }

    private static void writeLE(TByteArrayList bytes, int value) {
        bytes.add((byte)(value & 0xFF));
        bytes.add((byte)(value >>> 8 & 0xFF));
        bytes.add((byte)(value >>> 16 & 0xFF));
        bytes.add((byte)(value >>> 24 & 0xFF));
    }

    @Override
    protected Pair<byte[], Integer> toBytes() {
        TByteArrayList result = new TByteArrayList();
        ChangeSetInfo.writeLE(result, this.metadataBytes.length);
        result.add(this.metadataBytes);
        ChangeSetInfo.writeLE(result, this.clusterChangeSetIds.size());
        for (String id : this.clusterChangeSetIds) {
            byte[] bb = id.getBytes();
            ChangeSetInfo.writeLE(result, bb.length);
            result.add(bb);
        }
        this.release();
        byte[] ret = result.toArray();
        return Pair.make((Object)ret, (Object)ret.length);
    }

    @Override
    void release() {
        this.clusterChangeSetIds = null;
        this.metadataBytes = null;
    }

    @Override
    public void fromFile(byte[] data) {
        this.clusterChangeSetIds = new ArrayList();
        int metadataLength = Bytes.readLE4((byte[])data, (int)0);
        this.metadataBytes = Arrays.copyOfRange(data, 4, 4 + metadataLength);
        int offset = 4 + metadataLength;
        int numberOfChangeSets = Bytes.readLE4((byte[])data, (int)offset);
        offset += 4;
        int i = 0;
        while (i < numberOfChangeSets) {
            int length = Bytes.readLE4((byte[])data, (int)offset);
            String id = new String(Arrays.copyOfRange(data, offset += 4, offset + length));
            this.clusterChangeSetIds.add(id);
            offset += length;
            ++i;
        }
    }

    @Override
    String getExtension() {
        return "cs";
    }

    @Override
    protected boolean overwrite() {
        return false;
    }
}

