/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterUpdateProcessorBase;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.service.ClusterUID;

public class ClusterUpdateProcessor
extends ClusterUpdateProcessorBase {
    final ClusterSupport support;
    final ClusterUpdateOperation info;
    private ClusterImpl cluster;

    public ClusterUpdateProcessor(ClusterManager client, ClusterSupport support, byte[] operations, ClusterUpdateOperation info) throws DatabaseException {
        super(client, operations);
        this.support = support;
        this.info = info;
    }

    @Override
    void create() throws DatabaseException {
        this.cluster.createResource(this.support);
    }

    @Override
    void delete(int ri) throws DatabaseException {
        boolean oldValueEx = this.cluster.isValueEx(ri);
        byte[] old = this.cluster.getValue(ri, this.support);
        if (old != null) {
            this.cluster.removeValue(ri, this.support);
        }
        this.info.ccs.oldValueEx.add(oldValueEx ? (byte)1 : 0);
        this.info.ccs.oldValues.add(old);
    }

    @Override
    void modify(int resourceKey, long offset, int size, byte[] bytes, int pos) throws DatabaseException {
        this.cluster = (ClusterImpl)this.cluster.modiValueEx(resourceKey, offset, size, bytes, pos, this.support);
        this.manager.modiFileEx(this.cluster.getClusterUID(), resourceKey, offset, size, bytes, pos, this.support);
    }

    @Override
    void set(int resourceKey, byte[] bytes, int length) throws DatabaseException {
        byte[] old = this.cluster.getValue(resourceKey, this.support);
        boolean oldValueEx = this.cluster.isValueEx(resourceKey);
        this.cluster = (ClusterImpl)this.cluster.setValue(resourceKey, this.valueBuffer, length, this.support);
        this.info.ccs.oldValueEx.add(oldValueEx ? (byte)1 : 0);
        this.info.ccs.oldValues.add(old);
    }

    @Override
    void claim(int resourceKey, int predicateKey, int objectKey, ClusterUID puid, ClusterUID ouid) throws DatabaseException {
        ClusterImpl c = (ClusterImpl)this.cluster.addRelation(resourceKey, puid, predicateKey, ouid, objectKey, this.support);
        if (c != null) {
            this.cluster = c;
        }
        this.info.ccs.statementMask.add(c != null ? (byte)1 : 0);
    }

    @Override
    void deny(int resourceKey, int predicateKey, int objectKey, ClusterUID puid, ClusterUID ouid) throws DatabaseException {
        boolean modified = this.cluster.removeRelation(resourceKey, predicateKey, objectKey, this.support);
        this.info.ccs.statementMask.add(modified ? (byte)1 : 0);
    }

    public ClusterImpl process(ClusterImpl cluster) throws IllegalAcornStateException {
        this.cluster = cluster;
        this.process();
        this.info.finish();
        return this.cluster;
    }
}

